/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.elasticsearch.util.ESUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.util.StringUtils;

public class CommonUtil {
    public static String getIndexNamePrefix(String region) {
        String index = (String)ESUtil.getServerConfig((String)region).get("index");
        String accountId = RequestContext.get().getAccountId();
        String tennatString = RequestContext.get().getTenantId();
        if (StringUtils.isEmpty((String)accountId)) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"getAccountIdtr error:" + accountId});
        }
        if (StringUtils.isEmpty((String)tennatString)) {
            return index + "_" + accountId.toLowerCase().replace("_", "");
        }
        return (index + "_" + tennatString + "_" + accountId.replace("_", "")).toLowerCase();
    }

    public static Map<String, Integer> getIndexSettings(String region) {
        HashMap<String, Integer> result = new HashMap<String, Integer>(3);
        Map configMap = ESUtil.getServerConfig((String)region);
        result.put("index.mapping.total_fields.limit", Integer.valueOf((String)configMap.get("totalfields")));
        result.put("number_of_replicas", Integer.valueOf((String)configMap.get("replicasnumber")));
        result.put("number_of_shards", Integer.valueOf((String)configMap.get("shardsnumber")));
        result.put("max_result_window", CommonUtil.getMaxMatchSize());
        return result;
    }

    public static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    public static String getIdByEntityNamePkId(String entityName, Object pkId) {
        return entityName + String.valueOf(pkId);
    }

    public static String getLangPN(String propertyName, Lang lang) {
        String result = "";
        result = lang == null ? propertyName : propertyName + "_" + lang.toString().toLowerCase();
        return result;
    }

    public static boolean containsUppercase(String str) {
        Pattern p = Pattern.compile("[A-Z]");
        return p.matcher(str).find();
    }

    public static String getPinyinPN(String propertyName) {
        return propertyName + "_" + "py";
    }

    public static int getMaxMatchSize() {
        String sizeStr = System.getProperty("fulltext.maxmatchsize", "100000");
        return Integer.parseInt(sizeStr);
    }

    public static long getLongId(String coreName) {
        return DB.genLongId((String)coreName);
    }

    public static String joinStr(String[] strs, String joinStr) {
        if (strs == null) {
            return null;
        }
        StringBuilder strSb = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            if (i > 0) {
                strSb.append(joinStr);
            }
            strSb.append(strs[i]);
        }
        return strSb.toString();
    }

    public static boolean bracketMatch(String exp) {
        if (exp.length() == 0) {
            return false;
        }
        Stack<Character> stack = new Stack<Character>();
        block4: for (int i = 0; i < exp.length(); ++i) {
            char ch = exp.charAt(i);
            switch (ch) {
                case '(': {
                    stack.push(Character.valueOf(ch));
                    continue block4;
                }
                case ')': {
                    if (!stack.empty()) {
                        stack.pop();
                        continue block4;
                    }
                    return false;
                }
            }
        }
        return stack.empty();
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static Map<String, String> getServerConfig(String region) {
        return ESUtil.getServerConfig((String)region);
    }

    public static boolean isFullTextEanble(String region) {
        if ("true".equals(System.getProperty("ft.enable", "true"))) {
            String bStr = (String)ESUtil.getServerConfig((String)region).get("enable");
            return Boolean.parseBoolean(bStr);
        }
        return false;
    }
}

