/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinYinUtil {
    public static String[] getMergePinyin(String chines) throws BadHanyuPinyinOutputFormatCombination {
        if (chines.length() > 20) {
            chines = chines.substring(0, 20);
        }
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(chines);
        resultList.addAll(Arrays.asList(PinYinUtil.converterToFirstSpell(chines).split(",")));
        resultList.addAll(Arrays.asList(PinYinUtil.converterToSpell(chines).split(",")));
        return resultList.toArray(new String[resultList.size()]);
    }

    public static String converterToFirstSpell(String chines) throws BadHanyuPinyinOutputFormatCombination {
        StringBuilder pinyinName = new StringBuilder();
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < nameChar.length; ++i) {
            if (nameChar[i] > '\u0080') {
                String[] strs = PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat);
                if (strs != null) {
                    for (int j = 0; j < strs.length; ++j) {
                        pinyinName.append(strs[j].charAt(0));
                        if (j == strs.length - 1) continue;
                        pinyinName.append(",");
                    }
                }
            } else {
                pinyinName.append(nameChar[i]);
            }
            pinyinName.append(" ");
        }
        return PinYinUtil.parseTheChineseByObject(PinYinUtil.discountTheChinese(pinyinName.toString()));
    }

    public static String converterToSpell(String chines) throws BadHanyuPinyinOutputFormatCombination {
        StringBuilder pinyinName = new StringBuilder();
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < nameChar.length; ++i) {
            if (nameChar[i] > '\u0080') {
                String[] strs = PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaultFormat);
                if (strs != null) {
                    for (int j = 0; j < strs.length; ++j) {
                        pinyinName.append(strs[j]);
                        if (j == strs.length - 1) continue;
                        pinyinName.append(",");
                    }
                }
            } else {
                pinyinName.append(nameChar[i]);
            }
            pinyinName.append(" ");
        }
        return PinYinUtil.parseTheChineseByObject(PinYinUtil.discountTheChinese(pinyinName.toString()));
    }

    private static List<Map<String, Integer>> discountTheChinese(String theStr) {
        String[] firsts;
        ArrayList<Map<String, Integer>> mapList = new ArrayList<Map<String, Integer>>(8);
        Hashtable<String, Integer> onlyOne = null;
        for (String str : firsts = theStr.split(" ")) {
            String[] china;
            onlyOne = new Hashtable<String, Integer>();
            for (String s : china = str.split(",")) {
                Integer count = (Integer)onlyOne.get(s);
                if (count == null) {
                    onlyOne.put(s, 1);
                    continue;
                }
                onlyOne.remove(s);
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                onlyOne.put(s, count);
            }
            mapList.add(onlyOne);
        }
        return mapList;
    }

    private static List<List<Map<String, Integer>>> groupList(List<Map<String, Integer>> list, int maxquerylenth) {
        Map<String, Integer> singleWord;
        int size;
        ArrayList<List<Map<String, Integer>>> groups = new ArrayList<List<Map<String, Integer>>>();
        int beginIndex = 0;
        int endIndex = 0;
        int totalcount = 1;
        for (Map<String, Integer> singleWord2 : list) {
            int count = singleWord2.size();
            boolean add = false;
            if ((totalcount *= count) > 4 && endIndex - beginIndex >= maxquerylenth) {
                groups.add(list.subList(beginIndex, endIndex));
                add = true;
                totalcount /= list.get(beginIndex).size();
                beginIndex = endIndex - maxquerylenth + 1;
            }
            if (endIndex == list.size() - 1) {
                if (add) break;
                groups.add(list.subList(beginIndex, endIndex));
                break;
            }
            ++endIndex;
        }
        long singleCount = 1L;
        Iterator<Map<String, Integer>> count = list.iterator();
        while (count.hasNext() && ((size = (singleWord = count.next()).size()) <= 0 || (singleCount *= (long)size) <= Integer.MAX_VALUE)) {
        }
        AtomicInteger groupsCount = new AtomicInteger(0);
        groups.forEach(groupitem -> {
            int _groupCount = 1;
            for (Map singleWord : groupitem) {
                int size = singleWord.size();
                if (size <= 0) continue;
                _groupCount *= size;
            }
            groupsCount.addAndGet(_groupCount);
        });
        if (singleCount < (long)groupsCount.get()) {
            groups.clear();
            groups.add(list);
        }
        return groups;
    }

    private static Set<String> _parseTheChineseByObject(List<Map<String, Integer>> list) {
        HashMap<String, Integer> first = null;
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Integer> temp = new HashMap<String, Integer>();
            if (first != null) {
                for (String s : first.keySet()) {
                    for (String s1 : list.get(i).keySet()) {
                        String str = s + s1;
                        temp.put(str, 1);
                    }
                }
                if (temp != null && temp.size() > 0) {
                    first.clear();
                }
            } else {
                Iterator<Object> iterator = list.get(i).keySet().iterator();
                while (iterator.hasNext()) {
                    String s;
                    String str = s = (String)iterator.next();
                    temp.put(str, 1);
                }
            }
            if (temp == null || temp.size() <= 0) continue;
            first = temp;
        }
        return first == null ? new HashSet() : first.keySet();
    }

    private static String parseTheChineseByObject(List<Map<String, Integer>> list) {
        List<List<Map<String, Integer>>> groups = PinYinUtil.groupList(list, 5);
        HashSet s = new HashSet();
        groups.forEach(groupitem -> s.addAll(PinYinUtil._parseTheChineseByObject(groupitem)));
        return s.stream().collect(Collectors.joining(","));
    }
}

