/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fulltext.FTCompare;
import kd.bos.fulltext.FTStatuEnum;
import kd.bos.fulltext.FullTextMonitor;
import kd.bos.fulltext.MatchProperty;
import kd.bos.fulltext.MonitorValue;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.fulltext.impl.FullTextImplBase;
import kd.bos.fulltext.monitor.FtMonitorMeta;
import kd.bos.fulltext.storage.FilterField;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class FullTextMonitorImpl
extends FullTextImplBase
implements FullTextMonitor {
    private static Log log = LogFactory.getLog(FullTextMonitorImpl.class);

    public FullTextMonitorImpl(String region) {
        this.init(region);
    }

    @Override
    public Map<String, List<MonitorValue>> entityNamesMonitor(String ... entityNames) {
        long ts = 0L;
        String opt = "entityNamesMonitor";
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, entityNames);
        }
        try {
            HashMap<String, List<MonitorValue>> result = new HashMap<String, List<MonitorValue>>();
            if (entityNames == null || entityNames.length <= 0) {
                HashMap<String, List<MonitorValue>> hashMap = result;
                return hashMap;
            }
            int flag = 0;
            ArrayList<String> tempList = new ArrayList<String>(8);
            for (String temp : entityNames) {
                if (++flag >= 200) {
                    this.setEntityNameMonitor(tempList, result);
                    flag = 0;
                    tempList.clear();
                }
                tempList.add(temp);
            }
            if (!tempList.isEmpty()) {
                this.setEntityNameMonitor(tempList, result);
            }
            HashMap<String, List<MonitorValue>> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{"fulltext entityNamesMonitor error:" + e.getMessage()});
        }
        finally {
            if (enableOptLogOut) {
                this.optEndLog(opt, ts);
            }
        }
    }

    public void setEntityNameMonitor(List<String> tempList, Map<String, List<MonitorValue>> result) {
        Map<String, List<FtMonitorMeta>> list = this.monitorDao.queryByEntityNames(tempList.toArray(new String[0]));
        for (String entityName : tempList.toArray(new String[0])) {
            result.put(entityName, new ArrayList());
            List<FtMonitorMeta> upMetas = list.get(entityName);
            for (FtMonitorMeta meta : upMetas) {
                ArrayList<MonitorValue> mvList = new ArrayList<MonitorValue>();
                String propertyName = meta.getFpropertyName();
                String langStr = meta.getFlang();
                String fieldName = !StringUtils.isEmpty((String)langStr) ? propertyName + "_" + langStr : propertyName;
                mvList.add(this.packageMV(meta, fieldName));
                result.get(entityName).addAll(mvList);
            }
        }
    }

    @Override
    public Map<String, Integer> getCount(String ... entityNames) {
        long ts = 0L;
        String opt = "getCount";
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, entityNames);
        }
        try {
            HashMap<String, Integer> result = new HashMap<String, Integer>(8);
            for (String entityName : entityNames) {
                FilterField entityNameFF = new FilterField("entityname", FTCompare.EQ.toString(), entityName);
                result.put(entityName, this.storage.getCount(this.dataIndexName, "t_data", entityNameFF));
            }
            HashMap<String, Integer> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{"fulltextMonitor getCount error:" + e.getMessage()});
        }
        finally {
            if (enableOptLogOut) {
                this.optEndLog(opt, ts);
            }
        }
    }

    @Override
    public List<MonitorValue> getMonitorValue(String entityName, MatchProperty mp) {
        long ts = 0L;
        String opt = entityName + ":getMonitorValue";
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, new Object[]{mp});
        }
        try {
            ArrayList<MonitorValue> mvList = new ArrayList<MonitorValue>();
            String pn = mp.getPropertyName().toLowerCase();
            Lang lang = mp.getLang();
            boolean withPinyin = mp.isWithPinyin();
            String langStr = "";
            if (lang != null) {
                langStr = lang.toString();
            }
            FtMonitorMeta meta = new FtMonitorMeta();
            List<FtMonitorMeta> metaList = this.monitorDao.queryByEPL(entityName, pn, langStr);
            if (!metaList.isEmpty()) {
                meta = metaList.get(0);
            }
            String fieldName = CommonUtil.getLangPN(pn, lang);
            mvList.add(this.packageMV(meta, fieldName));
            if (withPinyin) {
                FtMonitorMeta pinyinMeta = new FtMonitorMeta();
                List<FtMonitorMeta> pinyinList = this.monitorDao.queryByEPL(entityName, pn, "py");
                if (!pinyinList.isEmpty()) {
                    pinyinMeta = pinyinList.get(0);
                }
                String pinyinName = CommonUtil.getPinyinPN(pn);
                mvList.add(this.packageMV(pinyinMeta, pinyinName));
            }
            ArrayList<MonitorValue> arrayList = mvList;
            return arrayList;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{"fulltextMonitor getMonitorValue error:" + e.getMessage()});
        }
        finally {
            if (enableOptLogOut) {
                this.optEndLog(opt, ts);
            }
        }
    }

    private MonitorValue packageMV(FtMonitorMeta meta, String propertyName) {
        MonitorValue mv = new MonitorValue();
        String beginTimeStr = meta.getFbeginTime();
        String endTimeStr = meta.getFendTime();
        if (!StringUtils.isEmpty((String)beginTimeStr)) {
            mv.setBeginTime(Timestamp.valueOf(beginTimeStr));
        }
        if (!StringUtils.isEmpty((String)endTimeStr)) {
            mv.setEndTime(Timestamp.valueOf(endTimeStr));
        }
        if (meta.getFstatus() != null) {
            mv.setStatus(FTStatuEnum.getValueOf(meta.getFstatus()));
        }
        mv.setInitLog(meta.getFinitLog());
        mv.setDataType(meta.getFdataType());
        mv.setEntityName(meta.getEntityName());
        mv.setPropertyName(propertyName);
        return mv;
    }
}

