/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fulltext.FTCompare;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FTFilter;
import kd.bos.fulltext.FTFilterExp;
import kd.bos.fulltext.FTRowData;
import kd.bos.fulltext.FTStatuEnum;
import kd.bos.fulltext.FTValue;
import kd.bos.fulltext.FullTextQuery;
import kd.bos.fulltext.HighLightTags;
import kd.bos.fulltext.RelatedWord;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.fulltext.impl.FullTextImplBase;
import kd.bos.fulltext.monitor.FtMonitorMeta;
import kd.bos.fulltext.storage.BatchFieldValue;
import kd.bos.fulltext.storage.FieldValue;
import kd.bos.fulltext.storage.FilterField;
import kd.bos.fulltext.storage.HighLightTag;
import kd.bos.fulltext.storage.SortField;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class FullTextQueryImpl
extends FullTextImplBase
implements FullTextQuery {
    private static Log log = LogFactory.getLog(FullTextQueryImpl.class);

    public FullTextQueryImpl(String region) {
        this.init(region);
    }

    @Override
    public String[] queryPinyin(String entityName, String propertyName, String value) {
        String fieldName = CommonUtil.getPinyinPN(propertyName);
        String keyValue = value.toLowerCase(Locale.ENGLISH);
        return this.queryNormal(entityName, fieldName, keyValue);
    }

    @Override
    public String[] queryLang(String entityName, String propertyName, Lang lang, String value) {
        String fieldName = CommonUtil.getLangPN(propertyName, lang);
        return this.queryNormal(entityName, fieldName, value);
    }

    @Override
    public String[] queryNormal(String entityName, String propertyName, String value) {
        long ts = 0L;
        String opt = "query:" + entityName + "->" + propertyName;
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, new Object[]{value});
        }
        try {
            String pn = propertyName.toLowerCase(Locale.ENGLISH) + "_" + FTDataType.STRING.toString();
            FilterField filter = new FilterField("entityname", FTCompare.EQ.toString(), entityName);
            FilterField pnFF = new FilterField(pn, FTCompare.LIKE.toString(), value);
            String[] selectFields = new String[]{"pkid"};
            List<BatchFieldValue> resultMap = this.storage.query(this.dataIndexName, "t_data", selectFields, filter.and(pnFF), null, null, true, 0, CommonUtil.getMaxMatchSize());
            ArrayList<String> resultList = new ArrayList<String>(16);
            List<FTRowData> rowList = this.packageFTRowData(resultMap, null);
            for (FTRowData rowData : rowList) {
                resultList.add(rowData.getPkId());
            }
            String[] stringArray = resultList.toArray(new String[resultList.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{"fulltext query error:" + e.getMessage()});
        }
        finally {
            if (enableOptLogOut) {
                this.optEndLog(opt, ts);
            }
        }
    }

    @Override
    public String[] query(String entityName, FTFilter filter) {
        FTFilterExp filterExp = null;
        if (filter != null) {
            filterExp = filter.toExp();
        }
        List<FTRowData> rowDatas = this.searchStorage(new String[]{entityName}, "pkid", null, filterExp, null, false, 1, CommonUtil.getMaxMatchSize());
        ArrayList<String> resultList = new ArrayList<String>(16);
        for (FTRowData rowData : rowDatas) {
            resultList.add(rowData.getPkId());
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    @Override
    public List<FTRowData> search(String entityName, String selectFields, FTFilter filter, int pageNo, int pageSize) {
        return this.search(entityName, selectFields, filter, null, pageNo, pageSize);
    }

    @Override
    public List<FTRowData> search(String entityName, String selectFields, FTFilter filter, String[] sortFields, int pageNo, int pageSize) {
        if (filter == null) {
            return this.searchMuiltExp(new String[]{entityName}, selectFields, null, sortFields, pageNo, pageSize);
        }
        return this.searchMuiltExp(new String[]{entityName}, selectFields, filter.toExp(), sortFields, pageNo, pageSize);
    }

    @Override
    public List<FTRowData> searchAfter(String entityName, String selectFields, FTFilter filter, String[] sortFields, int pageSize, Object[] sortValues) {
        return this.searchAfterStorage(new String[]{entityName}, selectFields, null, filter.toExp(), sortFields, true, pageSize, sortValues);
    }

    @Override
    public List<FTRowData> searchExp(String entityName, String selectFields, FTFilterExp expFilter, int pageNo, int pageSize) {
        return this.searchExp(entityName, selectFields, expFilter, null, pageNo, pageSize);
    }

    @Override
    public List<FTRowData> searchExp(String entityName, String selectFields, FTFilterExp expFilter, String[] sortFields, int pageNo, int pageSize) {
        return this.searchMuiltExp(new String[]{entityName}, selectFields, expFilter, sortFields, pageNo, pageSize);
    }

    @Override
    public List<FTRowData> searchMuiltExp(String[] entityNames, String selectFields, FTFilterExp expFilter, int pageNo, int pageSize) {
        return this.searchMuiltExp(entityNames, selectFields, expFilter, null, pageNo, pageSize);
    }

    @Override
    public List<FTRowData> searchMuiltExp(String[] entityNames, String selectFields, FTFilterExp expFilter, String[] sortFields, int pageNo, int pageSize) {
        return this.searchStorage(entityNames, selectFields, null, expFilter, sortFields, true, pageNo, pageSize);
    }

    @Override
    public List<FTRowData> searchWithHighLight(String entityName, String selectFields, HighLightTags highLightTags, FTFilter filter, int pageNo, int pageSize) {
        return this.searchWithHighLight(entityName, selectFields, highLightTags, filter, null, pageNo, pageSize);
    }

    @Override
    public List<FTRowData> searchWithHighLight(String entityName, String selectFields, HighLightTags highLightTags, FTFilter filter, String[] sortFields, int pageNo, int pageSize) {
        if (filter == null) {
            return this.searchMuiltExpWithHighLight(new String[]{entityName}, selectFields, highLightTags, null, sortFields, pageNo, pageSize);
        }
        return this.searchMuiltExpWithHighLight(new String[]{entityName}, selectFields, highLightTags, filter.toExp(), sortFields, pageNo, pageSize);
    }

    @Override
    public List<FTRowData> searchExpWithHighLight(String entityName, String selectFields, HighLightTags highLightTags, FTFilterExp expFilter, int pageNo, int pageSize) {
        return this.searchExpWithHighLight(entityName, selectFields, highLightTags, expFilter, null, pageNo, pageSize);
    }

    @Override
    public List<FTRowData> searchExpWithHighLight(String entityName, String selectFields, HighLightTags highLightTags, FTFilterExp expFilter, String[] sortFields, int pageNo, int pageSize) {
        return this.searchMuiltExpWithHighLight(new String[]{entityName}, selectFields, highLightTags, expFilter, sortFields, pageNo, pageSize);
    }

    @Override
    public List<FTRowData> searchMuiltExpWithHighLight(String[] entityNames, String selectFields, HighLightTags highLightTags, FTFilterExp expFilter, int pageNo, int pageSize) {
        return this.searchMuiltExpWithHighLight(entityNames, selectFields, highLightTags, expFilter, null, pageNo, pageSize);
    }

    @Override
    public List<FTRowData> searchMuiltExpWithHighLight(String[] entityNames, String selectFields, HighLightTags highLightTags, FTFilterExp expFilter, String[] sortFields, int pageNo, int pageSize) {
        HighLightTags highLigh = null;
        String defaultPreTags = "<span style=\"color:red\">";
        String defaultPostTags = "</span>";
        if (highLightTags == null) {
            highLigh = new HighLightTags(defaultPreTags, defaultPostTags);
        } else {
            String preTags = StringUtils.isEmpty((String)highLightTags.getPreTags()) ? defaultPreTags : highLightTags.getPreTags();
            String postTags = StringUtils.isEmpty((String)highLightTags.getPostTags()) ? defaultPostTags : highLightTags.getPostTags();
            highLigh = new HighLightTags(preTags, postTags);
        }
        return this.searchStorage(entityNames, selectFields, highLigh, expFilter, sortFields, true, pageNo, pageSize);
    }

    @Override
    public int count(String entityName, FTFilterExp expFilter) {
        return this.getCount(new String[]{entityName}, expFilter);
    }

    @Override
    public int count(String entityName, FTFilter filter) {
        FTFilterExp filterExp = null;
        if (filter != null) {
            filterExp = filter.toExp();
        }
        return this.getCount(new String[]{entityName}, filterExp);
    }

    @Override
    public int count(String[] entityNames, FTFilterExp expFilter) {
        return this.getCount(entityNames, expFilter);
    }

    @Override
    public int count(String[] entityNames, FTFilter filter) {
        FTFilterExp filterExp = null;
        if (filter != null) {
            filterExp = filter.toExp();
        }
        return this.getCount(entityNames, filterExp);
    }

    private int getCount(String[] entityNames, FTFilterExp filterExp) {
        FilterField filterField = new FilterField("entityname", FTCompare.EQ.toString(), entityNames);
        filterField.setKeywordsOr();
        if (filterExp != null) {
            filterField.and(this.anlyzeExp(filterExp));
        }
        return this.storage.getCount(this.dataIndexName, "t_data", filterField);
    }

    private Map<String, String> checkFieldAddIndex(String entityName, Set<String> fields) {
        HashMap<String, String> resultNameType = new HashMap<String, String>();
        Map<String, String> nameTypeMap = this.getAllNameType(entityName);
        for (String field : fields) {
            if ((field = field.toLowerCase(Locale.ENGLISH)).equals("entityname") || field.equals("pkid")) continue;
            boolean isAddIndex = false;
            for (Map.Entry<String, String> entry : nameTypeMap.entrySet()) {
                String key = entry.getKey();
                if (!key.equals(field) && !key.startsWith(field + "_")) continue;
                isAddIndex = true;
                String dataType = entry.getValue();
                resultNameType.put(key + "_" + dataType, dataType);
            }
            if (isAddIndex) continue;
            resultNameType.put(field, FTDataType.STRING.toString());
        }
        return resultNameType;
    }

    private Map<String, String> getAllNameType(String entityName) {
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        List<FtMonitorMeta> upMetas = this.monitorDao.queryByEntityName(entityName);
        String statuStr = FTStatuEnum.ADDED.toString();
        for (FtMonitorMeta meta : upMetas) {
            if (!statuStr.equals(meta.getFstatus())) continue;
            String filedName = "";
            String type = meta.getFdataType();
            String langStr = meta.getFlang();
            Lang lang = null;
            boolean withPinyin = false;
            if (!StringUtils.isEmpty((String)langStr)) {
                if (langStr.equals("py")) {
                    withPinyin = true;
                } else {
                    lang = Lang.valueOf((String)langStr);
                }
            }
            filedName = withPinyin ? CommonUtil.getPinyinPN(meta.getFpropertyName()) : CommonUtil.getLangPN(meta.getFpropertyName(), lang);
            resultMap.put(filedName, type);
        }
        return resultMap;
    }

    private List<FTRowData> packageFTRowData(List<BatchFieldValue> bfvs, Map<String, String> pnDataTypeMap) {
        String enKey = "entityname";
        String pkIdKey = "pkid";
        ArrayList<FTRowData> rowList = new ArrayList<FTRowData>(16);
        for (BatchFieldValue bfv : bfvs) {
            FieldValue[] fvs;
            FTRowData rowData = new FTRowData();
            HashMap<String, Object> pvMap = new HashMap<String, Object>();
            for (FieldValue fv : fvs = bfv.getValues()) {
                String name = fv.getName();
                Object value = fv.getValue();
                if (name.equals(enKey)) {
                    rowData.setEntityName(value.toString());
                    continue;
                }
                if (name.equals(pkIdKey)) {
                    rowData.setPkId(String.valueOf(value));
                    continue;
                }
                String dataType = pnDataTypeMap.get(name);
                if (dataType != null) {
                    name = name.replace("_" + dataType, "");
                }
                pvMap.put(name, fv.getValue());
            }
            rowData.setSortValues(bfv.getSortValues());
            rowData.setDataMap(pvMap);
            rowList.add(rowData);
        }
        return rowList;
    }

    private FilterField anlyzeExp(FTFilterExp expFilter) {
        String exp = expFilter.getExp();
        FTValue[] values = expFilter.getValues();
        this.checkExpFilter(expFilter);
        HashMap<String, FTCompare> cpMap = new HashMap<String, FTCompare>(8);
        for (FTCompare cp : FTCompare.values()) {
            cpMap.put(cp.toString(), cp);
        }
        HashMap<String, RelatedWord> rwMap = new HashMap<String, RelatedWord>(8);
        for (RelatedWord rw : RelatedWord.values()) {
            rwMap.put(rw.toString(), rw);
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        ArrayList<Character> expCharList = new ArrayList<Character>(16);
        for (int i = 0; i < exp.length(); ++i) {
            expCharList.add(Character.valueOf(exp.charAt(i)));
        }
        Iterator<Character> expCharIt = expCharList.iterator();
        int paramIndex = 0;
        while (expCharIt.hasNext()) {
            char ch = ((Character)expCharIt.next()).charValue();
            StringBuilder sb = new StringBuilder();
            if (ch == '(' || ch == ')') {
                queue.offer(String.valueOf(ch));
                continue;
            }
            sb.append(ch);
            sb.append(this.charItBreakSpace(expCharIt));
            String sbStr = sb.toString();
            if (rwMap.containsKey(sbStr)) {
                queue.offer(sbStr);
                continue;
            }
            String cpStr = this.charItBreakSpace(expCharIt).toLowerCase(Locale.ENGLISH);
            if (!cpMap.containsKey(cpStr)) {
                String errorStr = "fulltext query error:field must be followed by an operator(like/match/gt/lt/eq)." + expFilter.getExp();
                throw new KDException(BosErrorCode.fulltextException, new Object[]{errorStr});
            }
            String secondNextStr = this.charItBreakSpace(expCharIt).toLowerCase(Locale.ENGLISH);
            if (!secondNextStr.contains("?")) {
                String errorStr = "fulltext queryerror:operator must be followed by ?." + expFilter.getExp();
                throw new KDException(BosErrorCode.fulltextException, new Object[]{errorStr});
            }
            String propertyName = sbStr.toLowerCase(Locale.ENGLISH);
            FTValue value = values[paramIndex];
            if (value.isPinyin()) {
                propertyName = CommonUtil.getPinyinPN(propertyName);
            }
            if (value.isLang()) {
                propertyName = CommonUtil.getLangPN(propertyName, value.getLang());
            } else {
                int index = propertyName.lastIndexOf("_###GL".toLowerCase(Locale.ENGLISH));
                if (index > 0) {
                    propertyName = propertyName.substring(0, index);
                }
            }
            Object[] propertyValues = value.getValues();
            FTDataType dataType = value.getDataType();
            if (dataType == FTDataType.STRING && !FTCompare.IN.toString().equals(cpStr) && propertyValues != null && propertyValues.length > 0) {
                ArrayList<String> lowcasePropertyValueList = new ArrayList<String>(16);
                for (Object propertyValue : propertyValues) {
                    String tempString = String.valueOf(propertyValue);
                    lowcasePropertyValueList.add(tempString);
                }
                propertyValues = lowcasePropertyValueList.toArray(new String[lowcasePropertyValueList.size()]);
            }
            float boost = value.getBoost();
            if (!"pkid".equals(propertyName) && !"entityname".equals(propertyName)) {
                propertyName = propertyName + "_" + dataType.toString();
            }
            FilterField filterField = new FilterField(propertyName, cpStr, propertyValues).setBoost(boost);
            if (value.isOr()) {
                filterField.setKeywordsOr();
            }
            queue.offer(filterField);
            if (secondNextStr.contains("(") || secondNextStr.contains(")")) {
                for (int i = 0; i < secondNextStr.length(); ++i) {
                    char c = secondNextStr.charAt(i);
                    if (c == '(') {
                        queue.offer("(");
                        continue;
                    }
                    if (c != ')') continue;
                    queue.offer(")");
                }
            }
            ++paramIndex;
        }
        Iterator iterator = queue.iterator();
        Stack<Object> stack = new Stack<Object>();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof String) {
                if (")".equals(obj)) {
                    String backStr = "(";
                    boolean flag = true;
                    while (flag && !stack.isEmpty()) {
                        FilterField firstFF = (FilterField)stack.pop();
                        String rw = (String)stack.pop();
                        FilterField secondFF = (FilterField)stack.pop();
                        Object peekOb = stack.peek();
                        if (backStr.equals(String.valueOf(peekOb))) {
                            stack.pop();
                            flag = false;
                        }
                        if ("and".endsWith(rw)) {
                            stack.push(firstFF.and(secondFF));
                            continue;
                        }
                        stack.push(firstFF.or(secondFF));
                    }
                    continue;
                }
                stack.push(obj.toString());
                continue;
            }
            if (obj instanceof FilterField) {
                stack.push(obj);
                continue;
            }
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"exp parsing error." + exp});
        }
        int stackSize = stack.size();
        if (stackSize % 2 == 0) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"Illegal exp." + exp});
        }
        ArrayList<FilterField> ffList = new ArrayList<FilterField>();
        String rw = "";
        for (int i = 0; i < stackSize; ++i) {
            if (i % 2 != 0) {
                rw = (String)stack.pop();
                continue;
            }
            ffList.add((FilterField)stack.pop());
        }
        FilterField filterField = null;
        for (FilterField ff : ffList) {
            if (filterField == null) {
                filterField = ff;
                continue;
            }
            if ("and".equals(rw)) {
                filterField.and(ff);
                continue;
            }
            filterField.or(ff);
        }
        return filterField;
    }

    private void checkExpFilter(FTFilterExp expFilter) {
        String exp = expFilter.getExp();
        FTValue[] values = expFilter.getValues();
        String expFilterStr = expFilter.toString();
        if (StringUtils.isEmpty((String)exp)) {
            String errorStr = "fulltext query error:exp cannot be empty." + expFilterStr;
            throw new KDException(BosErrorCode.fulltextException, new Object[]{errorStr});
        }
        char[] chs = exp.toCharArray();
        int count = 0;
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] != '?') continue;
            ++count;
        }
        if (count == 0 || count != values.length) {
            String errorStr = "fulltext query error:params number are not equals ? number." + expFilterStr;
            throw new KDException(BosErrorCode.fulltextException, new Object[]{errorStr});
        }
        if (!CommonUtil.bracketMatch(exp)) {
            String errorStr = "fulltext query error:exp left and right brackets do not match." + expFilterStr;
            throw new KDException(BosErrorCode.fulltextException, new Object[]{errorStr});
        }
    }

    private String charItBreakSpace(Iterator<Character> charIt) {
        char chTemp;
        StringBuilder sb = new StringBuilder();
        while (charIt.hasNext() && (chTemp = charIt.next().charValue()) != ' ') {
            sb.append(chTemp);
        }
        return sb.toString();
    }

    private List<FTRowData> searchStorage(String[] entityNames, String selectFields, HighLightTags highLightags, FTFilterExp expFilter, String[] sortFields, boolean score, int pageNo, int pageSize) {
        long ts = 0L;
        String opt = "query:" + CommonUtil.joinStr(entityNames, ",") + "->" + selectFields;
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, new Object[]{expFilter});
        }
        try {
            boolean isNeedSort;
            this.checkParam(selectFields, pageNo, pageSize);
            HashSet<String> cheakFieldSet = new HashSet<String>(8);
            boolean bl = isNeedSort = sortFields != null && sortFields.length > 0;
            if (isNeedSort) {
                for (String field : sortFields) {
                    cheakFieldSet.add(field.split(" ")[0].trim());
                }
            }
            for (String field : selectFields.split(",")) {
                cheakFieldSet.add(field);
            }
            Map<Object, Object> pnDataTypeMap = new HashMap();
            for (String entityName : entityNames) {
                pnDataTypeMap = this.checkFieldAddIndex(entityName, cheakFieldSet);
            }
            ArrayList<Object> selectFieldList = new ArrayList<Object>(8);
            selectFieldList.add("entityname");
            selectFieldList.add("pkid");
            for (Map.Entry<Object, Object> entry : pnDataTypeMap.entrySet()) {
                selectFieldList.add(entry.getKey());
            }
            ArrayList<SortField> sortList = new ArrayList<SortField>(8);
            if (isNeedSort) {
                for (String fieldStr : sortFields) {
                    if (fieldStr == null) continue;
                    String[] tempArr = fieldStr.split(" ");
                    String field = tempArr[0];
                    String sortStr = "";
                    if (tempArr.length > 1) {
                        sortStr = tempArr[1];
                    }
                    for (Map.Entry<Object, Object> entry : pnDataTypeMap.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!key.startsWith(field + "_")) continue;
                        SortField info = new SortField(key);
                        if (sortStr.equalsIgnoreCase("desc")) {
                            info.setAsc(false);
                        }
                        sortList.add(info);
                    }
                }
            }
            HighLightTag highLightTag = null;
            if (highLightags != null) {
                highLightTag = new HighLightTag(highLightags.getPreTags(), highLightags.getPostTags());
            }
            FilterField filter = new FilterField("entityname", FTCompare.EQ.toString(), entityNames);
            filter.setKeywordsOr();
            if (expFilter != null) {
                filter.and(this.anlyzeExp(expFilter));
            }
            List<BatchFieldValue> resultBfv = this.storage.query(this.dataIndexName, "t_data", selectFieldList.toArray(new String[selectFieldList.size()]), filter, highLightTag, sortList.toArray(new SortField[0]), score, (pageNo - 1) * pageSize, pageSize);
            List<FTRowData> list = this.packageFTRowData(resultBfv, pnDataTypeMap);
            return list;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{"fulltext search error:" + e.getMessage()});
        }
        finally {
            if (enableOptLogOut) {
                this.optEndLog(opt, ts);
            }
        }
    }

    private List<FTRowData> searchAfterStorage(String[] entityNames, String selectFields, HighLightTags highLightags, FTFilterExp expFilter, String[] sortFields, boolean score, int pageSize, Object[] sortValues) {
        long ts = 0L;
        String opt = "query:" + CommonUtil.joinStr(entityNames, ",") + "->" + selectFields;
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, new Object[]{expFilter});
        }
        try {
            boolean isNeedSort;
            this.checkParam(selectFields, 1, pageSize);
            HashSet<String> cheakFieldSet = new HashSet<String>(8);
            boolean bl = isNeedSort = sortFields != null && sortFields.length > 0;
            if (isNeedSort) {
                for (String field : sortFields) {
                    cheakFieldSet.add(field.split(" ")[0].trim());
                }
            }
            for (String field : selectFields.split(",")) {
                cheakFieldSet.add(field);
            }
            Map<Object, Object> pnDataTypeMap = new HashMap();
            for (String entityName : entityNames) {
                pnDataTypeMap = this.checkFieldAddIndex(entityName, cheakFieldSet);
            }
            ArrayList<Object> selectFieldList = new ArrayList<Object>(8);
            selectFieldList.add("entityname");
            selectFieldList.add("pkid");
            for (Map.Entry<Object, Object> entry : pnDataTypeMap.entrySet()) {
                selectFieldList.add(entry.getKey());
            }
            ArrayList<SortField> sortList = new ArrayList<SortField>(8);
            if (isNeedSort) {
                for (String fieldStr : sortFields) {
                    if (fieldStr == null) continue;
                    String[] tempArr = fieldStr.split(" ");
                    String field = tempArr[0];
                    String sortStr = "";
                    if (tempArr.length > 1) {
                        sortStr = tempArr[1];
                    }
                    if (field.startsWith("pkid")) {
                        SortField info = new SortField(field);
                        if (sortStr.equalsIgnoreCase("desc")) {
                            info.setAsc(false);
                        }
                        sortList.add(info);
                        continue;
                    }
                    for (Map.Entry<Object, Object> entry : pnDataTypeMap.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!key.startsWith(field + "_")) continue;
                        SortField info = new SortField(key);
                        if (sortStr.equalsIgnoreCase("desc")) {
                            info.setAsc(false);
                        }
                        sortList.add(info);
                    }
                }
            }
            HighLightTag highLightTag = null;
            if (highLightags != null) {
                highLightTag = new HighLightTag(highLightags.getPreTags(), highLightags.getPostTags());
            }
            FilterField filter = new FilterField("entityname", FTCompare.EQ.toString(), entityNames);
            filter.setKeywordsOr();
            if (expFilter != null) {
                filter.and(this.anlyzeExp(expFilter));
            }
            List<BatchFieldValue> resultBfv = this.storage.searchAfter(this.dataIndexName, "t_data", selectFieldList.toArray(new String[selectFieldList.size()]), filter, highLightTag, sortList.toArray(new SortField[0]), score, pageSize, sortValues);
            List<FTRowData> list = this.packageFTRowData(resultBfv, pnDataTypeMap);
            return list;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{"fulltext search after error:" + e.getMessage()});
        }
        finally {
            if (enableOptLogOut) {
                this.optEndLog(opt, ts);
            }
        }
    }

    private void checkParam(String selectFields, int pageNo, int pageSize) {
        int esMaxQuerySize = CommonUtil.getMaxMatchSize();
        if (pageSize > esMaxQuerySize) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"fulltext query error:pageSize(" + pageSize + ") greater than the max number(" + esMaxQuerySize + ") of query."});
        }
        if (pageNo < 1) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"fulltext query error:pageNo(" + pageNo + ") must be greater than 0."});
        }
        if (selectFields == null || selectFields.length() <= 0) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"fulltext query error:selectFields can not be null."});
        }
    }
}

