/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.DataCacheReader;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fulltext.BatchValue;
import kd.bos.fulltext.FTCompare;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FTStatuEnum;
import kd.bos.fulltext.FullTextUpdater;
import kd.bos.fulltext.MatchProperty;
import kd.bos.fulltext.PropertyValue;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.fulltext.common.util.PinYinUtil;
import kd.bos.fulltext.impl.FullTextImplBase;
import kd.bos.fulltext.monitor.FtMonitorMeta;
import kd.bos.fulltext.storage.BatchFieldValue;
import kd.bos.fulltext.storage.FieldIndex;
import kd.bos.fulltext.storage.FieldValue;
import kd.bos.fulltext.storage.FilterField;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class FullTextUpdaterImpl
extends FullTextImplBase
implements FullTextUpdater {
    private static Log log = LogFactory.getLog(FullTextUpdaterImpl.class);
    protected static ExecutorService es = ThreadPools.newCachedExecutorService((String)"FullTextUpdater-Thread", (int)5, (int)50);

    public FullTextUpdaterImpl(String region) {
        this.init(region);
    }

    @Override
    public void addProperty(String entityName, MatchProperty[] matchProperties) {
        this.addPropertyStorage(entityName, matchProperties);
    }

    @Override
    public void deleteProperty(String entityName, MatchProperty ... matchProperties) {
        this.deletePropertyStorage(entityName, matchProperties);
    }

    @Override
    public void insert(String entityName, Object id, PropertyValue[] values) {
        this.saveStorage(entityName, id, values);
    }

    @Override
    public void insert(String entityName, BatchValue[] batchValues) {
        this.batchSaveStorage(entityName, batchValues);
    }

    @Override
    public void update(String entityName, Object id, PropertyValue[] values) {
        this.saveStorage(entityName, id, values);
    }

    @Override
    public void update(String entityName, BatchValue[] batchValues) {
        this.batchSaveStorage(entityName, batchValues);
    }

    @Override
    public void delete(String entityName, Object id) {
        this.deleteStorage(entityName, id);
    }

    @Override
    public void delete(String entityName, Object[] ids) {
        this.batchDeleteStorage(entityName, ids);
    }

    @Override
    public void refresh() {
        this.refreshStorage();
    }

    @Override
    public void deleteAll(String entityName) {
        this.deleteAllStorage(entityName);
    }

    private FieldValue[] pvToFVArray(PropertyValue[] values) throws BadHanyuPinyinOutputFormatCombination {
        ArrayList<FieldValue> fvList = new ArrayList<FieldValue>();
        for (PropertyValue value : values) {
            if (value == null) continue;
            Object fieldValue = value.getValue();
            FTDataType dataType = value.getDataType();
            Lang lang = value.getLang();
            String propertyName = value.getPropertyName().toLowerCase();
            String fieldName = CommonUtil.getLangPN(propertyName, lang);
            if (value.isWithPinyin()) {
                fvList.add(new FieldValue(CommonUtil.getPinyinPN(propertyName) + "_" + dataType.toString(), PinYinUtil.getMergePinyin(String.valueOf(fieldValue))));
            }
            fvList.add(new FieldValue(fieldName + "_" + dataType.toString(), fieldValue));
        }
        return fvList.toArray(new FieldValue[fvList.size()]);
    }

    private FieldValue[] bvToFVArray(String entityName, BatchValue batchValue) throws BadHanyuPinyinOutputFormatCombination {
        ArrayList<FieldValue> fvList = new ArrayList<FieldValue>();
        Object pkId = batchValue.getId();
        FieldValue fvPkId = new FieldValue("pkid", String.valueOf(pkId));
        fvList.add(fvPkId);
        FieldValue fvEntityName = new FieldValue("entityname", entityName);
        fvList.add(fvEntityName);
        PropertyValue[] values = batchValue.getValues();
        Collections.addAll(fvList, this.pvToFVArray(values));
        return fvList.toArray(new FieldValue[fvList.size()]);
    }

    private void saveStorage(String entityName, Object id, PropertyValue[] values) {
        long ts = 0L;
        String opt = entityName + ":insert";
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, values);
        }
        try {
            FieldValue[] insertFields = this.bvToFVArray(entityName, new BatchValue(id, values));
            BatchFieldValue bfv = new BatchFieldValue(CommonUtil.getIdByEntityNamePkId(entityName, id), insertFields);
            this.storage.batchSave(this.dataIndexName, "t_data", bfv);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{"fulltext insert error:" + e.getMessage()});
        }
        finally {
            if (enableOptLogOut) {
                this.optEndLog(opt, ts);
            }
        }
    }

    private void batchSaveStorage(String entityName, BatchValue[] batchValues) {
        long ts = 0L;
        String opt = entityName + ":insert";
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, batchValues);
        }
        try {
            ArrayList<BatchFieldValue> bfvs = new ArrayList<BatchFieldValue>(16);
            for (BatchValue bv : batchValues) {
                bfvs.add(new BatchFieldValue(CommonUtil.getIdByEntityNamePkId(entityName, bv.getId()), this.bvToFVArray(entityName, bv)));
            }
            BatchFieldValue[] bfvsArr = new BatchFieldValue[bfvs.size()];
            bfvsArr = bfvs.toArray(bfvsArr);
            this.storage.batchSave(this.dataIndexName, "t_data", bfvsArr);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{"fulltext insert error:" + e.getMessage()});
        }
        finally {
            if (enableOptLogOut) {
                this.optEndLog(opt, ts);
            }
        }
    }

    private void deleteStorage(String entityName, Object id) {
        long ts = 0L;
        String opt = entityName + ":delete";
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, new Object[]{id});
        }
        try {
            this.storage.deleteByQuery(this.dataIndexName, "t_data", new FilterField("_id", FTCompare.EQ.toString(), CommonUtil.getIdByEntityNamePkId(entityName, id)));
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{"fulltext delete error:" + e.getMessage()});
        }
        finally {
            if (enableOptLogOut) {
                this.optEndLog(opt, ts);
            }
        }
    }

    private void batchDeleteStorage(String entityName, Object[] ids) {
        long ts = 0L;
        String opt = entityName + ":delete";
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, ids);
        }
        try {
            int batchFlag = 0;
            ArrayList<String> _ids = new ArrayList<String>(10);
            for (Object id : ids) {
                if (++batchFlag > 5000) {
                    this.storage.deleteByQuery(this.dataIndexName, "t_data", new FilterField("_id", FTCompare.IN.toString(), _ids.toArray(new Object[0])));
                    batchFlag = 1;
                    _ids.clear();
                }
                _ids.add(CommonUtil.getIdByEntityNamePkId(entityName, id));
            }
            if (!_ids.isEmpty()) {
                this.storage.deleteByQuery(this.dataIndexName, "t_data", new FilterField("_id", FTCompare.IN.toString(), _ids.toArray(new Object[0])));
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{"fulltext delete error:" + e.getMessage()});
        }
        finally {
            if (enableOptLogOut) {
                this.optEndLog(opt, ts);
            }
        }
    }

    private void deleteAllStorage(String entityName) {
        long ts = 0L;
        String opt = entityName + ":deleteAll";
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, null);
        }
        try {
            this.storage.deleteByQuery(this.dataIndexName, "t_data", new FilterField("entityname", FTCompare.EQ.toString(), entityName));
            this.monitorDao.deleteByEntityName(entityName);
        }
        catch (Exception e) {
            String eErrorStr = CommonUtil.getStackTrace(e);
            try {
                this.updateMonitorStatusLog(entityName, FTStatuEnum.DELETEERROR, entityName + eErrorStr);
            }
            catch (Exception e1) {
                throw new KDException((Throwable)e1, BosErrorCode.fulltextException, new Object[]{e1.getMessage()});
            }
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{e.getMessage()});
        }
        finally {
            if (enableOptLogOut) {
                this.optEndLog(opt, ts);
            }
        }
    }

    private void refreshStorage() {
        long ts = 0L;
        String opt = "refresh";
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, null);
        }
        try {
            this.storage.refreshDataBase(this.dataIndexName);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{"fulltext refresh error:" + e.getMessage()});
        }
        finally {
            if (enableOptLogOut) {
                this.optEndLog(opt, ts);
            }
        }
    }

    private void deletePropertyStorage(String entityName, MatchProperty[] matchProperties) {
        long ts = 0L;
        String opt = entityName + ":delFieldIndex";
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, matchProperties);
        }
        for (MatchProperty matchProperty : matchProperties) {
            String propertyName = matchProperty.getPropertyName().toLowerCase();
            FTDataType ftdataType = matchProperty.getDataType();
            if (StringUtils.isEmpty((String)propertyName) || ftdataType == null) {
                throw new KDException(BosErrorCode.fulltextException, new Object[]{"fullText deleteProperty error:propertyName and dataType can not be null"});
            }
            boolean withPinyin = matchProperty.isWithPinyin();
            String dataType = ftdataType.toString();
            String langStr = "";
            Lang lang = matchProperty.getLang();
            if (lang != null) {
                langStr = lang.toString();
            }
            try {
                FilterField filterField = new FilterField("entityname", FTCompare.EQ.toString(), entityName);
                String fieldName = CommonUtil.getLangPN(propertyName, lang);
                FieldValue fv = new FieldValue(fieldName + "_" + dataType, null);
                if (withPinyin) {
                    FieldValue fvPinyin = new FieldValue(CommonUtil.getPinyinPN(propertyName) + "_" + dataType, null);
                    this.storage.updateByQuery(this.dataIndexName, "t_data", filterField, new FieldValue[]{fv, fvPinyin});
                } else {
                    this.storage.updateByQuery(this.dataIndexName, "t_data", filterField, new FieldValue[]{fv});
                }
                String deletedStr = "  fullText:deleteProperty success";
                this.updateMonitorStatusLog(entityName, propertyName, langStr, FTStatuEnum.DELETED, deletedStr);
                if (!withPinyin) continue;
                this.updateMonitorStatusLog(entityName, propertyName, "py", FTStatuEnum.DELETED, deletedStr);
            }
            catch (Exception e) {
                String eStackTrace = CommonUtil.getStackTrace(e);
                String eErrorStr = "fullText:deleteProperty error:" + eStackTrace;
                try {
                    this.updateMonitorStatusLog(entityName, propertyName, langStr, FTStatuEnum.DELETEERROR, eErrorStr);
                    if (withPinyin) {
                        this.updateMonitorStatusLog(entityName, propertyName, "py", FTStatuEnum.DELETEERROR, eErrorStr);
                    }
                }
                catch (Exception e1) {
                    throw new KDException((Throwable)e1, BosErrorCode.fulltextException, new Object[]{e1.getMessage()});
                }
                throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{e.getMessage()});
            }
            finally {
                if (enableOptLogOut) {
                    this.optEndLog(opt, ts);
                }
            }
        }
    }

    private void addPropertyStorage(String entityName, MatchProperty ... matchProperties) {
        long ts = 0L;
        String opt = entityName + ":addFieldIndex";
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, matchProperties);
        }
        Map<String, DBFiledMapping> databaseFiledMapping = this.getDatabaseFiledMapping(entityName, matchProperties);
        DynamicObjectType entityType = DataCacheReader.get().getDataEntityType(entityName);
        for (MatchProperty mp : matchProperties) {
            String propertyName = mp.getPropertyName().toLowerCase();
            FTDataType dataType = mp.getDataType();
            if (StringUtils.isEmpty((String)propertyName) || dataType == null) {
                throw new KDException(BosErrorCode.fulltextException, new Object[]{"fullText addProperty error:propertyName and dataType can not be null"});
            }
            boolean withPinyin = mp.isWithPinyin();
            Lang lang = mp.getLang();
            String langStr = lang != null ? lang.toString() : "";
            try {
                boolean isGlFieldAndZhCn = mp.getLang() == Lang.zh_CN && this.isGLFieldAndZhCn((IDataEntityType)entityType, propertyName);
                this.addFieldsIndex(mp, isGlFieldAndZhCn);
                DBFiledMapping dbMapping = databaseFiledMapping.get(propertyName);
                for (String tableName : dbMapping.tables) {
                    FtMonitorMeta ftMonitorMeta = new FtMonitorMeta();
                    ftMonitorMeta.setFbeginTime(new Timestamp(System.currentTimeMillis()).toString());
                    ftMonitorMeta.setEntityName(entityName);
                    ftMonitorMeta.setFpropertyName(propertyName);
                    ftMonitorMeta.setTableName(tableName);
                    ftMonitorMeta.setFieldName(dbMapping.filedName);
                    ftMonitorMeta.setFstatus(FTStatuEnum.ADDED.toString());
                    ftMonitorMeta.setFinitLog(entityName + ":" + propertyName + "  fullText:addProperty success");
                    ftMonitorMeta.setFdataType(dataType.toString());
                    ftMonitorMeta.setFlang(langStr);
                    this.monitorDao.insert(ftMonitorMeta);
                    if (withPinyin) {
                        ftMonitorMeta.setFlang("py");
                        this.monitorDao.insert(ftMonitorMeta);
                        continue;
                    }
                    if (!isGlFieldAndZhCn) continue;
                    ftMonitorMeta.setFlang("");
                    this.monitorDao.insert(ftMonitorMeta);
                }
            }
            catch (Exception e) {
                String eStackTrace = CommonUtil.getStackTrace(e);
                String eErrorStr = "fullText:addProperty error\uff1a" + eStackTrace;
                try {
                    this.updateMonitorStatusLog(entityName, propertyName, langStr, FTStatuEnum.ADDERROR, eErrorStr);
                    if (withPinyin) {
                        this.updateMonitorStatusLog(entityName, propertyName, "py", FTStatuEnum.ADDERROR, eErrorStr);
                    }
                }
                catch (Exception e1) {
                    String e1ErrorStr = "fullText:monitor add error" + CommonUtil.getStackTrace(e1);
                    throw new KDException((Throwable)e1, BosErrorCode.fulltextException, new Object[]{e1.getMessage()});
                }
                throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{e.getMessage()});
            }
            finally {
                if (enableOptLogOut) {
                    this.optEndLog(opt, ts);
                }
            }
        }
    }

    private Map<String, DBFiledMapping> getDatabaseFiledMapping(String entityName, MatchProperty[] matchProperties) {
        HashMap<String, DBFiledMapping> m = new HashMap<String, DBFiledMapping>();
        DynamicObjectType mainEntityType = null;
        try {
            ArrayList<String> properties = new ArrayList<String>(16);
            for (MatchProperty propertyName : matchProperties) {
                properties.add(propertyName.getPropertyName());
            }
            mainEntityType = DataCacheReader.get().getSubDataEntityType(entityName, properties);
            String mainTableName = mainEntityType.getAlias();
            DataEntityPropertyCollection collect = mainEntityType.getProperties();
            collect.forEach(v -> {
                if (!(v instanceof DynamicCollectionProperty)) {
                    String tableGroup = v.getTableGroup();
                    DBFiledMapping dbf = new DBFiledMapping(mainTableName, v.getAlias());
                    if (v.getTableGroup() != null) {
                        dbf.addTable(mainTableName + "_" + tableGroup);
                    }
                    m.put(v.getName(), dbf);
                } else {
                    try {
                        DynamicCollectionProperty entry;
                        String entryTable;
                        if (Class.forName("kd.bos.entity.property.EntryProp").isAssignableFrom(v.getClass()) && (entryTable = (entry = (DynamicCollectionProperty)v).getItemType().getAlias()) != null && entryTable.length() > 0) {
                            String entryName = entry.getName();
                            DataEntityPropertyCollection entryCollect = entry.getItemType().getProperties();
                            entryCollect.forEach(p -> {
                                if (!(p instanceof DynamicCollectionProperty)) {
                                    m.put(entryName + "." + p.getName(), new DBFiledMapping(entryTable, p.getAlias()));
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        log.error("EntryProp not found", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return m;
    }

    private void addFieldsIndex(MatchProperty mp, boolean isGlField) {
        String propertyName = mp.getPropertyName().toLowerCase();
        String filedName = CommonUtil.getLangPN(propertyName, mp.getLang());
        String dataType = mp.getDataType().toString();
        String tokenizerType = mp.getTokenizerType().toString();
        long fieldSize = mp.getPropertySize();
        if (mp.isWithPinyin()) {
            FieldIndex[] fieldIndexs = new FieldIndex[]{new FieldIndex(filedName + "_" + dataType, dataType, tokenizerType, fieldSize), new FieldIndex(CommonUtil.getPinyinPN(propertyName) + "_" + dataType, dataType, tokenizerType, fieldSize)};
            this.storage.addFieldIndex(this.dataIndexName, "t_data", fieldIndexs);
        } else if (isGlField) {
            FieldIndex[] fieldIndexs = new FieldIndex[]{new FieldIndex(filedName + "_" + dataType, dataType, tokenizerType, fieldSize), new FieldIndex(propertyName + "_" + dataType, dataType, tokenizerType, fieldSize)};
            this.storage.addFieldIndex(this.dataIndexName, "t_data", fieldIndexs);
        } else {
            this.storage.addFieldIndex(this.dataIndexName, "t_data", new FieldIndex(filedName + "_" + dataType, dataType, tokenizerType, fieldSize));
        }
    }

    private void updateMonitorStatusLog(String entityName, String propertyName, String langStr, FTStatuEnum statu, String log) {
        List<FtMonitorMeta> upMetas = this.monitorDao.queryByEPL(entityName, propertyName, langStr);
        if (!upMetas.isEmpty()) {
            for (FtMonitorMeta upedMeta : upMetas) {
                upedMeta.setFstatus(statu.toString());
                upedMeta.setFendTime(new Timestamp(System.currentTimeMillis()).toString());
                upedMeta.setFinitLog(entityName + ":" + propertyName + "_" + langStr + log);
                this.monitorDao.update(upedMeta);
            }
        }
    }

    private void updateMonitorStatusLog(String entityName, FTStatuEnum statu, String log) {
        List<FtMonitorMeta> upMetas = this.monitorDao.queryByEntityName(entityName);
        if (!upMetas.isEmpty()) {
            for (FtMonitorMeta upedMeta : upMetas) {
                upedMeta.setFstatus(statu.toString());
                upedMeta.setFendTime(new Timestamp(System.currentTimeMillis()).toString());
                upedMeta.setFinitLog(log);
                this.monitorDao.update(upedMeta);
            }
        }
    }

    private boolean isGLFieldAndZhCn(IDataEntityType mainDT, String propertyName) {
        IDataEntityProperty peropertyType;
        ISimpleProperty mainProperty;
        return mainDT != null && (mainProperty = (ISimpleProperty)(peropertyType = (IDataEntityProperty)mainDT.getProperties().get((Object)propertyName))) != null && !mainProperty.isDbIgnore() && !peropertyType.isDbIgnore();
    }

    private static class DBFiledMapping {
        String filedName;
        Set<String> tables = new HashSet<String>(2);

        DBFiledMapping(String tableName, String filedName) {
            this.tables.add(tableName);
            this.filedName = filedName;
        }

        void addTable(String tablename) {
            this.tables.add(tablename);
        }
    }
}

