/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.fulltext.FTCompare;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.fulltext.monitor.FtMonitorMeta;
import kd.bos.fulltext.storage.BatchFieldValue;
import kd.bos.fulltext.storage.FieldValue;
import kd.bos.fulltext.storage.FilterField;
import kd.bos.fulltext.storage.Storage;

public class FtMonitorDao {
    private static final String ENTITYNAME_FIELD = "entityName";
    private static final String PROPERTYNAME_FIELD = "fpropertyName";
    private static final String FID_FIELD = "fid";
    private static final String FLANG_FIELD = "flang";
    private static final String TYPE_NAME = "t_monitor";
    private String monitorIndexName;
    private Storage storage;

    public FtMonitorDao(Storage storage, String monitorIndexName) {
        this.storage = storage;
        this.monitorIndexName = monitorIndexName;
    }

    public void insert(FtMonitorMeta t) {
        List<FtMonitorMeta> queryList = this.queryByEPL(t.getEntityName(), t.getFpropertyName(), t.getFlang());
        if (t.getTableName() != null) {
            queryList = queryList.stream().filter(f -> t.getTableName().equalsIgnoreCase(f.getTableName())).collect(Collectors.toList());
        }
        if (!queryList.isEmpty()) {
            for (FtMonitorMeta meta : queryList) {
                t.setFid(meta.getFid());
                this.update(t);
            }
            return;
        }
        List<String> fieldNames = t._getFieldsName();
        fieldNames.remove(FID_FIELD);
        int size = fieldNames.size();
        ArrayList<FieldValue> insertFieldList = new ArrayList<FieldValue>(16);
        for (int i = 0; i < size; ++i) {
            String fieldName = fieldNames.get(i);
            insertFieldList.add(new FieldValue(fieldName, t._getFieldValue(fieldName)));
        }
        long id = CommonUtil.getLongId(TYPE_NAME);
        insertFieldList.add(new FieldValue(FID_FIELD, id));
        BatchFieldValue bv = new BatchFieldValue(String.valueOf(id), insertFieldList.toArray(new FieldValue[0]));
        this.storage.batchSave(this.monitorIndexName, TYPE_NAME, bv);
    }

    public void update(FtMonitorMeta t) {
        List<String> fieldNames = t._getFieldsName();
        int size = fieldNames.size();
        ArrayList<FieldValue> upFieldList = new ArrayList<FieldValue>();
        String _id = "";
        for (int i = 0; i < size; ++i) {
            String fieldName = fieldNames.get(i);
            if (!FID_FIELD.equals(fieldName)) {
                upFieldList.add(new FieldValue(fieldName, t._getFieldValue(fieldName)));
                continue;
            }
            _id = t._getFieldValue(fieldName) + "";
        }
        BatchFieldValue bv = new BatchFieldValue(_id, upFieldList.toArray(new FieldValue[0]));
        this.storage.batchSave(this.monitorIndexName, TYPE_NAME, bv);
    }

    public void delete(long id) {
        this.storage.delete(this.monitorIndexName, TYPE_NAME, String.valueOf(id));
    }

    public void deleteByEntityName(String entityName) {
        FilterField filter = new FilterField(ENTITYNAME_FIELD, FTCompare.EQ.toString(), entityName);
        this.storage.deleteByQuery(this.monitorIndexName, TYPE_NAME, filter);
    }

    public List<FtMonitorMeta> queryByEPL(String entityName, String propertyName, String lanStr) {
        String[] selectFieldStrs = "fid,entityName,fpropertyName,fdataType,fbeginTime,fendTime,fstatus,finitLog,flang,tableName,fieldName".split(",");
        FilterField filter = new FilterField(FLANG_FIELD, "eq", lanStr);
        filter.and(new FilterField(ENTITYNAME_FIELD, "eq", entityName));
        filter.and(new FilterField(PROPERTYNAME_FIELD, "eq", propertyName));
        ArrayList<FtMonitorMeta> result = new ArrayList<FtMonitorMeta>(16);
        List<BatchFieldValue> fieldsList = this.storage.query(this.monitorIndexName, TYPE_NAME, selectFieldStrs, filter, null, null, false, 0, 10);
        if (fieldsList == null) {
            return result;
        }
        for (BatchFieldValue bv : fieldsList) {
            FieldValue[] fvs = bv.getValues();
            FtMonitorMeta meta = new FtMonitorMeta();
            for (FieldValue fv : fvs) {
                meta._setField(fv.getName(), fv.getValue());
            }
            result.add(meta);
        }
        return result;
    }

    public List<FtMonitorMeta> queryByEntityName(String entityName) {
        String[] selectFieldStrs = "fid,entityName,fpropertyName,fdataType,fbeginTime,fendTime,fstatus,finitLog,flang,tableName,fieldName".split(",");
        FilterField filter = new FilterField(ENTITYNAME_FIELD, "eq", entityName);
        ArrayList<FtMonitorMeta> result = new ArrayList<FtMonitorMeta>(16);
        List<BatchFieldValue> fieldsList = this.storage.query(this.monitorIndexName, TYPE_NAME, selectFieldStrs, filter, null, null, false, 0, CommonUtil.getMaxMatchSize());
        if (fieldsList == null) {
            return result;
        }
        for (BatchFieldValue bv : fieldsList) {
            FieldValue[] fvs = bv.getValues();
            FtMonitorMeta meta = new FtMonitorMeta();
            for (FieldValue fv : fvs) {
                meta._setField(fv.getName(), fv.getValue());
            }
            result.add(meta);
        }
        return result;
    }

    public Map<String, List<FtMonitorMeta>> queryByEntityNames(String ... entityNames) {
        String[] selectFieldStrs = "fid,entityName,fpropertyName,fdataType,fbeginTime,fendTime,fstatus,finitLog,flang,tableName,fieldName".split(",");
        FilterField filter = new FilterField(ENTITYNAME_FIELD, "eq", entityNames);
        filter.setKeywordsOr();
        HashMap<String, List<FtMonitorMeta>> result = new HashMap<String, List<FtMonitorMeta>>(8);
        for (String entityName : entityNames) {
            result.put(entityName, new ArrayList(16));
        }
        List<BatchFieldValue> fieldsList = this.storage.query(this.monitorIndexName, TYPE_NAME, selectFieldStrs, filter, null, null, false, 0, CommonUtil.getMaxMatchSize());
        if (fieldsList == null) {
            return result;
        }
        for (BatchFieldValue bv : fieldsList) {
            FieldValue[] fvs = bv.getValues();
            FtMonitorMeta meta = new FtMonitorMeta();
            for (FieldValue fv : fvs) {
                meta._setField(fv.getName(), fv.getValue());
            }
            ((List)result.get(meta.getEntityName())).add(meta);
        }
        return result;
    }
}

