/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FTTokenizerType;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.fulltext.storage.BatchFieldValue;
import kd.bos.fulltext.storage.FieldIndex;
import kd.bos.fulltext.storage.FieldValue;
import kd.bos.fulltext.storage.FilterField;
import kd.bos.fulltext.storage.HighLightTag;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class BaseStorage {
    protected static final String ANDSTR = "and";
    protected static final String ORSTR = "or";
    protected static final String MUST_STR = "must";
    protected static final String KEYWORD_SUFFIX = ".keyword";
    protected Map<String, List<String>> likeHighLightMap = null;

    protected String getFieldsMapping(String coreName, FieldIndex ... fieldIndexs) {
        StringBuilder paramSb = new StringBuilder();
        paramSb.append("{\"");
        paramSb.append(coreName);
        paramSb.append("\":{ \"properties\": { ");
        int i = 0;
        int len = fieldIndexs.length;
        for (FieldIndex fieldIndexInfo : fieldIndexs) {
            String filedType = fieldIndexInfo.getDataType();
            String filedName = fieldIndexInfo.getName();
            String fieldTokenizer = fieldIndexInfo.getTokenizerType();
            long fieldSize = fieldIndexInfo.getFieldSize();
            if (FTDataType.STRING.toString().equals(filedType)) {
                if (FTTokenizerType.STANDARD.toString().endsWith(fieldTokenizer)) {
                    paramSb.append('\"');
                    paramSb.append(filedName);
                    paramSb.append("\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":");
                    paramSb.append(fieldSize);
                    paramSb.append("}}}");
                } else if (FTTokenizerType.IKMAXWORD.toString().endsWith(fieldTokenizer)) {
                    paramSb.append('\"');
                    paramSb.append(filedName);
                    paramSb.append("\":{\"type\":\"text\",\"analyzer\":\"");
                    paramSb.append(fieldTokenizer);
                    paramSb.append("\",\"search_analyzer\":\"");
                    paramSb.append((Object)FTTokenizerType.IKSMART);
                    paramSb.append("\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":");
                    paramSb.append(fieldSize);
                    paramSb.append("}}}");
                } else {
                    paramSb.append('\"');
                    paramSb.append(filedName);
                    paramSb.append("\":{\"type\":\"text\",\"analyzer\":\"");
                    paramSb.append(fieldTokenizer);
                    paramSb.append("\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":");
                    paramSb.append(fieldSize);
                    paramSb.append("}}}");
                }
            } else {
                paramSb.append('\"');
                paramSb.append(filedName);
                paramSb.append("\":{\"type\":\"");
                paramSb.append(filedType);
                paramSb.append("\"}");
            }
            if (i < len - 1) {
                paramSb.append(',');
            }
            ++i;
        }
        paramSb.append("}}}");
        return paramSb.toString();
    }

    protected QueryBuilder getQueryBuilder(FilterField filter) {
        QueryBuilder queryBuilder = null;
        if (filter != null) {
            queryBuilder = this.getQueryBuilder0(filter);
            List<FilterField.FilterFieldNest> nests = filter.getNests();
            if (!nests.isEmpty()) {
                for (FilterField.FilterFieldNest nest : nests) {
                    queryBuilder = this.mergeQueryBuilder(queryBuilder, this.getQueryBuilder(nest.getFilter()), nest.getNestRw());
                }
            }
        }
        return queryBuilder;
    }

    protected QueryBuilder mergeQueryBuilder(QueryBuilder qb1, QueryBuilder qb2, String rw) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        String mustOrshould = this.getMustOrShould(rw);
        if (MUST_STR.equals(mustOrshould)) {
            queryBuilder.must(qb1);
            queryBuilder.must(qb2);
        } else {
            queryBuilder.should(qb1);
            queryBuilder.should(qb2);
        }
        return queryBuilder;
    }

    protected QueryBuilder getQueryBuilder0(FilterField filter) {
        StringBuilder filedNameSb = new StringBuilder();
        filedNameSb.append(filter.getName());
        String cp = filter.getCp();
        Object[] values = filter.getKeywords();
        String rw = filter.isKeywordsOr() ? ORSTR : ANDSTR;
        String mustOrShould = this.getMustOrShould(rw);
        switch (cp) {
            case "match": {
                return this.buildMatchBuilder(filter, filedNameSb, values, mustOrShould);
            }
            case "like": {
                return this.buildLikeQueryBuilder(filter, filedNameSb, values, mustOrShould, true, true);
            }
            case "eq": {
                return this.buildEqQueryBuilder(filter, filedNameSb, values, mustOrShould);
            }
            case "in": {
                return this.buildInQueryBuilder(filter, filedNameSb, values);
            }
            case "gt": {
                Object gtValue = values[0];
                return QueryBuilders.rangeQuery((String)filedNameSb.toString()).gt(gtValue).boost(filter.getBoost());
            }
            case "lt": {
                Object ltValue = values[0];
                return QueryBuilders.rangeQuery((String)filedNameSb.toString()).lt(ltValue).boost(filter.getBoost());
            }
            case "notnull": {
                return QueryBuilders.existsQuery((String)filedNameSb.toString()).boost(filter.getBoost());
            }
            case "startwith": {
                return this.buildLikeQueryBuilder(filter, filedNameSb, values, mustOrShould, false, true);
            }
            case "isnull": {
                return this.buildIsNullQueryBuilder(filter, filedNameSb, values, mustOrShould);
            }
        }
        throw new KDException(BosErrorCode.fulltextException, new Object[]{"the operator (" + cp + ") does not support."});
    }

    protected QueryBuilder buildInQueryBuilder(FilterField filter, StringBuilder filedNameSb, Object[] values) {
        String fieldName = filedNameSb.toString();
        if (values[0] instanceof String && !"_id".equals(fieldName)) {
            filedNameSb.append(KEYWORD_SUFFIX);
        }
        fieldName = filedNameSb.toString();
        return QueryBuilders.termsQuery((String)fieldName, (Object[])values).boost(filter.getBoost());
    }

    protected QueryBuilder buildEqQueryBuilder(FilterField filter, StringBuilder filedNameSb, Object[] values, String mustOrShould) {
        if (values[0] instanceof String && !"_id".equals(filedNameSb.toString())) {
            filedNameSb.append(KEYWORD_SUFFIX);
        }
        if (values.length == 1) {
            return QueryBuilders.termQuery((String)filedNameSb.toString(), (Object)values[0]).boost(filter.getBoost());
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        for (Object value : values) {
            if (MUST_STR.equals(mustOrShould)) {
                queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)filedNameSb.toString(), (Object)value).boost(filter.getBoost()));
                continue;
            }
            queryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)filedNameSb.toString(), (Object)value).boost(filter.getBoost()));
        }
        return queryBuilder;
    }

    protected QueryBuilder buildLikeQueryBuilder(FilterField filter, StringBuilder filedNameSb, Object[] values, String mustOrShould, boolean leftFuzzy, boolean rightFuzzy) {
        filedNameSb.append(KEYWORD_SUFFIX);
        ArrayList<String> filterStrs = new ArrayList<String>(8);
        for (Object value : values) {
            filterStrs.add(String.valueOf(value));
        }
        if (this.likeHighLightMap == null) {
            this.likeHighLightMap = new HashMap<String, List<String>>();
        }
        this.likeHighLightMap.put(filedNameSb.toString().replaceAll(KEYWORD_SUFFIX, ""), filterStrs);
        if (values.length == 1) {
            return QueryBuilders.wildcardQuery((String)filedNameSb.toString(), (String)this.buildFuzzyValue(values[0], leftFuzzy, rightFuzzy)).boost(filter.getBoost());
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        for (Object value : values) {
            if (MUST_STR.equals(mustOrShould)) {
                queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)filedNameSb.toString(), (String)this.buildFuzzyValue(value, leftFuzzy, rightFuzzy)).boost(filter.getBoost()));
                continue;
            }
            queryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)filedNameSb.toString(), (String)this.buildFuzzyValue(value, leftFuzzy, rightFuzzy)).boost(filter.getBoost()));
        }
        return queryBuilder;
    }

    private String buildFuzzyValue(Object value, boolean leftFuzzy, boolean rightFuzzy) {
        StringBuilder stringBuilder = new StringBuilder();
        if (leftFuzzy) {
            stringBuilder.append("*");
        }
        stringBuilder.append(value);
        if (rightFuzzy) {
            stringBuilder.append("*");
        }
        return stringBuilder.toString();
    }

    protected QueryBuilder buildMatchBuilder(FilterField filter, StringBuilder filedNameSb, Object[] values, String mustOrShould) {
        if (values.length == 1) {
            return QueryBuilders.matchQuery((String)filedNameSb.toString(), (Object)values[0]).boost(filter.getBoost());
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        for (Object value : values) {
            if (MUST_STR.equals(mustOrShould)) {
                queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)filedNameSb.toString(), (Object)value).boost(filter.getBoost()));
                continue;
            }
            queryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)filedNameSb.toString(), (Object)value).boost(filter.getBoost()));
        }
        return queryBuilder;
    }

    protected String getMustOrShould(String rw) {
        String filterRw = "";
        if (ANDSTR.equals(rw)) {
            filterRw = MUST_STR;
        } else if (ORSTR.equals(rw)) {
            filterRw = "should";
        } else {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"the relation (" + rw + ") does not support."});
        }
        return filterRw;
    }

    protected List<BatchFieldValue> queryMapListToResult(List<Map<String, Object>> queryMapList, String[] selectFileds, HighLightTag highLightTag) {
        int selectFieldLen = selectFileds.length;
        ArrayList<BatchFieldValue> fvsList = new ArrayList<BatchFieldValue>(16);
        for (Map<String, Object> tempMap : queryMapList) {
            FieldValue[] fvs = new FieldValue[selectFieldLen];
            for (int i = 0; i < selectFieldLen; ++i) {
                String selectFieldStr = selectFileds[i];
                Object value = this.likeQueryHighLightReplace(tempMap.get(selectFieldStr), this.likeHighLightMap.get(selectFieldStr), highLightTag);
                fvs[i] = new FieldValue(selectFieldStr, value);
            }
            fvsList.add(new BatchFieldValue("", fvs));
        }
        return fvsList;
    }

    protected List<BatchFieldValue> queryMapListToResult(List<Map<String, Object>> queryMapList, List<Object[]> sortValuesList, String[] selectFileds, HighLightTag highLightTag) {
        int selectFieldLen = selectFileds.length;
        ArrayList<BatchFieldValue> fvsList = new ArrayList<BatchFieldValue>(16);
        for (int j = 0; j < queryMapList.size(); ++j) {
            FieldValue[] fvs = new FieldValue[selectFieldLen];
            for (int i = 0; i < selectFieldLen; ++i) {
                String selectFieldStr = selectFileds[i];
                Object value = this.likeQueryHighLightReplace(queryMapList.get(j).get(selectFieldStr), this.likeHighLightMap.get(selectFieldStr), highLightTag);
                fvs[i] = new FieldValue(selectFieldStr, value);
            }
            Object[] sortValues = sortValuesList.get(j);
            fvsList.add(new BatchFieldValue("", fvs, sortValues));
        }
        return fvsList;
    }

    protected Object likeQueryHighLightReplace(Object queryObj, List<String> filterStrs, HighLightTag highLightTag) {
        if (queryObj == null) {
            return null;
        }
        if (filterStrs == null || highLightTag == null) {
            return queryObj;
        }
        String[] result = queryObj;
        String preTags = highLightTag.getPostTags();
        String postTags = highLightTag.getPostTags();
        for (String str : filterStrs) {
            String replaceStr = preTags + str + postTags;
            if (CommonUtil.isArray(result)) {
                String[] queryArr = result;
                for (int i = 0; i < queryArr.length; ++i) {
                    queryArr[i] = queryArr[i].replaceAll(str, replaceStr);
                }
                result = queryArr;
                continue;
            }
            result = String.valueOf(result).replaceAll(str, replaceStr);
        }
        return result;
    }

    protected String buildBulkFailureMessage(int batchSize, List<BulkItemResponse> failureRespList) {
        StringBuilder failureMsg = new StringBuilder();
        int failureSize = failureRespList.size();
        failureMsg.append("fulltext bulk opt error,success:");
        failureMsg.append(batchSize - failureSize);
        failureMsg.append(",failure:");
        failureMsg.append(failureSize);
        failureMsg.append(",details:");
        int flag = 1000;
        for (BulkItemResponse response : failureRespList) {
            if (flag >= 0) {
                failureMsg.append('\n').append("id [").append(response.getId()).append("], message [").append(response.getFailureMessage()).append(']');
            }
            --flag;
        }
        return failureMsg.toString();
    }

    private QueryBuilder buildIsNullQueryBuilder(FilterField filter, StringBuilder filedNameSb, Object[] values, String mustOrShould) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)filedNameSb.toString()).boost(filter.getBoost()));
        return queryBuilder;
    }
}

