/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.storage;

import java.util.ArrayList;
import java.util.List;

public class FilterField {
    private String name;
    private String cp;
    private Object[] keywords;
    private boolean allAnd = true;
    private float boost = 1.0f;
    private List<FilterFieldNest> nests = new ArrayList<FilterFieldNest>();

    public FilterField(String name, String cp, Object ... keywords) {
        this.name = name;
        this.cp = cp;
        this.keywords = keywords;
    }

    public String getName() {
        return this.name;
    }

    public Object[] getKeywords() {
        return this.keywords;
    }

    public String getCp() {
        return this.cp;
    }

    public float getBoost() {
        return this.boost;
    }

    public FilterField setBoost(float boost) {
        this.boost = boost;
        return this;
    }

    public List<FilterFieldNest> getNests() {
        return this.nests;
    }

    public FilterField and(FilterField f) {
        return this.add("and", f);
    }

    public FilterField or(FilterField f) {
        return this.add("or", f);
    }

    private FilterField add(String nestRw, FilterField f) {
        this.nests.add(new FilterFieldNest(nestRw, f));
        return this;
    }

    public boolean isKeywordsOr() {
        return !this.allAnd;
    }

    public FilterField setKeywordsOr() {
        this.allAnd = false;
        return this;
    }

    public static class FilterFieldNest {
        private String nestRw;
        private FilterField filter;

        FilterFieldNest(String nestRw, FilterField filter) {
            this.nestRw = nestRw;
            this.filter = filter;
        }

        public String getNestRw() {
            return this.nestRw;
        }

        public FilterField getFilter() {
            return this.filter;
        }

        public String toString() {
            return this.nestRw + this.filter;
        }
    }
}

