/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.storage.highlevel.request;

import java.util.Arrays;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;

public class NewPutMappingRequest
extends PutMappingRequest {
    private Integer version;

    public NewPutMappingRequest(String index, Integer version) {
        super(new String[]{index});
        this.version = version;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.version <= 6 && this.type() == null) {
            validationException = ValidateActions.addValidationError((String)"mapping type is missing", validationException);
        } else if (this.version <= 6 && this.type().isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"mapping type is empty", (ActionRequestValidationException)validationException);
        }
        if (this.source() == null) {
            validationException = ValidateActions.addValidationError((String)"mapping source is missing", (ActionRequestValidationException)validationException);
        } else if (this.source().isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"mapping source is empty", (ActionRequestValidationException)validationException);
        }
        if (this.getConcreteIndex() != null && this.indices() != null && this.indices().length > 0) {
            validationException = ValidateActions.addValidationError((String)("either concrete index or unresolved indices can be set, concrete index: [" + this.getConcreteIndex() + "] and indices: " + Arrays.asList(this.indices())), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

