/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.lockme.db;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import org.apache.commons.dbcp2.BasicDataSource;

public class LockDataSourceManager {
    private static final String BOS_LOCKME = "bos-lockme";
    static DBRoute dbRoute = null;
    static final String LOCKME_DBROUTE = "lockme.dbroute";
    static final String LOCKME_ALONEDB_CONFIG = "lockme.alonedb.config";
    static final String DB_TYPE = "dbType";
    static final String DRIVER_CLASS_NAME = "driverClassName";
    static final String URL = "url";
    static final String USER_NAME = "userName";
    static final String PASS = "passWord";

    static DataSource getDataSource() {
        if (LockDataSourceManager.isAloneDB()) {
            return LockDataSourceManager.aloneDBDataSource();
        }
        return LockDataSourceManager.defaultDataSource();
    }

    static boolean isAloneDB() {
        String lockmeSingledbConfigStr = System.getProperty(LOCKME_ALONEDB_CONFIG);
        return lockmeSingledbConfigStr != null && lockmeSingledbConfigStr.length() > 0;
    }

    private static DataSource aloneDBDataSource() {
        BasicDataSource ds = new BasicDataSource();
        Map<String, String> configMap = LockDataSourceManager.getAloneDBConfig();
        ds.setDriverClassName(configMap.get(DRIVER_CLASS_NAME));
        String url = configMap.get(URL);
        if (url.contains("?")) {
            if (!url.contains("&allowMultiQueries=true")) {
                url = url + "&allowMultiQueries=true";
            }
        } else {
            url = url + "?&allowMultiQueries=true";
        }
        ds.setUrl(url);
        ds.setUsername(configMap.get(USER_NAME));
        ds.setPassword(configMap.get(PASS));
        ds.setInitialSize(50);
        return ds;
    }

    private static DataSource defaultDataSource() {
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String routeKey = dbRoute.getRouteKey();
        String accountId = rc.getAccountId();
        return DataSourceFactory.getDataSource((String)tenantId, (String)routeKey, (String)accountId, (boolean)false).getDataSource();
    }

    static Map<String, String> getAloneDBConfig() {
        String value = System.getProperty(LOCKME_ALONEDB_CONFIG);
        HashMap<String, String> result = new HashMap<String, String>();
        Properties prop = new Properties();
        StringReader reader = new StringReader(value);
        try {
            prop.load(reader);
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.bOS, Resources.getString((String)"\u914d\u7f6e\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u914d\u7f6e\u662f\u5426\u6b63\u786ekey=", (String)"LockDataSourceManager_0", (String)BOS_LOCKME, (Object[])new Object[0]) + LOCKME_ALONEDB_CONFIG, (Throwable)e);
        }
        String driverClassName = prop.getProperty(DRIVER_CLASS_NAME);
        if (StringUtils.isEmpty((String)driverClassName)) {
            throw new KDException(LOCKME_ALONEDB_CONFIG + Resources.getString((String)"\u914d\u7f6e\u9519\u8bef\uff0cdriverClassName can't be empty.", (String)"LockDataSourceManager_1", (String)BOS_LOCKME, (Object[])new Object[0]));
        }
        result.put(DRIVER_CLASS_NAME, driverClassName);
        String url = prop.getProperty(URL);
        if (StringUtils.isEmpty((String)driverClassName)) {
            throw new KDException(LOCKME_ALONEDB_CONFIG + Resources.getString((String)"\u914d\u7f6e\u9519\u8bef\uff0curl can't be empty.", (String)"LockDataSourceManager_2", (String)BOS_LOCKME, (Object[])new Object[0]));
        }
        result.put(URL, url);
        String userName = prop.getProperty(USER_NAME);
        if (StringUtils.isEmpty((String)driverClassName)) {
            throw new KDException(LOCKME_ALONEDB_CONFIG + Resources.getString((String)"\u914d\u7f6e\u9519\u8bef\uff0cuserName can't be empty.", (String)"LockDataSourceManager_3", (String)BOS_LOCKME, (Object[])new Object[0]));
        }
        result.put(USER_NAME, userName);
        String passWord = prop.getProperty(PASS);
        if (StringUtils.isEmpty((String)driverClassName)) {
            throw new KDException(LOCKME_ALONEDB_CONFIG + Resources.getString((String)"\u914d\u7f6e\u9519\u8bef\uff0cpassWord can't be empty.", (String)"LockDataSourceManager_4", (String)BOS_LOCKME, (Object[])new Object[0]));
        }
        result.put(PASS, passWord);
        String dbType = prop.getProperty(DB_TYPE);
        if (StringUtils.isEmpty((String)driverClassName)) {
            throw new KDException(LOCKME_ALONEDB_CONFIG + Resources.getString((String)"\u914d\u7f6e\u9519\u8bef\uff0cdbType can't be empty.", (String)"LockDataSourceManager_5", (String)BOS_LOCKME, (Object[])new Object[0]));
        }
        result.put(DB_TYPE, dbType);
        return result;
    }

    static {
        String dbRouteKey = System.getProperty(LOCKME_DBROUTE);
        dbRoute = DBRoute.basedata;
        if (dbRouteKey != null && dbRouteKey.length() > 0) {
            dbRoute = DBRoute.of((String)dbRouteKey);
        }
    }
}

