/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity;

import java.lang.reflect.Method;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import org.apache.commons.beanutils.ConvertUtils;

public final class PropertyDescriptorUtils {
    public static boolean tryGetDefaultValue(Method pInfo, RefObject<Object> defaultValue) {
        DefaultValueAttribute defAtt = pInfo.getAnnotation(DefaultValueAttribute.class);
        Class<?> returnType = pInfo.getReturnType();
        if (defAtt != null) {
            defaultValue.argvalue = ConvertUtils.convert((String)defAtt.value(), returnType);
            return true;
        }
        if (returnType.isPrimitive()) {
            defaultValue.argvalue = returnType == Boolean.TYPE ? Boolean.valueOf(false) : (returnType == Character.class ? Character.valueOf(' ') : ConvertUtils.convert((Object)0, returnType));
            return true;
        }
        if (returnType == String.class || returnType == LocaleString.class || Object.class.isAssignableFrom(returnType)) {
            defaultValue.argvalue = null;
            return true;
        }
        defaultValue.argvalue = null;
        return false;
    }

    public static Method getShouldSerializeMethod(Class<?> beanCls, String propName) {
        return PropertyDescriptorUtils.getMethod(beanCls, propName, "shouldSerialize");
    }

    public static Method getDefaultValueMethod(Class<?> beanCls, String propName) {
        return PropertyDescriptorUtils.getMethod(beanCls, propName, "getDefaultValue");
    }

    private static Method getMethod(Class<?> beanCls, String propName, String methodPrex) {
        try {
            return beanCls.getMethod(methodPrex + propName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }
}

