/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ext.ClassManagerHelper;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.instance.Instance;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.sdk.annotation.SdkDeprecated;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TypesContainer {
    private static Map<Class<?>, Object> instancesDict = new ConcurrentHashMap();
    private static boolean jarDeployEnable = false;
    private static final String JAR_DEPLOY_ENABLE = "jar_deploy_enable";
    private static TypeCreator typeCreator;

    private static boolean canBeDeploy() {
        return jarDeployEnable && RequestContext.get() != null && StringUtils.isNotBlank(RequestContext.get().getAccountId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getOrRegisterSingletonInstance(String type) {
        Class<?> t = TypesContainer.doClassforName(type);
        if (t != null) {
            Object ret = instancesDict.get(t);
            if (ret == null) {
                String string = type.intern();
                synchronized (string) {
                    ret = instancesDict.get(t);
                    if (ret == null) {
                        ret = TypesContainer.createInstance(t);
                        instancesDict.put(t, ret);
                    }
                }
            }
            return ret;
        }
        return null;
    }

    public static Class<?> getOrRegister(String type) {
        if (TypesContainer.canBeDeploy()) {
            return ClassManagerHelper.forName(type.trim());
        }
        return TypesContainer.doClassforName(type);
    }

    private static Class<?> doClassforName(String type) {
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("type");
        }
        try {
            return Class.forName(type.trim());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("%s: %s not find.", Instance.getAppName(), type), e);
        }
    }

    @SdkDeprecated
    public static void removeRegister(String type) {
    }

    public static <T> T createInstance(String className) {
        Class<?> type = TypesContainer.getOrRegister(className);
        if (type == null) {
            throw new RuntimeException(String.format("%1$s failed to  Create Instance.", className));
        }
        return TypesContainer.createInstance(type);
    }

    public static <T> T createInstance(Class<?> cls) {
        if (cls == null) {
            throw new RuntimeException(" failed to  Create Instance,Class is Null.");
        }
        try {
            return (T)typeCreator.createInstance(cls);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("%1$s failed to  Create Instance:" + e.getMessage(), cls.getName()), e);
        }
    }

    @SdkInternal
    public static void setTypeCreator(TypeCreator typeCreator) {
        TypesContainer.typeCreator = typeCreator;
    }

    static {
        jarDeployEnable = Boolean.parseBoolean(System.getProperty(JAR_DEPLOY_ENABLE));
        ConfigurationUtil.observeChange((String)JAR_DEPLOY_ENABLE, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                jarDeployEnable = Boolean.parseBoolean(System.getProperty(TypesContainer.JAR_DEPLOY_ENABLE));
            }
        });
        typeCreator = new TypeCreator(){

            @Override
            public <T> T createInstance(Class<T> cls) throws Exception {
                return cls.newInstance();
            }
        };
    }

    @SdkInternal
    public static interface TypeCreator {
        public <T> T createInstance(Class<T> var1) throws Exception;
    }
}

