/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.resource.ResManager;

public class CollectionWithParent<T>
extends ArrayList<T> {
    private static final long serialVersionUID = 4358379658400395378L;
    private Object _parent;
    private static final Map<Object, Object> _itemParents = new HashMap<Object, Object>();

    public CollectionWithParent() {
        this._parent = this;
    }

    public CollectionWithParent(List<T> list) {
        this(list, null);
    }

    public CollectionWithParent(List<T> list, Object parent) {
        super(list);
        Object object = this._parent = parent != null ? parent : this;
        if (list != null) {
            for (T item : list) {
                this.Validate(-1, item);
            }
        }
    }

    @Override
    public void add(int index, T item) {
        this.Validate(-1, item);
        super.add(index, item);
    }

    @Override
    public T set(int index, T item) {
        this.Validate(index, item);
        Object oldItem = this.get(index);
        super.set(index, item);
        CollectionWithParent.ResetParent(oldItem);
        return (T)oldItem;
    }

    @Override
    public T remove(int index) {
        Object oldItem = this.get(index);
        super.remove(index);
        CollectionWithParent.ResetParent(oldItem);
        return (T)oldItem;
    }

    @Override
    public void clear() {
        for (Object item : this) {
            CollectionWithParent.ResetParent(item);
        }
        super.clear();
    }

    public static Object GetItemParent(Object item) {
        return _itemParents.get(item);
    }

    private static void SetItemParent(Object item, Object parent) {
        if (item == null) {
            return;
        }
        if (parent == null) {
            _itemParents.remove(item);
        } else {
            _itemParents.put(item, parent);
        }
    }

    private static Object CompareExchangeParent(Object item, Object value, Object comparand) {
        Object currentParent = CollectionWithParent.GetItemParent(item);
        if (comparand == currentParent) {
            CollectionWithParent.SetItemParent(item, value);
        }
        return currentParent;
    }

    private static void ResetParent(Object item) {
        CollectionWithParent.SetItemParent(item, null);
    }

    private void Validate(int index, T value) {
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        Object valueParent = CollectionWithParent.CompareExchangeParent(value, this._parent, null);
        if (valueParent != null) {
            if (this._parent != valueParent) {
                throw new OrmException("??????", ResManager.loadKDString("\u6dfb\u52a0\u7684\u5143\u7d20\u5df2\u7ecf\u5b58\u5728\u4e8e\u4f8b\u5916\u4e00\u4e2a\u96c6\u5408\u3002", "CollectionWithParent_0", "bos-dataentity", new Object[0]));
            }
            if (index != this.indexOf(value)) {
                throw new OrmException("??????", ResManager.loadKDString("\u8981\u6dfb\u52a0\u7684\u5bf9\u8c61\u5df2\u7ecf\u6dfb\u52a0\u5230\u5f53\u524d\u96c6\u5408", "CollectionWithParent_1", "bos-dataentity", new Object[0]));
            }
        }
    }

    private void readObject(ObjectInputStream in) {
        try {
            in.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            throw new OrmException("CollectionWithParent.readObject.ClassNotFoundException", e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OrmException("CollectionWithParent.readObject.IOException", e.getMessage(), e);
        }
        for (Object item : this) {
            CollectionWithParent.SetItemParent(item, this._parent);
        }
    }
}

