/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.collections.CollectionWithParent;

public abstract class LazyKeyedCollection<TKey, TValue>
extends CollectionWithParent<TValue>
implements Serializable {
    private transient int _lastIndex;

    public LazyKeyedCollection() {
        this(new ArrayList(), (Object)null);
    }

    public LazyKeyedCollection(List<TValue> list, Object parent) {
        super(list, parent);
    }

    protected abstract TKey GetKeyForItem(TValue var1);

    public final int IndexOf(TKey key) {
        if (this.RangeCheck(this._lastIndex) && key.equals(this.GetKeyForItem(this.get(this._lastIndex)))) {
            return this._lastIndex;
        }
        for (int i = 0; i < this.size(); ++i) {
            Object item = this.get(i);
            if (!key.equals(this.GetKeyForItem(item))) continue;
            this._lastIndex = i;
            return i;
        }
        return -1;
    }

    private boolean RangeCheck(int index) {
        return index >= 0 && this.size() > index;
    }

    private int CheckName(TKey key) {
        int index = this.indexOf(key);
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("key");
        }
        return index;
    }

    public final boolean containsKey(TKey key) {
        return this.indexOf(key) >= 0;
    }

    public final void removeItem(TKey key) {
        int index = this.CheckName(key);
        this.remove(index);
    }

    public final TValue getItem(TKey key) {
        int index = this.CheckName(key);
        return (TValue)this.get(index);
    }

    public final void setItem(TKey key, TValue value) {
        int index = this.CheckName(key);
        this.set(index, value);
    }

    public final boolean TryGetValue(TKey key, RefObject<TValue> value) {
        int index = this.indexOf(key);
        if (index >= 0) {
            value.argvalue = this.get(index);
            return true;
        }
        value.argvalue = null;
        return false;
    }
}

