/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.entity;

import java.util.List;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class CloneUtils {
    private static final String STRING = "??????";
    private static final String BOS_DATAENTITY = "bos-dataentity";
    private static final String SPAN_PARAM_ERRPROP = "err.prop";
    private boolean isOnlyDbProperty;
    private boolean _clearPrimaryKeyValue;

    public CloneUtils(boolean onlyDbProperty, boolean clearPrimaryKeyValue) {
        this.isOnlyDbProperty = onlyDbProperty;
        this._clearPrimaryKeyValue = clearPrimaryKeyValue;
    }

    public Object clone(IDataEntityBase dataEntity) {
        IDataEntityType dt = dataEntity.getDataEntityType();
        return this.clone(dt, dataEntity);
    }

    public Object clone(IDataEntityType dt, Object dataEntity) {
        try (EntityTraceSpan span = null;){
            span = EntityTracer.create("CloneUtils", "copyData", EntityTraceHint.getHintDisLinkAPM());
            Object object = this.clone(dt, dataEntity, this._clearPrimaryKeyValue);
            return object;
        }
    }

    private Object clone(IDataEntityType dt, Object dataEntity, boolean clearPrimaryKeyValue) {
        if (dataEntity == null) {
            return null;
        }
        Object newEntity = dt.createInstance();
        this.CopyData(dt, dataEntity, newEntity, clearPrimaryKeyValue);
        return newEntity;
    }

    private void CopyData(IDataEntityType dt, Object dataEntity, Object newEntity, boolean clearPrimaryKeyValue) {
        IDataEntityType dtOld = dt;
        IDataEntityType dtNew = dt;
        if (dataEntity instanceof IDataEntityBase) {
            dtOld = ((IDataEntityBase)dataEntity).getDataEntityType();
        }
        if (newEntity instanceof IDataEntityBase) {
            dtNew = ((IDataEntityBase)newEntity).getDataEntityType();
        }
        if (dataEntity instanceof DynamicObject && dtOld == dtNew) {
            ((DynamicObject)newEntity).setDataStorage(((DynamicObject)dataEntity).getDataStorage().memberClone());
        } else {
            for (ISimpleProperty sp : dt.getProperties().getSimpleProperties(this.isOnlyDbProperty)) {
                IDataEntityProperty dpOldProp = null;
                RefObject<Object> tempRef_dpOldProp = new RefObject<Object>(dpOldProp);
                this.TryGetOldProperty(sp, dtOld, tempRef_dpOldProp);
                dpOldProp = (IDataEntityProperty)tempRef_dpOldProp.argvalue;
                if (sp.getReadOnly() || dpOldProp == null) continue;
                sp.setValue(newEntity, dpOldProp.getValue(dataEntity));
            }
        }
        if (clearPrimaryKeyValue) {
            ISimpleProperty pk = dt.getPrimaryKey();
            if (pk != null) {
                pk.resetValue(newEntity);
            }
            dtNew.setDirty(newEntity, true);
        }
        for (IComplexProperty cpx : dt.getProperties().getComplexProperties(this.isOnlyDbProperty)) {
            Object cpxNewValue;
            if (!StringUtils.isBlank(cpx.getRefIdPropName())) continue;
            IDataEntityProperty dpOldProp = null;
            RefObject<Object> tempRef_dpOldProp2 = new RefObject<Object>(dpOldProp);
            this.TryGetOldProperty(cpx, dtOld, tempRef_dpOldProp2);
            dpOldProp = (IDataEntityProperty)tempRef_dpOldProp2.argvalue;
            Object cpxValue = dpOldProp.getValue(dataEntity);
            if (cpxValue == null) continue;
            IDataEntityBase cpxValue2 = (IDataEntityBase)(cpxValue instanceof IDataEntityBase ? cpxValue : null);
            IDataEntityType cpxType = cpxValue2 != null ? cpxValue2.getDataEntityType() : cpx.getComplexType();
            if (cpx.getReadOnly()) {
                cpxNewValue = cpx.getValue(newEntity);
                if (cpxNewValue == null) {
                    EntityTracer.addLocaleTag(SPAN_PARAM_ERRPROP, cpx.getName());
                    throw new ORMDesignException(STRING, ResManager.loadKDString("\u54e6\uff0c\u771f\u4e0d\u5e78\uff0c\u53ea\u8bfb\u7684\u5c5e\u6027\u5374\u8fd4\u56de\u4e86NULL\u503c\u3002", "CloneUtils_0", BOS_DATAENTITY, new Object[0]));
                }
                this.copySubData(dt, cpx, cpxType, cpxValue, cpxNewValue, false);
                continue;
            }
            cpxNewValue = cpx.isDbIgnore() ? this.copySubData(dt, cpx, cpxType, cpxValue, false) : this.copySubData(dt, cpx, cpxType, cpxValue, this._clearPrimaryKeyValue);
            cpx.setValue(newEntity, cpxNewValue);
        }
        for (ICollectionProperty colp : dt.getProperties().getCollectionProperties(this.isOnlyDbProperty)) {
            List colpNewListValue;
            Object colpNewValue;
            IDataEntityProperty dpOldProp = null;
            RefObject<Object> tempRef_dpOldProp3 = new RefObject<Object>(dpOldProp);
            this.TryGetOldProperty(colp, dtOld, tempRef_dpOldProp3);
            dpOldProp = (IDataEntityProperty)tempRef_dpOldProp3.argvalue;
            Object colpValue = dpOldProp.getValue(dataEntity);
            if (colp == null || colpValue == null) continue;
            Iterable colpListValue = (Iterable)(colpValue instanceof Iterable ? colpValue : null);
            if (colpListValue == null) {
                EntityTracer.addLocaleTag(SPAN_PARAM_ERRPROP, colp.getName());
                throw new ORMDesignException(STRING, ResManager.loadKDString("\u54e6\uff0c\u771f\u4e0d\u5e78\uff0c\u96c6\u5408\u7684\u5c5e\u6027\u8fd4\u56de\u503c\u4e0d\u652f\u6301\u679a\u4e3e\u3002", "CloneUtils_1", BOS_DATAENTITY, new Object[0]));
            }
            if (newEntity instanceof DynamicObject) {
                ((DynamicObject)newEntity).getDataStorage().setLocalValue(colp, null);
            }
            if ((colpNewValue = colp.getValue(newEntity)) == null) {
                if (!colp.getReadOnly()) {
                    colpNewValue = TypesContainer.createInstance(colp.getPropertyType());
                    colp.setValue(newEntity, colpNewValue);
                } else {
                    EntityTracer.addLocaleTag(SPAN_PARAM_ERRPROP, colp.getName());
                    throw new ORMDesignException(STRING, ResManager.loadKDString("\u54e6\uff0c\u771f\u4e0d\u5e78\uff0c\u96c6\u5408\u7684\u5c5e\u6027\u8fd4\u56de\u503c\u4e3anull\u3002", "CloneUtils_2", BOS_DATAENTITY, new Object[0]));
                }
            }
            if ((colpNewListValue = (List)(colpNewValue instanceof List ? colpNewValue : null)) == null) {
                EntityTracer.addLocaleTag(SPAN_PARAM_ERRPROP, colp.getName());
                throw new ORMDesignException(STRING, ResManager.loadKDString("\u54e6\uff0c\u771f\u4e0d\u5e78\uff0c\u96c6\u5408\u7684\u5c5e\u6027\u8fd4\u56de\u503c\u4e0d\u652f\u6301IList\u3002", "CloneUtils_3", BOS_DATAENTITY, new Object[0]));
            }
            colpNewListValue.clear();
            for (Object item : colpListValue) {
                IDataEntityBase itemAsEntity = (IDataEntityBase)(item instanceof IDataEntityBase ? item : null);
                IDataEntityType itemType = itemAsEntity == null ? colp.getItemType() : itemAsEntity.getDataEntityType();
                colpNewListValue.add(this.copySubData(dt, colp, itemType, item, this._clearPrimaryKeyValue));
            }
        }
        this.copyGLData2Entity(dt, dtOld, newEntity, dataEntity);
    }

    private void copySubData(IDataEntityType parentType, IDataEntityProperty parentProp, IDataEntityType dt, Object dataEntity, Object newEntity, boolean clearPrimaryKeyValue) {
        try {
            this.CopyData(dt, dataEntity, newEntity, clearPrimaryKeyValue);
        }
        catch (RuntimeException e) {
            EntityTracer.addLocaleTag(parentType.getName() + "." + parentProp.getName(), dt.getName());
            throw e;
        }
    }

    private Object copySubData(IDataEntityType parentType, IDataEntityProperty parentProp, IDataEntityType dt, Object dataEntity, boolean clearPrimaryKeyValue) {
        try {
            return this.clone(dt, dataEntity, clearPrimaryKeyValue);
        }
        catch (RuntimeException e) {
            EntityTracer.addLocaleTag(parentType.getName() + "." + parentProp.getName(), dt.getName());
            throw e;
        }
    }

    private void copyGLData2Entity(IDataEntityType dt, IDataEntityType dtOld, Object newEntity, Object dataEntity) {
        for (ISimpleProperty sp : dt.getProperties().getSimpleProperties(this.isOnlyDbProperty)) {
            if (sp.getReadOnly() || !(sp instanceof ILocaleProperty)) continue;
            IDataEntityProperty dpOldProp = null;
            RefObject<Object> tempRef_dpOldProp = new RefObject<Object>(dpOldProp);
            this.TryGetOldProperty(sp, dtOld, tempRef_dpOldProp);
            dpOldProp = (IDataEntityProperty)tempRef_dpOldProp.argvalue;
            if (dpOldProp == null) continue;
            ((ILocaleProperty)((Object)sp)).setGlangValue(newEntity, String.valueOf(dpOldProp.getValue(dataEntity)));
        }
    }

    private boolean TryGetOldProperty(IDataEntityProperty dp, IDataEntityType dtOldData, RefObject<IDataEntityProperty> dpOldProperty) {
        dpOldProperty.argvalue = null;
        if (dtOldData == null || dp == null) {
            return false;
        }
        return dtOldData.getProperties().tryGetValue(dp.getName(), dpOldProperty);
    }
}

