/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.entity;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.BitSet;
import kd.bos.dataentity.entity.BoolDataEntityState;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.INotifyPropertyChanged;
import kd.bos.dataentity.entity.IObjectWithParent;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class DataEntityBase
implements INotifyPropertyChanged,
ISupportInitialize,
IDataEntityBase,
IObjectWithParent,
Serializable {
    private static final long serialVersionUID = 6207244548917468168L;
    private Object _parent;
    protected transient PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private transient boolean _initializing;
    private transient boolean _isResetDirtyFlag;
    private BoolDataEntityState _state;

    @Override
    @KSMethod
    public abstract IDataEntityType getDataEntityType();

    protected Object readResolve() {
        this.changes = new PropertyChangeSupport(this);
        return this;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changes.getPropertyChangeListeners();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void OnPropertyChanged(PropertyChangeEvent e) {
        if (this._initializing && !this._isResetDirtyFlag) {
            return;
        }
        this.getDataEntityState().setPropertyChanged(e);
        this.changes.firePropertyChange(e);
    }

    @KSMethod
    public final boolean isInitializing() {
        return this._initializing;
    }

    @Override
    @KSMethod
    public boolean isInitialized() {
        return !this._initializing;
    }

    @Override
    @KSMethod
    public void beginInit() {
        this._initializing = true;
    }

    @Override
    @KSMethod
    public void endInit() {
        if (this._initializing) {
            this._initializing = false;
        }
    }

    public final boolean isResetDirtyFlag() {
        return this._isResetDirtyFlag;
    }

    public void beginResetDirtyFlag() {
        this._isResetDirtyFlag = true;
    }

    public void endResetDirtyFlag() {
        if (this._isResetDirtyFlag) {
            this._isResetDirtyFlag = false;
        }
    }

    @KSMethod
    public final synchronized DataEntityState getDataEntityState() {
        if (this._state == null) {
            DataEntityPropertyCollection _properties = this.getDataEntityType().getProperties();
            BitSet dirtyArray = new BitSet(_properties.size());
            this._state = new BoolDataEntityState(_properties, dirtyArray);
        }
        return this._state;
    }

    public void refreshDataEntityState() {
        this._state = null;
        this.getDataEntityState();
    }

    @Override
    public void setParent(Object value) {
        this._parent = value;
    }

    @Override
    @KSMethod
    public final Object getParent() {
        return this._parent;
    }

    @Override
    @KSMethod
    public Object getPkValue() {
        if (this.getDataEntityType().getPrimaryKey() == null) {
            return null;
        }
        ISimpleProperty pkProp = this.getDataEntityType().getPrimaryKey();
        return pkProp.getValueFast(this);
    }
}

