/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.entity;

import dm.jdbc.util.IDGenerator;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public abstract class DataEntityState
implements Serializable {
    private static final long serialVersionUID = 3109603972951301325L;
    private PkSnapshotSet _pkSnapshotSet;
    private boolean _fromDatabase;
    private Map<String, EntryInfo> entryInfos;
    private long _instanceId;
    private final AtomicBoolean _instanceIdSetFlag = new AtomicBoolean(false);
    private Map<String, Boolean> cacheState;
    protected BitSet _bizChanged = new BitSet();
    private Boolean removedItems = false;

    protected DataEntityState() {
        this._instanceId = IDGenerator.generate();
    }

    public Map<String, Boolean> getCacheState() {
        return this.cacheState;
    }

    public Boolean getCacheState(String key) {
        if (this.cacheState != null && this.cacheState.containsKey(key)) {
            return this.cacheState.get(key);
        }
        return false;
    }

    public void setCacheState(Map<String, Boolean> cacheState) {
        this.cacheState = cacheState;
    }

    public void setCacheState(String key, Boolean state) {
        if (this.cacheState == null) {
            this.cacheState = new HashMap<String, Boolean>();
        }
        this.cacheState.put(key, state);
    }

    @KSMethod
    public long getInstanceId() {
        return this._instanceId;
    }

    @KSMethod
    public void setInstanceId(long instanceId) {
        if (this._instanceIdSetFlag.compareAndSet(false, true)) {
            this._instanceId = instanceId;
        }
    }

    @KSMethod
    public abstract void setPropertyChanged(PropertyChangeEvent var1);

    @KSMethod
    public abstract boolean getDataEntityDirty();

    @KSMethod
    public abstract List<IDataEntityProperty> GetDirtyProperties();

    @KSMethod
    public abstract List<IDataEntityProperty> GetDirtyProperties(boolean var1);

    @KSMethod
    public abstract long[] getDirtyFlags();

    @KSMethod
    public abstract void setDirtyFlags(long[] var1);

    @KSMethod
    public abstract void setDirty(boolean var1);

    public void setDirty(ISimpleProperty prop, boolean newValue) {
    }

    public final PkSnapshotSet getPkSnapshotSet() {
        return this._pkSnapshotSet;
    }

    @KSMethod
    public final void setPkSnapshotSet(PkSnapshotSet value) {
        this._pkSnapshotSet = value;
    }

    @KSMethod
    public final boolean getFromDatabase() {
        return this._fromDatabase;
    }

    @KSMethod
    public final void setFromDatabase(boolean value) {
        this._fromDatabase = value;
        if (this._fromDatabase) {
            this.setDirty(false);
            this.setRemovedItems(false);
            for (int i = 0; i < this._bizChanged.length(); ++i) {
                this._bizChanged.set(i, false);
            }
        }
    }

    @KSMethod
    public final void setFromDatabase(boolean value, boolean clearDirty) {
        this._fromDatabase = value;
        if (clearDirty) {
            this.setFromDatabase(value);
        }
    }

    public Iterable<IDataEntityProperty> getBizChangedProperties() {
        return new ArrayList<IDataEntityProperty>();
    }

    @KSMethod
    public final boolean isBizChanged() {
        boolean changed = false;
        for (int i = 1; i < this._bizChanged.length(); ++i) {
            boolean bl = changed = this._bizChanged.get(i) || changed;
            if (changed) break;
        }
        return changed;
    }

    @KSMethod
    public final void setBizChanged(boolean value) {
        if (value) {
            this._bizChanged.set(1, true);
        } else {
            for (int i = 1; i < this._bizChanged.length(); ++i) {
                this._bizChanged.set(i, false);
            }
        }
    }

    @KSMethod
    public final void setBizChanged(int propOrdinal, boolean value) {
        if (propOrdinal > 0) {
            this._bizChanged.set(propOrdinal, value);
        }
    }

    public final boolean isPushChanged() {
        return this._bizChanged.get(0);
    }

    @KSMethod
    public final void setPushChanged(boolean value) {
        this._bizChanged.set(0, value);
    }

    public final long[] getBizChangeFlags() {
        return this._bizChanged.toLongArray();
    }

    @KSMethod
    public final void setBizChangeFlags(long[] values) {
        this._bizChanged = BitSet.valueOf(values);
    }

    public final boolean isChanged() {
        boolean changed = false;
        for (int i = 0; i < this._bizChanged.length(); ++i) {
            boolean bl = changed = this._bizChanged.get(i) || changed;
            if (changed) break;
        }
        return changed;
    }

    @KSMethod
    public void setRemovedItems(Boolean removedItems) {
        this.removedItems = removedItems;
    }

    @KSMethod
    public Boolean getRemovedItems() {
        return this.removedItems;
    }

    public Map<String, EntryInfo> getEntryInfos() {
        return this.entryInfos;
    }

    public void setEntryInfos(Map<String, EntryInfo> entryInfos) {
        this.entryInfos = entryInfos;
    }

    public void setEntryStartRowIndex(String entryName, int startRowIndex) {
        EntryInfo entryInfo;
        if (this.entryInfos == null) {
            this.entryInfos = new HashMap<String, EntryInfo>();
        }
        if ((entryInfo = this.entryInfos.get(entryName)) == null) {
            entryInfo = new EntryInfo();
            this.entryInfos.put(entryName, entryInfo);
        }
        entryInfo.setStartRowIndex(startRowIndex);
    }

    public int getEntryStartRowIndex(String entryName) {
        if (this.entryInfos == null) {
            return 0;
        }
        EntryInfo entryInfo = this.entryInfos.get(entryName);
        if (entryInfo == null) {
            return 0;
        }
        return entryInfo.getStartRowIndex();
    }

    public void setEntryPageSize(String entryName, int pageSize) {
        EntryInfo entryInfo;
        if (this.entryInfos == null) {
            this.entryInfos = new HashMap<String, EntryInfo>();
        }
        if ((entryInfo = this.entryInfos.get(entryName)) == null) {
            entryInfo = new EntryInfo();
            this.entryInfos.put(entryName, entryInfo);
        }
        entryInfo.setPageSize(pageSize);
    }

    Integer getEntryPageSize(String entryName) {
        if (this.entryInfos == null) {
            return null;
        }
        EntryInfo entryInfo = this.entryInfos.get(entryName);
        if (entryInfo == null) {
            return null;
        }
        return entryInfo.getPageSize();
    }

    public void setEntryRowCount(String entryName, int rowCount) {
        EntryInfo entryInfo;
        if (this.entryInfos == null) {
            this.entryInfos = new HashMap<String, EntryInfo>();
        }
        if ((entryInfo = this.entryInfos.get(entryName)) == null) {
            entryInfo = new EntryInfo();
            this.entryInfos.put(entryName, entryInfo);
        }
        entryInfo.setRowCount(rowCount);
    }

    public Integer getEntryRowCount(String entryName) {
        if (this.entryInfos == null) {
            return null;
        }
        EntryInfo entryInfo = this.entryInfos.get(entryName);
        if (entryInfo == null) {
            return null;
        }
        return entryInfo.getRowCount();
    }

    public EntryInfo getEntryInfo(String entryName) {
        if (this.entryInfos == null) {
            return null;
        }
        return this.entryInfos.get(entryName);
    }

    public boolean isSplitPage() {
        if (this.getEntryInfos() == null) {
            return false;
        }
        for (Map.Entry<String, EntryInfo> entry : this.getEntryInfos().entrySet()) {
            if (entry.getValue().getRowCount() == null || entry.getValue().getRowCount() <= entry.getValue().getPageSize()) continue;
            return true;
        }
        return false;
    }
}

