/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.entity;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.IDataStorage;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ILongDataProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;

class LongDataStorage
implements IDataStorage,
Serializable {
    private static final int LONGSIZE = 64;
    private static final int INTSIZE = 32;
    private static final int LONGBIT = 6;
    private static final long[] _masks = new long[]{Long.MIN_VALUE, 0x4000000000000000L, 0x2000000200000000L, 0x1000000000000000L, 0x800000000000000L, 0x400000000000000L, 0x200000000000000L, 0x100000000000000L, 0x80000000000000L, 0x40000000000000L, 0x20000000000000L, 0x10000000000000L, 0x8000000000000L, 0x4000000000000L, 0x2000000000000L, 0x1000000000000L, 0x800000000000L, 0x400000000000L, 0x200000000000L, 0x100000000000L, 0x80000000000L, 0x40000000000L, 0x20000000000L, 0x10000000000L, 0x8000000000L, 0x4000000000L, 0x2000000000L, 0x1000000000L, 0x800000000L, 0x400000000L, 0x200000000L, 0x100000000L, 0x80000000L, 0x40000000L, 0x20000000L, 0x10000000L, 0x8000000L, 0x4000000L, 0x2000000L, 0x1000000L, 0x800000L, 0x400000L, 0x200000L, 0x100000L, 524288L, 262144L, 131072L, 65536L, 32768L, 16384L, 8192L, 4096L, 2048L, 1024L, 512L, 256L, 128L, 64L, 32L, 16L, 8L, 4L, 2L, 1L};
    private static final Map<Class<?>, Integer> dataGetSetterMap = new HashMap();
    private long[] storageData = null;
    private Object[] otherData;

    private LongDataStorage() {
    }

    public LongDataStorage(DynamicObjectType dt) {
        this.init(dt.getProperties());
    }

    private void init(DataEntityPropertyCollection classes) {
        if (classes == null || classes.size() == 0) {
            return;
        }
        if (classes.getBitSize() == 0 && classes.getOtherSize() == 0) {
            this.reCalcBitPos(classes);
        }
        this.storageData = new long[(classes.getBitSize() >> 6) + 1];
        this.otherData = new Object[classes.getOtherSize()];
    }

    private void setNullBit(int nullBit, boolean flag) {
        this.setBoolean(nullBit, !flag);
    }

    private boolean getNullBit(int nullBit) {
        int pos = nullBit >> 6;
        int offSet = nullBit % 64;
        return (this.storageData[pos] & _masks[offSet]) != _masks[offSet];
    }

    private void setBoolean(int bitPos, boolean data) {
        int pos = bitPos >> 6;
        int offset = bitPos % 64;
        if (data) {
            int n = pos;
            this.storageData[n] = this.storageData[n] | _masks[offset];
        } else {
            int n = pos;
            this.storageData[n] = this.storageData[n] & (_masks[offset] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public Object getLocalValue(IDataEntityProperty property) {
        int nullBit;
        ILongDataProperty longDataProperty = (ILongDataProperty)((Object)property);
        int bitPos = longDataProperty.getBitPos();
        if (bitPos < 0) {
            this.reCalcBitPos(property.getParent().getProperties());
            bitPos = longDataProperty.getBitPos();
        }
        if ((nullBit = longDataProperty.getNullBit()) >= 0 && this.getNullBit(nullBit)) {
            return null;
        }
        Class<?> propertyType = property.getPropertyType();
        if (propertyType == Boolean.class || propertyType == Boolean.TYPE) {
            int pos = bitPos >> 6;
            int offSet = bitPos % 64;
            return (this.storageData[pos] & _masks[offSet]) == _masks[offSet] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (propertyType == Long.class || propertyType == Long.TYPE) {
            int pos = bitPos >> 6;
            return this.storageData[pos];
        }
        if (propertyType == Integer.class || propertyType == Integer.TYPE) {
            int pos = bitPos >> 6;
            int offset = bitPos % 64;
            if (offset == 0) {
                return (int)(this.storageData[pos] >>> 32);
            }
            return (int)this.storageData[pos];
        }
        if (propertyType == Date.class) {
            long lValue = this.storageData[bitPos >> 6];
            return new Date(lValue);
        }
        return this.otherData[bitPos];
    }

    @Override
    public void setLocalValue(IDataEntityProperty property, Object value) {
        Class<?> propertyType;
        int nullBit;
        ILongDataProperty longDataProperty = (ILongDataProperty)((Object)property);
        int bitPos = longDataProperty.getBitPos();
        if (bitPos < 0) {
            this.reCalcBitPos(property.getParent().getProperties());
            bitPos = longDataProperty.getBitPos();
        }
        if ((nullBit = longDataProperty.getNullBit()) > 0) {
            if (value == null) {
                this.setNullBit(nullBit, true);
                return;
            }
            this.setNullBit(nullBit, false);
        }
        if ((propertyType = property.getPropertyType()) == Boolean.class || propertyType == Boolean.TYPE) {
            this.setBoolean(bitPos, (Boolean)value);
        } else if (propertyType == Long.class || propertyType == Long.TYPE) {
            this.storageData[bitPos >> 6] = (Long)value;
        } else if (propertyType == Integer.class || propertyType == Integer.TYPE) {
            int pos = bitPos >> 6;
            int offset = bitPos % 64;
            int i = (Integer)value;
            this.storageData[pos] = offset == 0 ? this.storageData[pos] & 0xFFFFFFFFL | (long)i << 32 : this.storageData[pos] & 0xFFFFFFFF00000000L | (long)i;
        } else if (propertyType == Date.class) {
            this.storageData[bitPos >> 6] = ((Date)value).getTime();
        } else {
            this.otherData[bitPos] = value;
        }
    }

    private void reCalcBitPos(DataEntityPropertyCollection collection) {
        Integer size;
        ILongDataProperty prop;
        int bitCount = 0;
        int otherCount = 0;
        for (IDataEntityProperty property : collection) {
            prop = (ILongDataProperty)((Object)property);
            size = dataGetSetterMap.get(property.getPropertyType());
            if (size == null) {
                prop.setBitPos(otherCount);
                prop.setNullBit(-1);
                ++otherCount;
                continue;
            }
            if (size % 64 != 0) continue;
            prop.setBitPos(bitCount);
            bitCount += size.intValue();
        }
        for (IDataEntityProperty property : collection) {
            prop = (ILongDataProperty)((Object)property);
            size = dataGetSetterMap.get(property.getPropertyType());
            if (size == null || size != 32) continue;
            prop.setBitPos(bitCount);
            bitCount += size.intValue();
        }
        for (IDataEntityProperty property : collection) {
            prop = (ILongDataProperty)((Object)property);
            size = dataGetSetterMap.get(property.getPropertyType());
            if (size == null) continue;
            if (size == 1) {
                prop.setBitPos(bitCount);
                ++bitCount;
            }
            prop.setNullBit(bitCount);
            ++bitCount;
        }
        collection.setBitSize(bitCount);
        collection.setOtherSize(otherCount);
    }

    @Override
    public IDataStorage memberClone() {
        long[] newValues = new long[this.storageData.length];
        System.arraycopy(this.storageData, 0, newValues, 0, this.storageData.length);
        Object[] newOtherData = new Object[this.otherData.length];
        System.arraycopy(this.otherData, 0, newOtherData, 0, this.otherData.length);
        for (int i = 0; i < newOtherData.length; ++i) {
            if (!(newOtherData[i] instanceof ILocaleValue)) continue;
            newOtherData[i] = null;
        }
        LongDataStorage longDataStorage = new LongDataStorage();
        longDataStorage.storageData = newValues;
        longDataStorage.otherData = newOtherData;
        return longDataStorage;
    }

    public LongDataStorage clone() {
        LongDataStorage longDataStorage = new LongDataStorage();
        longDataStorage.storageData = this.storageData;
        longDataStorage.otherData = this.otherData;
        return longDataStorage;
    }

    public String toString() {
        return this.storageData.length + " " + Arrays.asList(this.otherData);
    }

    static {
        dataGetSetterMap.put(Boolean.class, 1);
        dataGetSetterMap.put(Boolean.TYPE, 1);
        dataGetSetterMap.put(Integer.class, 32);
        dataGetSetterMap.put(Integer.TYPE, 32);
        dataGetSetterMap.put(Long.class, 64);
        dataGetSetterMap.put(Long.TYPE, 64);
        dataGetSetterMap.put(Date.class, 64);
    }
}

