/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.entity;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ObjectConverter {
    public static final BigDecimal ZERO_BIGDECIMAL = new BigDecimal("0");
    public static final Long ZERO_LONG = 0L;
    public static final Integer ZERO_INTEGER = 0;
    public static final Double ZERO_DOUBLE = 0.0;
    public static final Float ZERO_FLOAT = Float.valueOf(0.0f);
    public static final Short ZERO_SHORT = 0;
    public static final Byte ZERO_BYTE = 0;
    static Map<String, Converter<?>> converterMap = new HashMap();

    @Deprecated
    public static <T> T convert(Object value, Class<T> cls) {
        if (cls == null) {
            return (T)value;
        }
        if (value != null && cls.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        Converter<?> converter = converterMap.get(cls.getName());
        if (converter == null) {
            return (T)value;
        }
        return (T)converter.convert(value);
    }

    public static <T> T convert(Object value, Class<T> cls, boolean enableNull) {
        if (cls == null) {
            return (T)value;
        }
        if (value != null && cls.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        Converter<?> converter = converterMap.get(cls.getName());
        if (converter == null) {
            return (T)value;
        }
        if (converter instanceof BigDecimalConverter || converter instanceof DoubleConverter || converter instanceof FloatConverter || converter instanceof IntegerConverter || converter instanceof LongConverter || converter instanceof ShortConverter) {
            return (T)converter.convert(value, enableNull);
        }
        return (T)converter.convert(value);
    }

    static {
        converterMap.put("java.lang.String", new StringConverter());
        converterMap.put(ILocaleString.class.getName(), new LocaleStringConverter());
        LongConverter longc = new LongConverter();
        converterMap.put("java.lang.Long", longc);
        converterMap.put("long", longc);
        IntegerConverter intc = new IntegerConverter();
        converterMap.put("java.lang.Integer", intc);
        converterMap.put("int", intc);
        ShortConverter shortc = new ShortConverter();
        converterMap.put("java.lang.Short", shortc);
        converterMap.put("short", shortc);
        FloatConverter floatc = new FloatConverter();
        converterMap.put("java.lang.Float", floatc);
        converterMap.put("float", floatc);
        DoubleConverter doublec = new DoubleConverter();
        converterMap.put("java.lang.Double", doublec);
        converterMap.put("double", doublec);
        ByteConverter bytec = new ByteConverter();
        converterMap.put("java.lang.Byte", bytec);
        converterMap.put("byte", bytec);
        BooleanConverter booleanc = new BooleanConverter();
        converterMap.put("java.lang.Boolean", booleanc);
        converterMap.put("boolean", booleanc);
        CharConverter charc = new CharConverter();
        converterMap.put("java.lang.Character", charc);
        converterMap.put("char", charc);
        converterMap.put("java.math.BigDecimal", new BigDecimalConverter());
        DateConverter datec = new DateConverter();
        converterMap.put("java.util.Date", datec);
        converterMap.put("java.sql.Date", datec);
        converterMap.put("java.sql.Timestamp", datec);
    }

    public static class DateConverter
    implements Converter<Date> {
        SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss");

        @Override
        public Date convert(Object value) {
            if (value instanceof String && ((String)value).length() > 0) {
                String s = ((String)value).trim();
                try {
                    if (s.length() == 0) {
                        return null;
                    }
                    if (s.indexOf(32) != -1) {
                        return this.datetime.parse(s);
                    }
                    if (s.indexOf(58) != -1) {
                        return this.time.parse(s);
                    }
                    return this.date.parse(s);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Date value format error: " + s, e);
                }
            }
            if (value instanceof Date) {
                return (Date)value;
            }
            if (value instanceof Long) {
                return new Date((Long)value);
            }
            return null;
        }
    }

    static class BigDecimalConverter
    implements Converter<BigDecimal> {
        BigDecimalConverter() {
        }

        @Override
        public BigDecimal convert(Object value) {
            if (value == null) {
                return ZERO_BIGDECIMAL;
            }
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof Number) {
                if (value instanceof Float) {
                    return new BigDecimal(Float.toString(((Float)value).floatValue()));
                }
                if (value instanceof Double) {
                    return new BigDecimal(Double.toString((Double)value));
                }
                if (value instanceof Long) {
                    return BigDecimal.valueOf((Long)value);
                }
                if (value instanceof Integer) {
                    return BigDecimal.valueOf(((Integer)value).intValue());
                }
                return BigDecimal.valueOf(((Number)value).doubleValue());
            }
            return new BigDecimal(String.valueOf(value));
        }

        @Override
        public BigDecimal convert(Object value, boolean enableNull) {
            if (value == null && enableNull) {
                return null;
            }
            return this.convert(value);
        }
    }

    static class ByteConverter
    implements Converter<Byte> {
        ByteConverter() {
        }

        @Override
        public Byte convert(Object value) {
            if (value instanceof String && ((String)value).length() > 0) {
                return Byte.valueOf((String)value);
            }
            if (value instanceof Byte) {
                return (Byte)value;
            }
            return null;
        }
    }

    static class CharConverter
    implements Converter<Character> {
        CharConverter() {
        }

        @Override
        public Character convert(Object value) {
            if (value instanceof String && ((String)value).length() > 0) {
                return Character.valueOf(((String)value).charAt(0));
            }
            if (value instanceof Character) {
                return (Character)value;
            }
            return null;
        }
    }

    static class BooleanConverter
    implements Converter<Boolean> {
        BooleanConverter() {
        }

        @Override
        public Boolean convert(Object value) {
            if (value == null) {
                return false;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            String s = String.valueOf(value).trim();
            if ("1".equals(s)) {
                return true;
            }
            return Boolean.valueOf(s);
        }
    }

    static class ShortConverter
    implements Converter<Short> {
        ShortConverter() {
        }

        @Override
        public Short convert(Object value) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return (short)0;
            }
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            return Short.parseShort(String.valueOf(value));
        }

        @Override
        public Short convert(Object value, boolean enableNull) {
            if (value == null && enableNull) {
                return null;
            }
            return this.convert(value);
        }
    }

    static class DoubleConverter
    implements Converter<Double> {
        DoubleConverter() {
        }

        @Override
        public Double convert(Object value) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return 0.0;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.parseDouble(String.valueOf(value));
        }

        @Override
        public Double convert(Object value, boolean enableNull) {
            if (value == null && enableNull) {
                return null;
            }
            return this.convert(value);
        }
    }

    static class FloatConverter
    implements Converter<Float> {
        FloatConverter() {
        }

        @Override
        public Float convert(Object value) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return Float.valueOf(0.0f);
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return Float.valueOf(Float.parseFloat(String.valueOf(value)));
        }

        @Override
        public Float convert(Object value, boolean enableNull) {
            if (value == null && enableNull) {
                return null;
            }
            return this.convert(value);
        }
    }

    static class IntegerConverter
    implements Converter<Integer> {
        IntegerConverter() {
        }

        @Override
        public Integer convert(Object value) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return 0;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(String.valueOf(value));
        }

        @Override
        public Integer convert(Object value, boolean enableNull) {
            if (value == null && enableNull) {
                return null;
            }
            return this.convert(value);
        }
    }

    static class LongConverter
    implements Converter<Long> {
        LongConverter() {
        }

        @Override
        public Long convert(Object value) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return 0L;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.parseLong(String.valueOf(value));
        }

        @Override
        public Long convert(Object value, boolean enableNull) {
            if (value == null && enableNull) {
                return null;
            }
            return this.convert(value);
        }
    }

    static class LocaleStringConverter
    implements Converter<ILocaleString> {
        LocaleStringConverter() {
        }

        @Override
        public ILocaleString convert(Object value) {
            if (value == null) {
                return null;
            }
            return (ILocaleString)value;
        }
    }

    static class StringConverter
    implements Converter<String> {
        StringConverter() {
        }

        @Override
        public String convert(Object value) {
            if (value == null) {
                return null;
            }
            return String.valueOf(value);
        }
    }

    static interface Converter<T> {
        public T convert(Object var1);

        default public T convert(Object value, boolean enableNull) {
            return null;
        }
    }
}

