/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.limiter;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.limiter.ILimiterExceptionPolicy;
import kd.bos.dataentity.limiter.IRateLimiter;
import kd.bos.dataentity.limiter.KDRateLimiterException;
import org.jetbrains.annotations.NotNull;

public final class CountLimiter
implements IRateLimiter {
    private final int max;
    @NotNull
    private final ILimiterExceptionPolicy<CountLimiter> onExceptionPolicy;
    private final AtomicInteger _remaining;
    private boolean _isLimited = false;

    public CountLimiter(int max, @NotNull ILimiterExceptionPolicy<CountLimiter> onExceptionPolicy) {
        Objects.requireNonNull(onExceptionPolicy, "onExceptionPolicy must not be null");
        this.max = max;
        this.onExceptionPolicy = onExceptionPolicy;
        this._remaining = new AtomicInteger(this.max);
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public int getRemaining() {
        return this._remaining.get();
    }

    @Override
    public boolean isLimited() {
        return this._isLimited;
    }

    @Override
    public void acquire() throws KDRateLimiterException {
        this.acquire(1);
    }

    @Override
    public void acquire(int count) throws KDRateLimiterException {
        if (this.isUnlimited()) {
            return;
        }
        if (count < 0) {
            throw new RuntimeException("count <= 0");
        }
        int remaining = this._remaining.get();
        while (remaining >= 0 && remaining - count >= 0) {
            if (this._remaining.compareAndSet(remaining, remaining - count)) {
                return;
            }
            remaining = this._remaining.get();
        }
        try {
            this.onExceptionPolicy.accept(this, count);
        }
        finally {
            this._isLimited = true;
        }
    }
}

