/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.limiter;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import kd.bos.dataentity.limiter.CountLimiter;
import kd.bos.dataentity.limiter.ICreator;
import kd.bos.dataentity.limiter.ILimiterExceptionPolicy;
import kd.bos.dataentity.limiter.IRateLimiter;
import kd.bos.dataentity.limiter.LimiterExceptionPolicy;
import org.jetbrains.annotations.NotNull;

public final class CountLimiterPolicy
implements ICreator<IRateLimiter> {
    @NotNull
    private final IntSupplier maxProvider;
    @NotNull
    private final ILimiterExceptionPolicy<CountLimiter> onException;

    public CountLimiterPolicy(@NotNull IntSupplier maxProvider, @NotNull Supplier<String> captionProvider) {
        Objects.requireNonNull(maxProvider, "maxProvider must not be null");
        this.maxProvider = maxProvider;
        this.onException = LimiterExceptionPolicy.create(captionProvider);
    }

    public CountLimiterPolicy(@NotNull IntSupplier maxProvider, @NotNull BiFunction<CountLimiter, Integer, String> messageProvider) {
        Objects.requireNonNull(maxProvider, "maxProvider must not be null");
        this.maxProvider = maxProvider;
        this.onException = LimiterExceptionPolicy.create(messageProvider);
    }

    public CountLimiterPolicy(@NotNull IntSupplier maxProvider, @NotNull ILimiterExceptionPolicy<CountLimiter> onException) {
        Objects.requireNonNull(maxProvider, "maxProvider must not be null");
        Objects.requireNonNull(onException, "onException must not be null");
        this.maxProvider = maxProvider;
        this.onException = onException;
    }

    @Override
    @NotNull
    public CountLimiter create() {
        return new CountLimiter(this.maxProvider.getAsInt(), this.onException);
    }
}

