/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.limiter;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;

public final class KingScriptEnv {
    private static final MethodHandle _getRuntimeMethod;
    private static final MethodHandle _getCallerFrameMethod;
    @NotNull
    private static BooleanSupplier _isKingScriptEnvImpl;

    public static boolean isKingScriptEnv() {
        return _isKingScriptEnvImpl.getAsBoolean();
    }

    @NotNull
    public static BooleanSupplier getIsKingScriptEnvImpl() {
        return _isKingScriptEnvImpl;
    }

    public static void setIsKingScriptEnvImpl(@NotNull BooleanSupplier impl) {
        Objects.requireNonNull(impl, "impl must not be null.");
        _isKingScriptEnvImpl = impl;
    }

    public static boolean isKingScriptEnvDefault() {
        try {
            Object runtime = _getRuntimeMethod.invokeExact();
            if (runtime == null) {
                return false;
            }
            return _getCallerFrameMethod.invoke(runtime) != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static {
        try {
            Class<?> truffleClz = Class.forName("com.oracle.truffle.api.Truffle");
            Class<?> runtimeClz = Class.forName("com.oracle.truffle.api.TruffleRuntime");
            Method getRuntimeMethod = truffleClz.getMethod("getRuntime", new Class[0]);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            _getRuntimeMethod = lookup.unreflect(getRuntimeMethod).asType(MethodType.methodType(Object.class));
            Class<?> frameClz = Class.forName("com.oracle.truffle.api.frame.FrameInstance");
            Method getCallerFrameMethod = runtimeClz.getMethod("getCallerFrame", new Class[0]);
            MethodType getCallerFrameType = MethodType.methodType(frameClz, runtimeClz);
            _getCallerFrameMethod = lookup.unreflect(getCallerFrameMethod).asType(getCallerFrameType);
            _isKingScriptEnvImpl = KingScriptEnv::isKingScriptEnvDefault;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

