/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.limiter;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import kd.bos.dataentity.limiter.IRateLimiter;
import kd.bos.dataentity.limiter.KDRateLimiterException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KingScriptHybridLimiter<T extends IRateLimiter>
implements IRateLimiter {
    @NotNull
    private final BooleanSupplier isKingScriptEnvImpl;
    @NotNull
    private final T scriptLimiter;
    @Nullable
    private final T jvmLimiter;

    public KingScriptHybridLimiter(@NotNull BooleanSupplier isKingScriptEnvImpl, @NotNull T scriptLimiter, @Nullable T jvmLimiter) {
        Objects.requireNonNull(isKingScriptEnvImpl, "isKingScriptEnvImpl must not be null");
        Objects.requireNonNull(scriptLimiter, "scriptLimiter must not be null");
        this.isKingScriptEnvImpl = isKingScriptEnvImpl;
        this.scriptLimiter = scriptLimiter;
        this.jvmLimiter = jvmLimiter;
    }

    @NotNull
    public T getScriptLimiter() {
        return this.scriptLimiter;
    }

    @Nullable
    public T getJvmLimiter() {
        return this.jvmLimiter;
    }

    @Override
    public int getMax() {
        return this.isKingScriptEnv() ? this.scriptLimiter.getMax() : (this.jvmLimiter == null ? Integer.MAX_VALUE : this.jvmLimiter.getMax());
    }

    private boolean isKingScriptEnv() {
        return this.isKingScriptEnvImpl.getAsBoolean();
    }

    @Override
    public int getRemaining() {
        int result;
        int n = result = this.jvmLimiter == null ? Integer.MAX_VALUE : this.jvmLimiter.getRemaining();
        if (this.isKingScriptEnv()) {
            return Math.min(result, this.scriptLimiter.getRemaining());
        }
        return result;
    }

    @Override
    public boolean isLimited() {
        return this.scriptLimiter.isLimited() || this.jvmLimiter != null && this.jvmLimiter.isLimited();
    }

    @Override
    public void acquire() throws KDRateLimiterException {
        this.acquire(1);
    }

    @Override
    public void acquire(int count) throws KDRateLimiterException {
        if (this.isKingScriptEnv()) {
            this.scriptLimiter.acquire(count);
        }
        if (this.jvmLimiter != null) {
            this.jvmLimiter.acquire(count);
        }
    }
}

