/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.limiter;

import kd.bos.dataentity.limiter.ICreator;
import kd.bos.dataentity.limiter.IRateLimiter;
import kd.bos.dataentity.limiter.KingScriptEnv;
import kd.bos.dataentity.limiter.KingScriptHybridLimiter;
import kd.bos.dataentity.limiter.LimiterIntConfig;
import kd.bos.dataentity.limiter.ProgressiveIntConfig;
import kd.bos.dataentity.limiter.UnlimitedLimiter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KingScriptHybridLimiterPolicy<T extends IRateLimiter>
implements ICreator<IRateLimiter> {
    @NotNull
    private final ICreator<T> scriptLimiterPolicy;
    @Nullable
    private final ICreator<T> jvmLimiterPolicy;
    private static final LimiterIntConfig _limiterEnabledConfig = new LimiterIntConfig("bos.limit.enabled", 0, 1);

    public KingScriptHybridLimiterPolicy(@NotNull ICreator<T> scriptLimiterPolicy, @Nullable ICreator<T> jvmLimiterPolicy) {
        this.scriptLimiterPolicy = scriptLimiterPolicy;
        this.jvmLimiterPolicy = jvmLimiterPolicy;
    }

    @Override
    @NotNull
    public IRateLimiter create() {
        IRateLimiter jvmLimiter;
        IRateLimiter scriptLimiter = KingScriptHybridLimiterPolicy.isKingScriptLimiterEnabled() ? (IRateLimiter)this.scriptLimiterPolicy.create() : null;
        IRateLimiter iRateLimiter = jvmLimiter = this.jvmLimiterPolicy == null ? null : (IRateLimiter)this.jvmLimiterPolicy.create();
        if (scriptLimiter != null) {
            return new KingScriptHybridLimiter<IRateLimiter>(KingScriptEnv.getIsKingScriptEnvImpl(), scriptLimiter, jvmLimiter);
        }
        if (jvmLimiter != null) {
            return jvmLimiter;
        }
        return UnlimitedLimiter.DEFAULT;
    }

    public static LimiterIntConfig getLimiterEnabledConfig() {
        return _limiterEnabledConfig;
    }

    public static boolean isKingScriptLimiterEnabled() {
        ProgressiveIntConfig scriptConfig = _limiterEnabledConfig.getScriptConfig();
        return scriptConfig != null && scriptConfig.getAsInt() == 1;
    }
}

