/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.limiter;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import kd.bos.dataentity.limiter.ILimiterExceptionPolicy;
import kd.bos.dataentity.limiter.IRateLimiter;
import kd.bos.dataentity.limiter.KDRateLimiterException;
import kd.bos.dataentity.limiter.KingScriptEnv;
import kd.bos.dataentity.limiter.KingScriptHybridLimiterPolicy;
import kd.bos.dataentity.limiter.ProgressiveIntConfig;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.LimitEvent;
import org.jetbrains.annotations.NotNull;

public final class LimiterExceptionPolicy {
    public static <T extends IRateLimiter> ILimiterExceptionPolicy<T> create(@NotNull Supplier<String> captionProvider) {
        Objects.requireNonNull(captionProvider, "captionProvider must not be null.");
        return new CaptionOnException(captionProvider);
    }

    public static <T extends IRateLimiter> ILimiterExceptionPolicy<T> create(@NotNull BiFunction<T, Integer, String> messageProvider) {
        Objects.requireNonNull(messageProvider, "messageProvider must not be null.");
        return new MessageOnException<T>(messageProvider);
    }

    private static void throwOrLog(String message, RateLimitingAction action, boolean isLimited) {
        switch (action) {
            case THROW_EXCEPTION: {
                throw new KDRateLimiterException(message);
            }
            case LOG_TO_SYSTEM: {
                if (isLimited) break;
                EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)message);
            }
        }
    }

    static RateLimitingAction getAction() {
        if (KingScriptEnv.isKingScriptEnv()) {
            return LimiterExceptionPolicy.getAction(KingScriptHybridLimiterPolicy.getLimiterEnabledConfig().getScriptConfig());
        }
        return LimiterExceptionPolicy.getAction(KingScriptHybridLimiterPolicy.getLimiterEnabledConfig().getJvmConfig());
    }

    private static RateLimitingAction getAction(ProgressiveIntConfig config) {
        if (config != null && config.getAsInt() == 2) {
            return RateLimitingAction.LOG_TO_SYSTEM;
        }
        return RateLimitingAction.THROW_EXCEPTION;
    }

    private static class MessageOnException<T extends IRateLimiter>
    implements ILimiterExceptionPolicy<T> {
        @NotNull
        private final BiFunction<T, Integer, String> messageProvider;

        protected MessageOnException(@NotNull BiFunction<T, Integer, String> messageProvider) {
            this.messageProvider = messageProvider;
        }

        @Override
        public void accept(T source, Integer count) {
            String message = this.messageProvider.apply(source, count);
            LimiterExceptionPolicy.throwOrLog(message, LimiterExceptionPolicy.getAction(), source.isLimited());
        }
    }

    private static class CaptionOnException<T extends IRateLimiter>
    implements ILimiterExceptionPolicy<T> {
        @NotNull
        private final Supplier<String> captionProvider;

        protected CaptionOnException(@NotNull Supplier<String> captionProvider) {
            this.captionProvider = captionProvider;
        }

        @Override
        public void accept(T source, Integer count) {
            String message = this.captionProvider.get();
            message = String.format(ResManager.loadKDString("\u89e6\u53d1\u573a\u666f \u3010%1$s\u3011 \u7684\u9650\u6d41\uff0c\u6700\u5927: %2$d(\u5269\u4f59: %3$d), \u5f53\u524d: %4$d .", "CountLimiterPolicy_1", "bos-dataentity", message, source.getMax(), source.getRemaining(), count), new Object[0]);
            LimiterExceptionPolicy.throwOrLog(message, LimiterExceptionPolicy.getAction(), source.isLimited());
        }
    }

    public static enum RateLimitingAction {
        THROW_EXCEPTION,
        LOG_TO_SYSTEM;

    }
}

