/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.limiter;

import java.util.Objects;
import java.util.function.Function;
import kd.bos.dataentity.limiter.ICreator;
import kd.bos.dataentity.limiter.IRateLimiter;
import kd.bos.dataentity.limiter.KingScriptHybridLimiterPolicy;
import kd.bos.dataentity.limiter.ProgressiveIntConfig;
import org.jetbrains.annotations.NotNull;

public final class LimiterIntConfig {
    private final ProgressiveIntConfig scriptConfig;
    private final ProgressiveIntConfig jvmConfig;

    public LimiterIntConfig(@NotNull String key, @NotNull String kingScriptKey, int kingScriptDefaultValue, int defaultValue) {
        Objects.requireNonNull(key, "key must not be null");
        if (kingScriptDefaultValue >= 0) {
            Objects.requireNonNull(kingScriptKey, "kingScriptKey must not be null");
        }
        this.jvmConfig = defaultValue < 0 ? null : new ProgressiveIntConfig(key, defaultValue);
        this.scriptConfig = kingScriptDefaultValue < 0 ? null : new ProgressiveIntConfig(kingScriptKey, kingScriptDefaultValue);
    }

    public LimiterIntConfig(@NotNull String key, int kingScriptDefaultValue, int defaultValue) {
        this(key, "ks." + key, kingScriptDefaultValue, defaultValue);
    }

    public LimiterIntConfig(@NotNull String key, int kingScriptDefaultValue) {
        this(key, kingScriptDefaultValue, -1);
    }

    public ProgressiveIntConfig getJvmConfig() {
        return this.jvmConfig;
    }

    public void setJvmDefaultValue(int value) {
        if (this.jvmConfig != null) {
            this.jvmConfig.setDefaultValue(value);
        }
    }

    public ProgressiveIntConfig getScriptConfig() {
        return this.scriptConfig;
    }

    public void setKingScriptDefaultValue(int value) {
        if (this.scriptConfig != null) {
            this.scriptConfig.setDefaultValue(value);
        }
    }

    public <R extends ICreator<IRateLimiter>> ICreator<IRateLimiter> buildLimiterPolicy(@NotNull Function<ProgressiveIntConfig, R> policyCreator) {
        ProgressiveIntConfig scriptConfig = this.getScriptConfig();
        ProgressiveIntConfig jvmConfig = this.getJvmConfig();
        if (scriptConfig != null) {
            return new KingScriptHybridLimiterPolicy((ICreator)policyCreator.apply(scriptConfig), jvmConfig == null ? null : (ICreator)policyCreator.apply(jvmConfig));
        }
        if (jvmConfig != null) {
            return (ICreator)policyCreator.apply(jvmConfig);
        }
        throw new IllegalArgumentException();
    }
}

