/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.limiter;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.limiter.KDRateLimiterException;
import kd.bos.dataentity.limiter.LimiterIntConfig;
import kd.bos.dataentity.limiter.ProgressiveIntConfig;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class LimiterIntConfigRegistry {
    private static final Map<String, ProgressiveIntConfig> LimiterIntConfigMap = new ConcurrentHashMap<String, ProgressiveIntConfig>(16);
    private static final String BOS_DATAENTITY = "bos-dataentity";
    private static final List<String> ManualLimiterIntConfigClassName = new ArrayList<String>(10);

    public static int getLimiterIntConfigValue(String key) {
        if (StringUtils.isEmpty(key)) {
            throw new KDRateLimiterException(String.format(ResManager.loadKDString("\u8bf7\u8f93\u5165\u9650\u6d41\u914d\u7f6e\u952e\u3002", "LimiterIntConfigRegistry_1", BOS_DATAENTITY, new Object[0]), new Object[0]));
        }
        ProgressiveIntConfig progressiveIntConfig = LimiterIntConfigMap.get(key);
        if (progressiveIntConfig != null) {
            return progressiveIntConfig.getAsInt();
        }
        return -1;
    }

    @SdkInternal
    public static <T> void register(Class<T> clz) {
        Field[] fields;
        for (Field field : fields = clz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !LimiterIntConfig.class.isAssignableFrom(field.getType())) continue;
            try {
                field.setAccessible(true);
                LimiterIntConfig limiterIntConfig = (LimiterIntConfig)field.get(null);
                if (limiterIntConfig != null) {
                    ProgressiveIntConfig scriptConfig = limiterIntConfig.getScriptConfig();
                    ProgressiveIntConfig jvmConfig = limiterIntConfig.getJvmConfig();
                    if (scriptConfig != null) {
                        LimiterIntConfigMap.put(scriptConfig.getKey(), scriptConfig);
                    }
                    if (jvmConfig != null) {
                        LimiterIntConfigMap.put(jvmConfig.getKey(), jvmConfig);
                    }
                }
                field.setAccessible(false);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access field: " + field.getName(), e);
            }
        }
    }

    static {
        ManualLimiterIntConfigClassName.add("kd.bos.mvc.cache.PageCacheLimiterService");
        ManualLimiterIntConfigClassName.add("kd.bos.entity.cache.AppCacheLimiterService");
        for (String name : ManualLimiterIntConfigClassName) {
            try {
                Class<?> clz = Class.forName(name);
                LimiterIntConfigRegistry.register(clz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to find class: " + name, e);
            }
        }
    }
}

