/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.limiter;

import java.util.Objects;
import java.util.PropertyPermission;
import java.util.function.IntSupplier;
import kd.bos.context.RequestContext;
import kd.bos.util.ConfigurationUtil;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

public final class ProgressiveIntConfig
implements IntSupplier {
    private static final int UNDEFINED = Integer.MIN_VALUE;
    @NotNull
    private final String key;
    private int defaultValue;
    private int systemValue = Integer.MIN_VALUE;

    public ProgressiveIntConfig(@NotNull String key, int defaultValue) {
        Objects.requireNonNull(key, "key must not be null");
        this.key = key;
        this.defaultValue = defaultValue;
        ConfigurationUtil.observeChange((String)key, this::onSystemPropertyChanged);
        this.reload();
    }

    private void onSystemPropertyChanged(Object key, Object newValue) {
        String value = System.getProperty(this.key);
        this.systemValue = value != null && !value.isEmpty() ? NumberUtils.toInt((String)value, (int)Integer.MIN_VALUE) : Integer.MIN_VALUE;
    }

    public void reload() {
        this.onSystemPropertyChanged(this.key, null);
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(this.key, "write"));
        }
        this.defaultValue = value;
    }

    @Override
    public int getAsInt() {
        String tenantCode;
        RequestContext ctx = RequestContext.get();
        String value = null;
        if (ctx != null && (tenantCode = ctx.getTenantCode()) != null && !tenantCode.isEmpty()) {
            value = System.getProperty(tenantCode + '_' + this.key);
        }
        int result = Integer.MIN_VALUE;
        if (value != null && !value.isEmpty()) {
            result = NumberUtils.toInt((String)value, (int)Integer.MIN_VALUE);
        }
        if (result == Integer.MIN_VALUE) {
            result = this.systemValue;
        }
        if (result == Integer.MIN_VALUE) {
            result = this.defaultValue;
        }
        return result;
    }
}

