/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.limiter;

import java.util.Objects;
import java.util.UUID;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.limiter.ICreator;
import kd.bos.dataentity.limiter.IObjectStateService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThreadObjectStateService<T>
implements IObjectStateService<T> {
    @NotNull
    private final String key;
    @NotNull
    private final ICreator<T> creator;

    public ThreadObjectStateService(@NotNull ICreator<T> creator) {
        this(UUID.randomUUID().toString(), creator);
    }

    public ThreadObjectStateService(@NotNull String key, @NotNull ICreator<T> creator) {
        Objects.requireNonNull(key, "key must not be null");
        Objects.requireNonNull(creator, "creator must not be null");
        this.key = key;
        this.creator = creator;
    }

    @Override
    @Nullable
    public T get() {
        Object current = ThreadCache.get((Object)this.key);
        return (T)(current != null ? current : null);
    }

    @Override
    @NotNull
    public T getOrCreate() {
        T current = this.get();
        if (current == null) {
            current = this.creator.create();
            ThreadCache.put((Object)this.key, current);
        }
        return current;
    }

    @Override
    public void clear() {
        ThreadCache.remove((Object)this.key);
    }

    @Override
    public void save(@NotNull T obj) {
    }
}

