/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.metadata.database;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.IBillEntityType;
import kd.bos.dataentity.exception.ORMArgInvalidException;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IEntryType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.database.CollectionPropertyMap;
import kd.bos.dataentity.metadata.database.ComplexPropertyMap;
import kd.bos.dataentity.metadata.database.DataEntityMetadataMapBase;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataColumnCollection;
import kd.bos.dataentity.metadata.database.DbMetadataDatabase;
import kd.bos.dataentity.metadata.database.DbMetadataRelation;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.metadata.database.SimplePropertyMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DataEntityTypeMap
extends DataEntityMetadataMapBase<IDataEntityType> {
    private static final String STRING = "??????";
    private static final String BOS_DATAENTITY = "bos-dataentity";
    private static Map<Class<?>, Integer> javaSqlTypeMap = new HashMap();
    private DbMetadataTable privateDbTable;
    private SimplePropertyMap privatePrimaryKey;
    private SimplePropertyMap privateVersionProperty;
    private List<SimplePropertyMap> privateSimpleProperties;
    private List<ComplexPropertyMap> privateComplexProperties;
    private List<CollectionPropertyMap> privateCollectionProperties;
    private Object[] _properties;

    private DataEntityTypeMap() {
    }

    public static DataEntityTypeMap Build(IDataEntityType dt, RefObject<DbMetadataDatabase> database) {
        if (dt == null) {
            throw new ORMArgInvalidException(STRING, ResManager.loadKDString("\u521b\u5efa\u5b9e\u4f53\u7ed3\u6784Map\u5931\u8d25\uff0c\u53c2\u6570\u5b9e\u4f53\u7c7b\u578b[IDataEntityType]\u4e0d\u80fd\u4e3a\u7a7a\uff01", "DataEntityTypeMap_0", BOS_DATAENTITY, new Object[0]));
        }
        if (database.argvalue == null) {
            database.argvalue = new DbMetadataDatabase();
        }
        DataEntityTypeMap tempVar = new DataEntityTypeMap();
        tempVar.setDataEntityType(dt);
        tempVar.setDbTable(new DbMetadataTable());
        DataEntityTypeMap dtMap = tempVar;
        ((DbMetadataDatabase)database.argvalue).getTables().add(dtMap.getDbTable());
        dtMap.getDbTable().setName(DataEntityTypeMap.AutoTableName(null, dt.getName(), dtMap.getAlias()));
        dtMap.getDbTable().setFullIndexName(dt.getName());
        if (dt instanceof IBillEntityType) {
            dtMap.getDbTable().setBillNo(((IBillEntityType)((Object)dt)).getBillNo());
        }
        BuildContext context = new BuildContext();
        context.setColumnPrefix(null);
        context.setDatabase((DbMetadataDatabase)database.argvalue);
        DataEntityTypeMap.BuildPrivate(dtMap, context);
        DataEntityTypeMap.Validate(dtMap, context.getDatabase(), context.getErrors());
        if (context.getErrors().size() > 0) {
            throw context.getErrors().get(0);
        }
        return dtMap;
    }

    private static void BuildPrivate(DataEntityTypeMap dtMap, BuildContext context) {
        dtMap._properties = new Object[dtMap.getDataEntityType().getProperties().size()];
        DataEntityTypeMap.BuildSimpleProperties(dtMap, context);
        DataEntityTypeMap.BuildComplexProperties(dtMap, context);
        DataEntityTypeMap.BuildCollectionProperties(dtMap, context);
    }

    private static void BuildCollectionProperties(DataEntityTypeMap dtMap, BuildContext context) {
        DbMetadataColumn parentColumn = null;
        DataEntityPropertyCollection dtProperties = dtMap.getDataEntityType().getProperties();
        ArrayList<CollectionPropertyMap> colList = new ArrayList<CollectionPropertyMap>(dtProperties.size());
        for (ICollectionProperty col : dtProperties.getCollectionProperties(true)) {
            IDataEntityProperty seqProp;
            CollectionPropertyMap colMap = new CollectionPropertyMap();
            colMap.setDataEntityProperty(col);
            DataEntityTypeMap newDtMap = new DataEntityTypeMap();
            newDtMap.setDataEntityType(col.getItemType());
            DbMetadataTable tempVar3 = new DbMetadataTable();
            tempVar3.setName(DataEntityTypeMap.AutoTableName(null, newDtMap.getName(), newDtMap.getAlias()));
            newDtMap.setDbTable(tempVar3);
            if (context.getDatabase() != null) {
                context.getDatabase().getTables().add(newDtMap.getDbTable());
            }
            if (col.getName().equals("multilanguagetext")) {
                tempVar3.setLocale(true);
            }
            BuildContext tempVar4 = new BuildContext();
            tempVar4.setColumnPrefix(null);
            tempVar4.setDatabase(context.getDatabase());
            BuildContext newContext = tempVar4;
            colMap.setCollectionItemPropertyTypeMap(newDtMap);
            DataEntityTypeMap.BuildPrivate(newDtMap, newContext);
            if (newDtMap.getDbTable().getPrimaryKey() == null) {
                throw new ORMDesignException("DataEntityTypeMap\u3002141", String.format(ResManager.loadKDString("\u660e\u7ec6%s\u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e", "DataEntityTypeMap_1", BOS_DATAENTITY, new Object[0]), newDtMap.getDataEntityType().getName()));
            }
            DbMetadataColumn primaryKeyColumn = dtMap.getDbTable().getPrimaryKey();
            if (primaryKeyColumn == null) {
                throw new ORMDesignException(STRING, String.format(ResManager.loadKDString("\u660e\u7ec6%1$s\u5173\u8054\u7684\u4e3b\u8868%2$s\u6ca1\u6709\u4e3b\u952e", "DataEntityTypeMap_2", BOS_DATAENTITY, new Object[0]), newDtMap.getDataEntityType().getName(), dtMap.getDbTable().getName()));
            }
            if (newDtMap.getDataEntityType() instanceof IEntryType && (seqProp = ((IEntryType)((Object)newDtMap.getDataEntityType())).getSeqProperty()) != null) {
                newDtMap.getDbTable().setSeq((DbMetadataColumn)newDtMap.getDbTable().getColumns().get(seqProp.getAlias()));
            }
            String columnName = primaryKeyColumn.getName();
            if (col.getFkFieldName() != null) {
                columnName = col.getFkFieldName();
            }
            if ((parentColumn = (DbMetadataColumn)newDtMap.getDbTable().getColumns().get(columnName)) == null) {
                parentColumn = primaryKeyColumn.clone(columnName, col.isEnableNull());
                newDtMap.getDbTable().getColumns().add(parentColumn);
                newDtMap.getDbTable().getSortColumns().add(parentColumn.getName());
                for (ISimpleProperty prop : col.getItemType().getSortProperties()) {
                    newDtMap.getDbTable().getSortColumns().add(prop.getAlias());
                }
            }
            DbMetadataRelation parentRelation = new DbMetadataRelation();
            parentRelation.setChildColumn(parentColumn);
            parentRelation.setParentTable(dtMap.getDbTable());
            newDtMap.getDbTable().getRelations().add(parentRelation);
            newDtMap.getDbTable().setParentRelation(parentRelation);
            colMap.setParentColumn(parentColumn);
            dtMap.getDbTable().getChildTables().add(newDtMap.getDbTable());
            colList.add(colMap);
            dtMap._properties[col.getOrdinal()] = colMap;
        }
        dtMap.setCollectionProperties(colList);
    }

    private static void BuildComplexProperties(DataEntityTypeMap dtMap, BuildContext context) {
        DataEntityPropertyCollection dtProperties = dtMap.getDataEntityType().getProperties();
        ArrayList<ComplexPropertyMap> cpxList = new ArrayList<ComplexPropertyMap>(dtProperties.size());
        for (IComplexProperty cpx : dtProperties.getComplexProperties(true)) {
            if (cpx.getComplexType() == null) continue;
            ComplexPropertyMap cpxMap = new ComplexPropertyMap();
            cpxMap.setDataEntityProperty(cpx);
            cpxMap.setRefIdProperty((IDataEntityProperty)dtProperties.get(cpx.getRefIdPropName()));
            DataEntityTypeMap newDtMap = new DataEntityTypeMap();
            newDtMap.setDataEntityType(cpx.getComplexType());
            DbMetadataTable cpxTable = new DbMetadataTable();
            cpxTable.setName(DataEntityTypeMap.AutoTableName(null, newDtMap.getName(), newDtMap.getAlias()));
            newDtMap.setDbTable(cpxTable);
            cpxMap.setComplexPropertyTypeMap(newDtMap);
            BuildContext newContext = new BuildContext();
            newContext.setColumnPrefix(DataEntityTypeMap.AutoColumnName(context.getColumnPrefix(), cpx.getName(), cpxMap.getAlias()));
            dtMap.getDbTable().getChildTables().add(newDtMap.getDbTable());
            DataEntityTypeMap.BuildPrivate(newDtMap, newContext);
            cpxList.add(cpxMap);
            dtMap._properties[cpx.getOrdinal()] = cpxMap;
        }
        dtMap.setComplexProperties(cpxList);
    }

    private static int GetColumnDbType(BuildContext context, ISimpleProperty sp, SimplePropertyMap spMap) {
        int dbType = spMap.getDbType();
        if (dbType == 1111) {
            Class<?> type = sp.getPropertyType();
            if (spMap.isEncrypt()) {
                return 12;
            }
            Integer dbTypeRef = javaSqlTypeMap.get(type);
            if (dbTypeRef == null) {
                if (type == Character.class) {
                    return 1;
                }
                if (type == byte[].class) {
                    return 2011;
                }
                context.getErrors().add(new ORMDesignException(STRING, String.format(ResManager.loadKDString("\u5c5e\u6027%1$s\u7684\u5c5e\u6027\u8fd4\u56de\u7c7b\u578b%2$s\u4e0d\u662f\u5185\u7f6e\u7c7b\u578b\uff0c\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff0c\u8bf7\u624b\u52a8\u6307\u5b9aSimplePropertyAttribute\u7684DbType\u5c5e\u6027", "DataEntityTypeMap_3", BOS_DATAENTITY, new Object[0]), sp.getName(), type.getName())));
            } else {
                dbType = dbTypeRef;
            }
        }
        return dbType;
    }

    private static void BuildSimpleProperties(DataEntityTypeMap dtMap, BuildContext context) {
        DbMetadataColumnCollection columns = dtMap.getDbTable().getColumns();
        DataEntityPropertyCollection dtProperties = dtMap.getDataEntityType().getProperties();
        ArrayList<SimplePropertyMap> spList = new ArrayList<SimplePropertyMap>(dtProperties.size());
        ISimpleProperty primaryKey = dtMap.getDataEntityType().getPrimaryKey();
        for (ISimpleProperty sp : dtProperties.getSimpleProperties(true)) {
            SimplePropertyMap tempVar = new SimplePropertyMap();
            tempVar.setDataEntityProperty(sp);
            SimplePropertyMap spMap = tempVar;
            DbMetadataColumn tempVar2 = sp.createDBColumn();
            tempVar2.setName(DataEntityTypeMap.AutoColumnName(context.getColumnPrefix(), sp.getName(), spMap.getAlias()));
            tempVar2.setClrType(sp.getPropertyType(), sp.isEnableNull());
            tempVar2.setDbType(DataEntityTypeMap.GetColumnDbType(context, sp, spMap));
            tempVar2.setTableGroup(spMap.isPrimaryKey() ? null : spMap.getTableGroup());
            tempVar2.setAutoSync(spMap.getAutoSync());
            tempVar2.setEncrypt(spMap.isEncrypt());
            tempVar2.setEnableNull(spMap.isEnableNull());
            DbMetadataColumn column = tempVar2;
            spMap.setDbColumn(column);
            columns.add(column);
            if (primaryKey != null && primaryKey.getName().equals(sp.getName())) {
                if (dtMap.getPrimaryKey() == null) {
                    dtMap.setPrimaryKey(spMap);
                    dtMap.getDbTable().setPrimaryKey(spMap.getDbColumn());
                } else {
                    throw new ORMDesignException("DataEntityTypeMap\u3002322", String.format(ResManager.loadKDString("\u590d\u6742\u5c5e\u6027%1$s\u6307\u5411\u7684\u7c7b\u578b%2$s\u4e0a\u4e0d\u5141\u8bb8\u6807\u6ce8\u4e3b\u952e\u3002", "DataEntityTypeMap_4", BOS_DATAENTITY, new Object[0]), sp.getName(), sp.getPropertyType().getName()));
                }
            }
            if (dtMap.getDbTable().isLocale() && "localeid".equals(sp.getName())) {
                dtMap.getDbTable().setLocaleColumn(spMap.getDbColumn());
            }
            if (spMap.isVersionProperty()) {
                if (dtMap.getDbTable().getVersionColumn() != null) {
                    context.getErrors().add(new ORMDesignException(STRING, String.format(ResManager.loadKDString("\u5b9e\u4f53%1$s\u4e0a\u5b9a\u4e49\u4e86\u591a\u4e2a\u7248\u672c\u5217\u3002%2$s,%3$s", "DataEntityTypeMap_5", BOS_DATAENTITY, new Object[0]), dtMap.getName(), dtMap.getDbTable().getVersionColumn().getName(), column.getName())));
                }
                dtMap.setVersionProperty(spMap);
                dtMap.getDbTable().setVersionColumn(column);
            }
            spList.add(spMap);
            dtMap._properties[sp.getOrdinal()] = spMap;
        }
        dtMap.setSimpleProperties(spList);
    }

    private static void Validate(DataEntityTypeMap dtMap, DbMetadataDatabase database, List<RuntimeException> errors) {
        HashMap<String, DbMetadataTable> tables = new HashMap<String, DbMetadataTable>(database.getTables().size());
        if (database.getTables().size() == 0) {
            errors.add(new ORMDesignException(STRING, String.format(ResManager.loadKDString("\u5b9e\u4f53%s\u6ca1\u6709\u4ea7\u751f\u4efb\u4f55\u4e0e\u6570\u636e\u5e93\u6620\u5c04\u7684\u8868\u3002", "DataEntityTypeMap_6", BOS_DATAENTITY, new Object[0]), dtMap.getName())));
        }
        for (DbMetadataTable table : database.getTables()) {
            if (StringUtils.isEmpty(table.getName())) {
                errors.add(new ORMDesignException(STRING, String.format(ResManager.loadKDString("\u53d1\u73b0\u540d\u79f0\u4e3a\u7a7a\u7684\u8868\uff0c\u7d22\u5f15\u4f4d\u7f6e%s", "DataEntityTypeMap_7", BOS_DATAENTITY, new Object[0]), database.getTables().indexOf(table))));
            } else {
                if (!table.getName().startsWith("#") && !DataEntityTypeMap.IsValidIdentifier(table.getName())) {
                    errors.add(new ORMDesignException(STRING, String.format(ResManager.loadKDString("\u53d1\u73b0\u8868\u540d\u79f0%s\u4e0d\u7b26\u5408\u89c4\u8303\u3002", "DataEntityTypeMap_8", BOS_DATAENTITY, new Object[0]), table.getName())));
                }
                DbMetadataTable find = null;
                find = (DbMetadataTable)tables.get(table.getName());
                if (find != null) {
                    errors.add(new ORMDesignException(STRING, String.format(ResManager.loadKDString("\u53d1\u73b0\u91cd\u590d\u7684\u8868\u540d\u79f0%1$s,\u7d22\u5f15\u4f4d\u7f6e:%2$s\uff0c%3$s", "DataEntityTypeMap_9", BOS_DATAENTITY, new Object[0]), table.getName(), database.getTables().indexOf(find), database.getTables().indexOf(table))));
                } else {
                    tables.put(table.getName(), table);
                }
            }
            HashMap<String, DbMetadataColumn> columns = new HashMap<String, DbMetadataColumn>(table.getColumns().size());
            if (table.getColumns().size() == 0) {
                errors.add(new ORMDesignException(STRING, String.format(ResManager.loadKDString("\u8868%s\u6ca1\u6709\u4efb\u4f55\u5728\u6570\u636e\u5e93\u4e2d\u6620\u5c04\u7684\u5b57\u6bb5\u3002", "DataEntityTypeMap_10", BOS_DATAENTITY, new Object[0]), table.getName())));
            }
            for (DbMetadataColumn column : table.getColumns()) {
                if (StringUtils.isEmpty(column.getName())) {
                    errors.add(new ORMDesignException(STRING, String.format(ResManager.loadKDString("\u5728\u8868%1$s\u4e2d\u53d1\u73b0\u540d\u79f0\u4e3a\u7a7a\u7684\u5217\uff0c\u7d22\u5f15\u4f4d\u7f6e\uff1a%2$s\u3002", "DataEntityTypeMap_11", BOS_DATAENTITY, new Object[0]), table.getName(), table.getColumns().indexOf(column))));
                    continue;
                }
                if (!DataEntityTypeMap.IsValidIdentifier(column.getName())) {
                    errors.add(new ORMDesignException(STRING, String.format(ResManager.loadKDString("\u5728\u8868%1$s\u4e2d\u53d1\u73b0\u5b57\u6bb5\u540d%2$s\u4e0d\u7b26\u5408\u89c4\u8303\u3002", "DataEntityTypeMap_12", BOS_DATAENTITY, new Object[0]), table.getName(), column.getName())));
                }
                DbMetadataColumn findColumn = (DbMetadataColumn)columns.get(column.getName());
                boolean aaa = columns.containsKey(column.getName());
                if (findColumn != null) continue;
                columns.put(column.getName(), column);
            }
        }
    }

    private static boolean IsValidIdentifier(String name) {
        return true;
    }

    private static DbMetadataColumn CreateComplexPropertyIsNullColumn(String columnName) {
        DbMetadataColumn tempVar = new DbMetadataColumn();
        tempVar.setName(columnName);
        tempVar.setClrType(Boolean.class);
        tempVar.setIsNullable(true);
        tempVar.setDbType(16);
        return tempVar;
    }

    private static String AutoTableName(String prefix, String name, String alias) {
        return DataEntityTypeMap.AutoName(prefix, name, alias);
    }

    private static String AutoColumnName(String prefix, String name, String alias) {
        return DataEntityTypeMap.AutoName(prefix, name, alias);
    }

    private static String AutoName(String prefix, String name, String alias) {
        if (StringUtils.isEmpty(alias)) {
            if (StringUtils.isEmpty(prefix)) {
                return name;
            }
            return prefix + "_" + name;
        }
        return alias;
    }

    public final IDataEntityType getDataEntityType() {
        return (IDataEntityType)super.getMapSource();
    }

    private void setDataEntityType(IDataEntityType value) {
        super.setMapSource(value);
    }

    public final DbMetadataTable getDbTable() {
        return this.privateDbTable;
    }

    private void setDbTable(DbMetadataTable value) {
        this.privateDbTable = value;
        this.privateDbTable.setDataEntityTypeMap(this);
    }

    public final SimplePropertyMap getPrimaryKey() {
        return this.privatePrimaryKey;
    }

    private void setPrimaryKey(SimplePropertyMap value) {
        this.privatePrimaryKey = value;
    }

    public final SimplePropertyMap getVersionProperty() {
        return this.privateVersionProperty;
    }

    private void setVersionProperty(SimplePropertyMap value) {
        this.privateVersionProperty = value;
    }

    public final List<SimplePropertyMap> getSimpleProperties() {
        return this.privateSimpleProperties;
    }

    private void setSimpleProperties(List<SimplePropertyMap> value) {
        this.privateSimpleProperties = value;
    }

    public final List<ComplexPropertyMap> getComplexProperties() {
        return this.privateComplexProperties;
    }

    private void setComplexProperties(List<ComplexPropertyMap> value) {
        this.privateComplexProperties = value;
    }

    public final List<CollectionPropertyMap> getCollectionProperties() {
        return this.privateCollectionProperties;
    }

    private void setCollectionProperties(List<CollectionPropertyMap> value) {
        this.privateCollectionProperties = value;
    }

    public final Object GetPropertyMapByOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal >= this._properties.length) {
            throw new ORMDesignException(STRING, String.format(ResManager.loadKDString("\u4ece\u5b9e\u4f53\u7c7b\u578b%1$s\u7684\u5c5e\u6027\u5217\u8868\u67e5\u627e\u5c5e\u6027\u5931\u8d25,\u5c5e\u6027\u4f4d\u7f6e\u987a\u5e8f\u4e0d\u6b63\u786e\uff0c\u7d22\u5f15\u4f4d\u7f6e\uff1a%2$s\uff0c\u8bf7\u68c0\u67e5\u4e0a\u5c42\u7a0b\u5e8f.", "DataEntityTypeMap_13", BOS_DATAENTITY, new Object[0]), this.getName(), ordinal));
        }
        return this._properties[ordinal];
    }

    static {
        javaSqlTypeMap.put(Boolean.class, 16);
        javaSqlTypeMap.put(Long.class, -5);
        javaSqlTypeMap.put(String.class, 12);
        javaSqlTypeMap.put(Integer.class, 4);
        javaSqlTypeMap.put(Float.class, 6);
        javaSqlTypeMap.put(Date.class, 91);
        javaSqlTypeMap.put(Double.class, 8);
        javaSqlTypeMap.put(Timestamp.class, 93);
        javaSqlTypeMap.put(byte[].class, -2);
    }

    private static final class BuildContext {
        private String privateColumnPrefix;
        private DbMetadataDatabase privateDatabase;
        private ArrayList<RuntimeException> _errors = new ArrayList();

        public String getColumnPrefix() {
            return this.privateColumnPrefix;
        }

        public void setColumnPrefix(String value) {
            this.privateColumnPrefix = value;
        }

        public DbMetadataDatabase getDatabase() {
            return this.privateDatabase;
        }

        public void setDatabase(DbMetadataDatabase value) {
            this.privateDatabase = value;
        }

        public ArrayList<RuntimeException> getErrors() {
            return this._errors;
        }
    }
}

