/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.metadata.database;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.AutoSync;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.database.DbMetadataBase;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.db.SqlParameter;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.beanutils.ConvertUtils;

@SdkPublic
public class DbMetadataColumn
extends DbMetadataBase {
    private Class<?> _clrType;
    private Object privateDefaultValue;
    private boolean privateEncrypt;
    private boolean privateEnableNull;
    private int privateSize;
    private byte privateScale;
    private int privateDbType;
    private boolean privateIsNullable;
    private AutoSync privateAutoSync = AutoSync.forValue(0);
    private String privateTableGroup;
    private DbMetadataTable _table;
    private int privateColumnIndex;
    private boolean isPrivacyCol = false;

    public DbMetadataColumn() {
    }

    public DbMetadataColumn(String name) {
        super(name);
    }

    public final Class<?> getClrType() {
        if (this.getEncrypt()) {
            return String.class;
        }
        return this._clrType;
    }

    public final void setClrType(Class<?> value) {
        this._clrType = value;
        this.SetDefaultValue(this._clrType);
    }

    public final void setClrType(Class<?> classType, boolean enableNull) {
        this._clrType = classType;
        if (enableNull) {
            this.setDefaultValue(null);
            return;
        }
        this.SetDefaultValue(this._clrType);
    }

    public final Object getDefaultValue() {
        return this.privateDefaultValue;
    }

    private void setDefaultValue(Object value) {
        this.privateDefaultValue = value;
    }

    private void SetDefaultValue(Class<?> clrType) {
        if (clrType.equals(String.class) || clrType.equals(ILocaleString.class)) {
            this.setDefaultValue(" ");
        } else if (clrType.equals(byte[].class)) {
            this.setDefaultValue(null);
        } else if (clrType.equals(BigDecimal.class)) {
            this.setDefaultValue(new BigDecimal(0));
        } else if (clrType.equals(Integer.class)) {
            this.setDefaultValue(0);
        } else if (clrType.equals(Long.class)) {
            this.setDefaultValue(0L);
        } else if (clrType.isPrimitive()) {
            if (clrType == Boolean.TYPE) {
                this.setDefaultValue(false);
            } else {
                this.setDefaultValue(ConvertUtils.convert((Object)0, clrType));
            }
        } else {
            this.setDefaultValue(null);
        }
    }

    public final boolean getEncrypt() {
        return this.privateEncrypt;
    }

    public final void setEncrypt(boolean value) {
        this.privateEncrypt = value;
    }

    public final boolean getEnableNull() {
        return this.privateEnableNull;
    }

    public final void setEnableNull(boolean value) {
        this.privateEnableNull = value;
    }

    public final int getSize() {
        return this.privateSize;
    }

    public final void setSize(int value) {
        this.privateSize = value;
    }

    public final byte getScale() {
        return this.privateScale;
    }

    public final void setScale(byte value) {
        this.privateScale = value;
    }

    public final int getDbType() {
        if (this.getEncrypt()) {
            return -16;
        }
        return this.privateDbType;
    }

    public final void setDbType(int value) {
        this.privateDbType = value;
    }

    public final boolean getIsNullable() {
        return this.privateIsNullable;
    }

    public final void setIsNullable(boolean value) {
        this.privateIsNullable = value;
    }

    public final AutoSync getAutoSync() {
        return this.privateAutoSync;
    }

    public final void setAutoSync(AutoSync value) {
        this.privateAutoSync = value;
    }

    public final String getTableGroup() {
        return this.privateTableGroup;
    }

    public final void setTableGroup(String value) {
        this.privateTableGroup = value;
    }

    public final DbMetadataTable getTable() {
        return this._table;
    }

    public final void setTable(DbMetadataTable value) {
        this._table = value;
    }

    public final DbMetadataColumn clone(String newName, boolean enableNull) {
        DbMetadataColumn tempVar = new DbMetadataColumn(newName);
        tempVar.setClrType(this.getClrType(), enableNull);
        tempVar.setSize(this.getSize());
        tempVar.setScale(this.getScale());
        tempVar.setDbType(this.getDbType());
        tempVar.setIsNullable(this.getIsNullable());
        tempVar.setAutoSync(this.getAutoSync());
        tempVar.setTableGroup(this.getTableGroup());
        return tempVar;
    }

    public final int getColumnIndex() {
        return this.privateColumnIndex;
    }

    public final void setColumnIndex(int value) {
        this.privateColumnIndex = value;
    }

    @Override
    public String getName() {
        if (this.getEncrypt()) {
            return super.getName() + "_enp";
        }
        return super.getName();
    }

    public String toString() {
        return this.getName();
    }

    public boolean isPrivacyCol() {
        return this.isPrivacyCol;
    }

    public void setPrivacyCol(boolean isPrivacyCol) {
        this.isPrivacyCol = isPrivacyCol;
    }

    public String getPlaceholder() {
        return "?";
    }

    public void addSqlParameter(List<SqlParameter> sqlPsList, Object[] row) {
        sqlPsList.add(new SqlParameter(this.getName(), this.getDbType(), row[this.getColumnIndex()]));
    }
}

