/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.metadata.database;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.IEntryType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.database.DataEntityTypeMap;
import kd.bos.dataentity.metadata.database.DbMetadataBase;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataColumnCollection;
import kd.bos.dataentity.metadata.database.DbMetadataRelation;
import kd.bos.dataentity.metadata.database.DbMetadataRelationCollection;
import kd.bos.dataentity.metadata.database.DbMetadataTableCollection;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DbMetadataTable
extends DbMetadataBase {
    private List<String> sortColumns;
    private Map<String, ISimpleProperty> fullIndexProperties;
    private String fullIndexName;
    private String billNo;
    private boolean locale = false;
    private DataEntityTypeMap dataEntityTypeMap;
    private DbMetadataColumnCollection privateColumns = new DbMetadataColumnCollection(this);
    private DbMetadataColumn privatePrimaryKey;
    private DbMetadataColumn privateSeq;
    private DbMetadataColumn privateVersionColumn;
    private DbMetadataRelationCollection privateRelations;
    private DbMetadataRelation privateParentRelation;
    private DbMetadataTableCollection privateChildTables;
    private List<Tuple<String, DbMetadataColumn[]>> _columnsByTableGroupCache;
    private DbMetadataColumn localeColumn;

    public DbMetadataTable() {
        this.setRelations(new DbMetadataRelationCollection());
        this.setChildTables(new DbMetadataTableCollection());
    }

    public final DbMetadataColumnCollection getColumns() {
        return this.privateColumns;
    }

    public void setColumns(DbMetadataColumnCollection value) {
        this.privateColumns = value;
    }

    public final DbMetadataColumn getPrimaryKey() {
        return this.privatePrimaryKey;
    }

    public final void setPrimaryKey(DbMetadataColumn value) {
        this.privatePrimaryKey = value;
    }

    public final DbMetadataColumn getSeq() {
        return this.privateSeq;
    }

    public final void setSeq(DbMetadataColumn value) {
        this.privateSeq = value;
    }

    public final DbMetadataColumn getVersionColumn() {
        return this.privateVersionColumn;
    }

    public final void setVersionColumn(DbMetadataColumn value) {
        this.privateVersionColumn = value;
    }

    public final DbMetadataRelationCollection getRelations() {
        return this.privateRelations;
    }

    private void setRelations(DbMetadataRelationCollection value) {
        this.privateRelations = value;
    }

    public final DbMetadataRelation getParentRelation() {
        return this.privateParentRelation;
    }

    public final void setParentRelation(DbMetadataRelation value) {
        this.privateParentRelation = value;
    }

    public final DbMetadataTableCollection getChildTables() {
        return this.privateChildTables;
    }

    private void setChildTables(DbMetadataTableCollection value) {
        this.privateChildTables = value;
    }

    public final List<Tuple<String, DbMetadataColumn[]>> getColumnsByTableGroup() {
        return this.getColumnsByTableGroup(this.getColumns(), true, true);
    }

    public final List<Tuple<String, DbMetadataColumn[]>> getColumnsByTableGroup(List<DbMetadataColumn> columns, boolean useCache, boolean includeExtTablePK) {
        ArrayList<Tuple<String, DbMetadataColumn[]>> ret = null;
        if (this._columnsByTableGroupCache == null || !useCache) {
            ArrayList<DbMetadataColumn> mainTableColumns = new ArrayList<DbMetadataColumn>(columns.size());
            HashMap<String, ArrayList<DbMetadataColumn>> dict = null;
            for (DbMetadataColumn column : columns) {
                ArrayList<DbMetadataColumn> columns1;
                if (column.getTableGroup() == null || column.getTableGroup().isEmpty()) {
                    mainTableColumns.add(column);
                    continue;
                }
                if (dict == null) {
                    dict = new HashMap<String, ArrayList<DbMetadataColumn>>(2);
                }
                if ((columns1 = (ArrayList<DbMetadataColumn>)dict.get(column.getTableGroup())) == null) {
                    columns1 = new ArrayList<DbMetadataColumn>();
                    if (includeExtTablePK) {
                        columns1.add(this.getPrimaryKey());
                    }
                    dict.put(column.getTableGroup(), columns1);
                }
                columns1.add(column);
            }
            int count = (dict == null ? 0 : dict.size()) + 1;
            ArrayList<Tuple<String, DbMetadataColumn[]>> result = new ArrayList<Tuple<String, DbMetadataColumn[]>>(count);
            result.add(new Tuple<String, DbMetadataColumn[]>("", mainTableColumns.toArray(new DbMetadataColumn[0])));
            if (dict != null) {
                for (Map.Entry item : dict.entrySet()) {
                    result.add(new Tuple(item.getKey(), ((ArrayList)item.getValue()).toArray(new DbMetadataColumn[0])));
                }
            }
            if (useCache) {
                this._columnsByTableGroupCache = result;
            } else {
                ret = result;
            }
        }
        if (useCache) {
            return this._columnsByTableGroupCache;
        }
        return ret;
    }

    public List<String> getSortColumns() {
        if (this.sortColumns == null) {
            this.sortColumns = new ArrayList<String>();
        }
        return this.sortColumns;
    }

    public Map<String, ISimpleProperty> getFullIndexProperties() {
        if (this.fullIndexProperties == null) {
            this.fullIndexProperties = new HashMap<String, ISimpleProperty>(0);
        }
        return this.fullIndexProperties;
    }

    public String getFullIndexName() {
        return this.fullIndexName;
    }

    public void setFullIndexName(String fullIndexName) {
        this.fullIndexName = fullIndexName;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public boolean isLocale() {
        return this.locale;
    }

    public void setLocale(boolean locale) {
        this.locale = locale;
    }

    public DbMetadataColumn getLocaleColumn() {
        return this.localeColumn;
    }

    public void setLocaleColumn(DbMetadataColumn localeColumn) {
        this.localeColumn = localeColumn;
    }

    public void setDataEntityTypeMap(DataEntityTypeMap dataEntityTypeMap) {
        this.dataEntityTypeMap = dataEntityTypeMap;
    }

    public DataEntityTypeMap getDataEntityTypeMap() {
        return this.dataEntityTypeMap;
    }

    public boolean isSubEntry() {
        return this.privateParentRelation != null && this.privateParentRelation.getParentTable().getParentRelation() != null && this.getDataEntityTypeMap().getDataEntityType() instanceof IEntryType;
    }

    public String toString() {
        return this.getName();
    }
}

