/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.privacy;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.privacy.IPrivacyDataService;
import kd.bos.dataentity.privacy.IPrivacyProperty;
import kd.bos.dataentity.privacy.PrivacyData;
import kd.bos.dataentity.privacy.PrivacyMappingData;
import kd.bos.dataentity.utils.StringUtils;

public class AbstractPrivacyDataService
implements IPrivacyDataService {
    @Override
    public void loadPrivacyData(IDataEntityProperty originalProperty, IPrivacyProperty dp, Object[] dataEntities) {
        int i;
        ArrayList<PrivacyMappingData> mappingDatas = new ArrayList<PrivacyMappingData>();
        ArrayList<PrivacyData> privacyDatas = new ArrayList<PrivacyData>();
        for (i = 0; i < dataEntities.length; ++i) {
            Object dataEntity = dataEntities[i];
            if (dataEntity == null) continue;
            PrivacyMappingData mappingData = new PrivacyMappingData();
            String privacyStr = (String)dp.getValueFast(dataEntity);
            if (!StringUtils.isNotBlank(privacyStr)) continue;
            mappingData.setPrivacyProp(dp);
            mappingData.setRowDataEntity(dataEntity);
            mappingDatas.add(mappingData);
            PrivacyData pd = this.createDecryptPrivacyData(originalProperty, privacyStr);
            privacyDatas.add(pd);
        }
        this.loadPrivacyData(privacyDatas);
        for (i = 0; i < mappingDatas.size(); ++i) {
            PrivacyMappingData privacyMappingData = (PrivacyMappingData)mappingDatas.get(i);
            Object dataEntity = privacyMappingData.getRowDataEntity();
            PrivacyData privacyData = (PrivacyData)privacyDatas.get(i);
            originalProperty.setValue(dataEntity, privacyData.getValue());
        }
    }

    @Override
    public void savePrivacyData(IDataEntityProperty originalProperty, IPrivacyProperty dp, Object[] dataEntities) {
        int i;
        ArrayList<PrivacyMappingData> mappingDatas = new ArrayList<PrivacyMappingData>();
        ArrayList<PrivacyData> privacyDatas = new ArrayList<PrivacyData>();
        for (i = 0; i < dataEntities.length; ++i) {
            Object dataEntity = dataEntities[i];
            if (dataEntity == null) continue;
            PrivacyMappingData mappingData = new PrivacyMappingData();
            Object val = originalProperty.getValueFast(dataEntity);
            mappingData.setOriginalValue(val);
            mappingData.setPrivacyProp(dp);
            mappingData.setRowDataEntity(dataEntity);
            mappingDatas.add(mappingData);
            PrivacyData pd = this.createEncryptPrivacyData(originalProperty, val);
            privacyDatas.add(pd);
        }
        this.savePrivacyData(privacyDatas);
        for (i = 0; i < mappingDatas.size(); ++i) {
            PrivacyMappingData privacyMappingData = (PrivacyMappingData)mappingDatas.get(i);
            Object dataEntity = privacyMappingData.getRowDataEntity();
            PrivacyData privacyData = (PrivacyData)privacyDatas.get(i);
            privacyMappingData.getPrivacyProp().setValue(dataEntity, privacyData.toString());
        }
    }

    protected PrivacyData createDecryptPrivacyData(IDataEntityProperty originProp, String privacyDataStr) {
        PrivacyData privacyData = new PrivacyData();
        privacyData.toPrivacyData(privacyDataStr);
        return privacyData;
    }

    protected PrivacyData createEncryptPrivacyData(IDataEntityProperty originProp, Object val) {
        PrivacyData privacyData = new PrivacyData();
        privacyData.setValue(val.toString());
        return privacyData;
    }

    @Override
    public void loadPrivacyData(List<PrivacyData> privacyDatas) {
    }

    @Override
    public void savePrivacyData(List<PrivacyData> privacyDatas) {
    }
}

