/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.resource.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bundle.Resources;
import kd.bos.dataentity.resource.cache.PromptUtils;
import org.apache.commons.lang.StringEscapeUtils;

public class PromptResourceUtils {
    private static final ResourceBundle NONEXISTENT_BUNDLE = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }

        public String toString() {
            return "NONEXISTENT_BUNDLE";
        }
    };
    public static final String NOEXIST = "NO_EXIST_WORDS";
    private static final Map<String, ResourceBundle> bundleMapPrompt = new ConcurrentHashMap<String, ResourceBundle>();
    private static final Map<String, ResourceBundle> bundleMapProject = new ConcurrentHashMap<String, ResourceBundle>();
    private static final boolean PROPERTIES_FLAG = false;
    private static final Set<String> designerFile = new HashSet<String>();

    private static ResourceBundle getResourceBundle(String bundleName, Locale locale, Map bundleMap) {
        Path bundleNamePath = Paths.get(bundleName, new String[0]);
        ResourceBundle bundle = (ResourceBundle)bundleMap.get(bundleName = bundleNamePath.normalize().toString());
        if (bundle == null) {
            String finalBundleName = bundleName;
            bundle = (ResourceBundle)bundleMap.computeIfAbsent(bundleName, k -> {
                try {
                    URL url = PromptResourceUtils.class.getClassLoader().getResource("resources/" + finalBundleName + ".properties");
                    if (url == null) {
                        return NONEXISTENT_BUNDLE;
                    }
                    return ResourceBundle.getBundle("resources/" + finalBundleName, locale, new ResourceBundle.Control(){

                        @Override
                        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
                            String bundleName = this.toBundleName(baseName, locale);
                            String resourceName = this.toResourceName(bundleName, "properties");
                            try (InputStream stream = Objects.requireNonNull(loader.getResourceAsStream(resourceName));){
                                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
                                return propertyResourceBundle;
                            }
                        }
                    });
                }
                catch (Exception var4) {
                    return NONEXISTENT_BUNDLE;
                }
            });
        }
        return bundle;
    }

    public static String get(Locale locale, String project, String key, String desc, Object ... args) {
        String resource = "prompt-" + project + '_' + locale.toString();
        ResourceBundle bundle = PromptResourceUtils.getResourceBundle(resource, locale, bundleMapPrompt);
        if (bundle == NONEXISTENT_BUNDLE) {
            if (designerFile.contains(project)) {
                return PromptResourceUtils.getOrigionProperties(locale, project, key, desc, args);
            }
            if (locale.toString().equalsIgnoreCase("zh_CN")) {
                return PromptUtils.format(desc, args);
            }
            return PromptResourceUtils.getOrigionProperties(locale, project, key, desc, args);
        }
        String s = null;
        try {
            if (!bundle.containsKey(key)) {
                if (designerFile.contains(project)) {
                    return PromptResourceUtils.getOrigionProperties(locale, project, key, desc, args);
                }
                if (locale.toString().equalsIgnoreCase("zh_CN")) {
                    return PromptUtils.format(desc, args);
                }
                return PromptResourceUtils.getOrigionProperties(locale, project, key, desc, args);
            }
            s = StringEscapeUtils.unescapeJava((String)bundle.getString(key));
            return PromptUtils.format(s, args);
        }
        catch (MissingResourceException e1) {
            return desc == null ? Resources.missBundleKey((String)key) : PromptUtils.format(Resources.missBundleKey((String)desc), args);
        }
    }

    private static String getOrigionProperties(Locale locale, String project, String key, String desc, Object ... args) {
        String resourceOrigin = project + '_' + locale.toString();
        ResourceBundle bundle = PromptResourceUtils.getResourceBundle(resourceOrigin, locale, bundleMapProject);
        if (bundle == NONEXISTENT_BUNDLE) {
            return NOEXIST;
        }
        String s = null;
        try {
            if (!bundle.containsKey(key)) {
                return NOEXIST;
            }
            s = StringEscapeUtils.unescapeJava((String)bundle.getString(key));
            return PromptUtils.format(s, args);
        }
        catch (MissingResourceException e1) {
            return desc == null ? Resources.missBundleKey((String)key) : PromptUtils.format(Resources.missBundleKey((String)desc), args);
        }
    }

    static {
        designerFile.add("BalanceModel");
        designerFile.add("EarlyWarnModel");
        designerFile.add("BalanceUpdateModel");
        designerFile.add("BillFormModel");
        designerFile.add("WarnScheduleModel");
        designerFile.add("ReportQueryListModel");
        designerFile.add("DynamicFormModel");
        designerFile.add("LogBillFormModel");
        designerFile.add("AppModel");
        designerFile.add("MobUserGuideFormModel");
        designerFile.add("PermissomModel");
        designerFile.add("MobileFormModel");
        designerFile.add("UserGuideFormModel");
        designerFile.add("MobileListModel");
        designerFile.add("WriteBackRuleModel");
        designerFile.add("ParamterModel");
        designerFile.add("BillListCardViewModel");
        designerFile.add("CardModel");
        designerFile.add("CarEntryMenuModel");
        designerFile.add("ConvertRuleModel");
        designerFile.add("QueryListModel");
        designerFile.add("PrintModel");
        designerFile.add("MobileBillFormModel");
        designerFile.add("WidgetFormModel");
        designerFile.add("ReportFormModel");
        designerFile.add("ValidationType");
        designerFile.add("OpBizRuleType");
        designerFile.add("AbstractWorkflowModel");
        designerFile.add("BizFlowModel");
        designerFile.add("WorkflowModel");
    }
}

