/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.resource.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.cache.PromptWordCacheMrg;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class PromptWordCache {
    public static String getPromptWord(String key) {
        String promptWordStr = PromptWordCache.loadPromptWordCache(key);
        return promptWordStr;
    }

    private static String loadPromptWordCache(String key) {
        String promptWordStr = null;
        String type = PromptWordCacheMrg.getType4PromptWordRes();
        promptWordStr = PromptWordCacheMrg.getCache(type, key);
        if (!PromptWordCacheMrg.isLoaded(promptWordStr)) {
            promptWordStr = PromptWordCache.reloadPromptWord(key);
        }
        return promptWordStr;
    }

    private static String reloadPromptWord(String key) {
        String promptWordStr = null;
        String sql = "select FPKID id,FResID resid,FLocaleID localeid,FTranslation translation from T_INT_PromptWordTran_L ";
        SqlParameter[] params = new SqlParameter[]{};
        final String type = PromptWordCacheMrg.getType4PromptWordRes();
        if (!PromptWordCacheMrg.isLoaded()) {
            DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) {
                    try {
                        while (rs.next()) {
                            PromptWordCacheMrg.putCache(type, rs.getString("resid") + "" + rs.getString("localeid"), rs.getString("translation"));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage()), e});
                    }
                    return null;
                }
            });
            PromptWordCacheMrg.setIsLoaded(true);
        }
        if (StringUtils.isBlank(promptWordStr = PromptWordCacheMrg.getCache(type, key))) {
            PromptWordCacheMrg.putCache(type, key, "DATA_LOADED");
        }
        return promptWordStr;
    }
}

