/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntityDeserializerOption;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import org.apache.commons.beanutils.ConvertUtils;

class DataEntitySerializerReader {
    private static final String TYPE_NAME = "DataEntitySerializer";
    private static final String METHOD_READOBJECT = "readObject";
    private static final String METHOD_READCOLLECTION = "readCollection";
    private Map<String, Map<Object, Object>> refComplexPropertys = new HashMap<String, Map<Object, Object>>();
    private Map<String, Map<Object, List<Object>>> refComplexPropertyData = new HashMap<String, Map<Object, List<Object>>>();
    private ObjectMapper mp = new ObjectMapper();
    private SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat noTimeDF = new SimpleDateFormat("yyyy-MM-dd");
    protected boolean includeComplexProperty = false;
    protected boolean includeDataEntityState = false;
    protected DataEntityDeserializerOption option;

    public DataEntitySerializerReader() {
        this(null);
    }

    public DataEntitySerializerReader(DataEntityDeserializerOption option) {
        this.option = option == null ? new DataEntityDeserializerOption() : option;
    }

    public Object readObject(IDataEntityType dt, Map<String, Object> mapObj) {
        try (EntityTraceSpan span = null;){
            Object state;
            span = EntityTracer.create(TYPE_NAME, METHOD_READOBJECT, EntityTraceHint.getHintDisLinkAPM());
            if (span.isRealtime()) {
                span.addTag("type", dt.getName());
                span.addLocaleTag("dt", dt);
                span.addLocaleTag("mapObj", mapObj);
                span.fireEvent(null);
            }
            this.mp.setDateFormat((DateFormat)this.DF);
            List values = (List)mapObj.get("data");
            Object refDataObj = mapObj.get("ref");
            if (refDataObj != null) {
                this.includeComplexProperty = true;
                this.refComplexPropertyData = (Map)refDataObj;
                this.refComplexPropertys = new HashMap<String, Map<Object, Object>>();
            }
            if ((state = mapObj.get("state")) != null && Boolean.parseBoolean(String.valueOf(state))) {
                this.includeDataEntityState = true;
            }
            Object object = this.readObject(dt, values, this.getPropertyMaps(dt));
            return object;
        }
    }

    public Object readObject(IDataEntityType dt, List<Object> values) {
        try (EntityTraceSpan span = null;){
            span = EntityTracer.create(TYPE_NAME, METHOD_READOBJECT, EntityTraceHint.getHintDisLinkAPM());
            if (span.isRealtime()) {
                span.addTag("type", dt.getName());
                span.addLocaleTag("dt", dt);
                span.addLocaleTag("values", values);
                span.fireEvent(null);
            }
            Object object = this.readObject(dt, values, this.getPropertyMaps(dt));
            return object;
        }
    }

    private Object readObject(IDataEntityType currentDataEntityType, List<Object> values, List<PropertyMap> propMaps) {
        Map state;
        boolean hasState = this.isHasState(currentDataEntityType, values);
        Object obj = currentDataEntityType.createInstance();
        if (ISupportInitialize.class.isInstance(obj)) {
            ((ISupportInitialize)obj).beginInit();
        }
        for (PropertyMap p : propMaps) {
            p.mapValue(obj, values);
        }
        if (hasState && obj instanceof DataEntityBase && (state = (Map)values.get(values.size() - 1)) != null) {
            DataEntityBase dataEntityBase = (DataEntityBase)obj;
            this.setState(dataEntityBase.getDataEntityState(), state);
        }
        if (ISupportInitialize.class.isInstance(obj)) {
            ((ISupportInitialize)obj).endInit();
        }
        return obj;
    }

    protected boolean isHasState(IDataEntityType currentDataEntityType, List<Object> values) {
        boolean hasState;
        boolean bl = hasState = this.includeDataEntityState || this.option.isIncludeDataEntityState();
        if (!hasState) {
            hasState = values.size() == currentDataEntityType.getProperties().size() + 1;
        }
        return hasState;
    }

    public List<DynamicObject> readCollection(List<DynamicObject> tCollecion, List<List<Object>> objs, IDataEntityType dt) {
        try (EntityTraceSpan span = null;){
            span = EntityTracer.create(TYPE_NAME, METHOD_READCOLLECTION, EntityTraceHint.getHintDisLinkAPM());
            if (span.isRealtime()) {
                span.addTag("type", dt.getName());
                span.addLocaleTag("dt", dt);
                span.addLocaleTag("objs", objs);
                span.fireEvent(null);
            }
            List<PropertyMap> propertyMaps = this.getPropertyMaps(dt);
            for (List<Object> vs : objs) {
                tCollecion.add((DynamicObject)this.readObject(dt, vs, propertyMaps));
            }
            List<DynamicObject> list = tCollecion;
            return list;
        }
    }

    private void setState(DataEntityState state, Map<String, Object> doc) {
        Map cacheState;
        Map mapEntryInfos;
        List dirtyList;
        List bizChangedList;
        Map pksnapshots;
        Object instanceId;
        if (doc == null) {
            return;
        }
        boolean bValue = Boolean.parseBoolean(String.valueOf(doc.get("isfromdb")));
        state.setFromDatabase(bValue);
        Object value = doc.get("rmitems");
        if (value != null) {
            state.setRemovedItems(Boolean.parseBoolean(value.toString()));
        }
        if ((instanceId = doc.get("instanceid")) != null) {
            state.setInstanceId(Long.parseLong(String.valueOf(instanceId)));
        }
        if ((pksnapshots = (Map)doc.get("pksnapshots")) != null) {
            state.setPkSnapshotSet(this.fromPkSnapshotSet(pksnapshots));
        }
        if ((bizChangedList = (List)doc.get("bizchanged")) != null) {
            long[] bizChangeds = new long[bizChangedList.size()];
            for (int i = 0; i < bizChangedList.size(); ++i) {
                Object v = bizChangedList.get(i);
                bizChangeds[i] = v instanceof Integer ? (long)((Integer)v).intValue() : (v instanceof Long ? (Long)v : (v instanceof Number ? ((Number)v).longValue() : ((Long)v).longValue()));
            }
            state.setBizChangeFlags(bizChangeds);
        }
        if ((dirtyList = (List)doc.get("dirtyprops")) != null) {
            long[] dirtyprops = new long[dirtyList.size()];
            for (int i = 0; i < dirtyList.size(); ++i) {
                Object v = dirtyList.get(i);
                dirtyprops[i] = v instanceof Integer ? (long)((Integer)v).intValue() : (v instanceof Long ? (Long)v : (v instanceof Number ? ((Number)v).longValue() : ((Long)v).longValue()));
            }
            state.setDirtyFlags(dirtyprops);
        }
        if ((mapEntryInfos = (Map)doc.get("entryinfos")) != null) {
            HashMap<String, EntryInfo> entryInfos = new HashMap<String, EntryInfo>(mapEntryInfos.size());
            for (Map.Entry mapEntry : mapEntryInfos.entrySet()) {
                entryInfos.put((String)mapEntry.getKey(), this.fromEntryInfo((Map)mapEntry.getValue()));
            }
            state.setEntryInfos(entryInfos);
        }
        if ((cacheState = (Map)doc.get("cachestate")) != null) {
            state.setCacheState(cacheState);
        }
    }

    private PkSnapshotSet fromPkSnapshotSet(Map<String, Object> doc) {
        if (doc == null || doc.isEmpty()) {
            return null;
        }
        PkSnapshotSet set = new PkSnapshotSet();
        set.Snapshots = new ArrayList<PkSnapshot>(doc.size());
        for (Map.Entry<String, Object> table : doc.entrySet()) {
            PkSnapshot snap = new PkSnapshot();
            snap.TableName = table.getKey();
            List pkarray = (List)table.getValue();
            List oids = (List)pkarray.get(0);
            if (oids != null) {
                snap.Oids = new Object[oids.size()];
                for (int i = 0; i < snap.Oids.length; ++i) {
                    Object v = oids.get(i);
                    snap.Oids[i] = v instanceof Integer ? Long.valueOf(((Integer)v).intValue()) : v;
                }
            }
            if (pkarray.size() > 1) {
                List opids = (List)pkarray.get(1);
                snap.Opids = new Object[opids.size()];
                for (int i = 0; i < snap.Opids.length; ++i) {
                    Object v = opids.get(i);
                    snap.Opids[i] = v instanceof Integer ? Long.valueOf(((Integer)v).intValue()) : v;
                }
            }
            set.Snapshots.add(snap);
        }
        return set;
    }

    private EntryInfo fromEntryInfo(Map<String, Object> doc) {
        Integer pageSize;
        Integer startRowIndex;
        EntryInfo info = new EntryInfo();
        Integer rowCount = (Integer)doc.get("rowCount");
        if (rowCount != null) {
            info.setRowCount(rowCount);
        }
        if ((startRowIndex = (Integer)doc.get("startRowIndex")) != null) {
            info.setStartRowIndex(startRowIndex);
        }
        if ((pageSize = (Integer)doc.get("pageSize")) != null) {
            info.setPageSize(pageSize);
        }
        return info;
    }

    protected List<PropertyMap> getPropertyMaps(IDataEntityType dt) {
        ArrayList<PropertyMap> propMaps = new ArrayList<PropertyMap>();
        for (IDataEntityProperty p : dt.getProperties()) {
            PropertyMap prop;
            if (p instanceof ILocaleProperty) {
                prop = new GLangLocalePropertyMap(p.getOrdinal(), (ILocaleProperty)((Object)p));
                propMaps.add(prop);
                continue;
            }
            if (p instanceof ISimpleProperty) {
                prop = new SimplePropertyMap(p.getOrdinal(), p);
                propMaps.add(prop);
                continue;
            }
            if (p instanceof IComplexProperty && this.includeComplexProperty) {
                IComplexProperty cmp = (IComplexProperty)p;
                int index = p.getOrdinal();
                if (!StringUtils.isBlank(cmp.getRefIdPropName())) {
                    RefObject<Object> ref_property = new RefObject<Object>(null);
                    if (dt.getProperties().tryGetValue(cmp.getRefIdPropName(), ref_property)) {
                        index = ((IDataEntityProperty)ref_property.argvalue).getOrdinal();
                    }
                }
                ComplexPropertyMap prop2 = new ComplexPropertyMap(index, cmp);
                propMaps.add(prop2);
                continue;
            }
            if (!(p instanceof ICollectionProperty)) continue;
            prop = new CollectionPropertyMap(p.getOrdinal(), (ICollectionProperty)p);
            propMaps.add(prop);
        }
        return propMaps;
    }

    private String getExtendName(IDataEntityType dt) {
        if (dt instanceof DynamicObjectType) {
            return ((DynamicObjectType)dt).getExtendName();
        }
        return dt.getName();
    }

    protected class ComplexPropertyMap
    implements PropertyMap {
        private int index;
        private IComplexProperty prop;

        public ComplexPropertyMap(int ordinal, IComplexProperty p) {
            this.index = ordinal;
            this.prop = p;
        }

        @Override
        public void mapValue(Object obj, List<Object> values) {
            Object id = values.get(this.index);
            if (id != null) {
                Object cmpObj = null;
                String extendName = DataEntitySerializerReader.this.getExtendName(this.prop.getComplexType());
                HashMap<Object, Object> refObjs = (HashMap<Object, Object>)DataEntitySerializerReader.this.refComplexPropertys.get(extendName);
                if (refObjs == null) {
                    refObjs = new HashMap<Object, Object>();
                    cmpObj = this.readComplexObject(id, extendName);
                    refObjs.put(id, cmpObj);
                    DataEntitySerializerReader.this.refComplexPropertys.put(extendName, refObjs);
                } else {
                    Object o = refObjs.get(id);
                    if (o == null) {
                        cmpObj = this.readComplexObject(id, extendName);
                        refObjs.put(id, cmpObj);
                    } else {
                        cmpObj = o;
                    }
                }
                this.prop.setValue(obj, cmpObj);
            }
        }

        private Object readComplexObject(Object id, String extendName) {
            Map refObjData = (Map)DataEntitySerializerReader.this.refComplexPropertyData.get(extendName);
            if (refObjData != null) {
                List refValues = (List)refObjData.get(ConvertUtils.convert((Object)id, String.class));
                return DataEntitySerializerReader.this.readObject(this.prop.getComplexType(), refValues, DataEntitySerializerReader.this.getPropertyMaps(this.prop.getComplexType()));
            }
            return null;
        }
    }

    protected class CollectionPropertyMap
    implements PropertyMap {
        private int index;
        private ICollectionProperty prop;

        public CollectionPropertyMap(int ordinal, ICollectionProperty p) {
            this.index = ordinal;
            this.prop = p;
        }

        @Override
        public void mapValue(Object obj, List<Object> values) {
            List objs = (List)values.get(this.index);
            if (objs == null) {
                return;
            }
            List tobjs = (List)this.prop.getValue(obj);
            IDataEntityType dt = this.prop.getItemType();
            for (List vs : objs) {
                tobjs.add(DataEntitySerializerReader.this.readObject(dt, vs, DataEntitySerializerReader.this.getPropertyMaps(dt)));
            }
        }
    }

    protected class SimplePropertyMap
    implements PropertyMap {
        private int index;
        private IDataEntityProperty prop;
        private IConverter converter;

        public SimplePropertyMap(int ordinal, IDataEntityProperty p) {
            this.index = ordinal;
            this.prop = p;
            this.converter = this.getConverter(this.prop.getPropertyType());
        }

        private IConverter getConverter(Class<?> typeCls) {
            if (typeCls == Long.TYPE || typeCls == Long.class) {
                return this.getLongConverter();
            }
            if (typeCls == String.class) {
                return value -> value;
            }
            if (typeCls == Date.class) {
                return this.getDateConverter();
            }
            if (typeCls == Integer.TYPE || typeCls == Integer.class) {
                return this.getIntConverter();
            }
            if (typeCls == BigDecimal.class) {
                return this.getBigDecimalConverter();
            }
            if (typeCls == Boolean.TYPE) {
                return this.getBooleanConverter();
            }
            if (typeCls == List.class) {
                return this.getListConverter();
            }
            if (typeCls == ILocaleString.class) {
                return this.getLocaleStringConverter();
            }
            if (Enum.class.isAssignableFrom(typeCls)) {
                return this.getEnumConverter(typeCls);
            }
            return value -> DataEntitySerializerReader.this.mp.convertValue(value, typeCls);
        }

        private IConverter getEnumConverter(Class<?> typeCls) {
            return value -> Enum.valueOf(typeCls, (String)value);
        }

        private IConverter getLocaleStringConverter() {
            return value -> {
                if (value instanceof Map) {
                    Map mapval = (Map)value;
                    LocaleString val = new LocaleString();
                    for (Map.Entry o : mapval.entrySet()) {
                        val.setItem((String)o.getKey(), o.getValue());
                    }
                    value = val;
                }
                return value;
            };
        }

        private IConverter getDateConverter() {
            return value -> {
                if (value instanceof Long) {
                    value = new Date((Long)value);
                } else if (value instanceof String) {
                    String s = (String)value;
                    try {
                        value = s.length() <= 10 ? DataEntitySerializerReader.this.noTimeDF.parse(s) : DataEntitySerializerReader.this.DF.parse(s);
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException(String.format(ResManager.loadKDString("\u5c5e\u6027%1$s\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a%2$s", "DataEntitySerializerReader_0", "bos-dataentity", new Object[0]), this.prop.getName(), value), e);
                    }
                }
                return value;
            };
        }

        private IConverter getLongConverter() {
            return value -> {
                if (value.getClass() == Integer.class) {
                    value = ((Integer)value).longValue();
                }
                return value;
            };
        }

        private IConverter getBigDecimalConverter() {
            return value -> {
                if (value.getClass() == String.class) {
                    value = new BigDecimal((String)value);
                } else if (value.getClass() == Integer.class) {
                    value = new BigDecimal((Integer)value);
                } else if (value.getClass() == Long.class) {
                    value = new BigDecimal((Long)value);
                } else if (value.getClass() == Double.class) {
                    value = new BigDecimal(value.toString());
                }
                return value;
            };
        }

        private IConverter getIntConverter() {
            return value -> value;
        }

        private IConverter getBooleanConverter() {
            return value -> value;
        }

        private IConverter getListConverter() {
            return value -> {
                if (!List.class.isAssignableFrom(value.getClass())) {
                    value = DataEntitySerializerReader.this.mp.convertValue(value, List.class);
                }
                return value;
            };
        }

        @Override
        public void mapValue(Object obj, List<Object> values) {
            Object value = values.get(this.index);
            if (value == null) {
                return;
            }
            value = this.converter.convert(value);
            this.prop.setValueFast(obj, value);
        }
    }

    protected class GLangLocalePropertyMap
    implements PropertyMap {
        private int index;
        private ILocaleProperty prop;
        private IConverter converter;

        public GLangLocalePropertyMap(int ordinal, ILocaleProperty p) {
            this.index = ordinal;
            this.prop = p;
            this.converter = value -> {
                if (value instanceof Map) {
                    Map mapval = (Map)value;
                    LocaleString val = new LocaleString();
                    for (Map.Entry o : mapval.entrySet()) {
                        val.setItem((String)o.getKey(), o.getValue());
                    }
                    value = val;
                }
                return value;
            };
        }

        @Override
        public void mapValue(Object obj, List<Object> values) {
            Object value = values.get(this.index);
            if (value == null) {
                return;
            }
            value = this.converter.convert(value);
            this.prop.setGlangValue(obj, value);
        }
    }

    @FunctionalInterface
    private static interface IConverter {
        public Object convert(Object var1);
    }

    protected static interface PropertyMap {
        public void mapValue(Object var1, List<Object> var2);
    }
}

