/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.serialization.DataEntityDeserializerOption;
import kd.bos.dataentity.serialization.DataEntitySerializerReader;
import kd.bos.dataentity.utils.StringUtils;

class DataEntitySerializerReaderWithIndex
extends DataEntitySerializerReader {
    protected List<Object> indexes;
    private Map<IDataEntityType, List<Object>> mapIndexes = new HashMap<IDataEntityType, List<Object>>(16);

    DataEntitySerializerReaderWithIndex(DataEntityDeserializerOption option) {
        super(option);
    }

    @Override
    public Object readObject(IDataEntityType dt, Map<String, Object> mapObj) {
        this.indexes = (List)mapObj.get("index");
        return super.readObject(dt, mapObj);
    }

    @Override
    protected boolean isHasState(IDataEntityType currentDataEntityType, List<Object> values) {
        boolean hasState = this.includeDataEntityState || this.option.isIncludeDataEntityState();
        return hasState;
    }

    @Override
    protected List<DataEntitySerializerReader.PropertyMap> getPropertyMaps(IDataEntityType dt) {
        if (this.indexes == null) {
            return super.getPropertyMaps(dt);
        }
        List<Object> currentIndexes = this.indexes;
        if (this.mapIndexes.containsKey(dt)) {
            currentIndexes = this.mapIndexes.get(dt);
        }
        ArrayList<DataEntitySerializerReader.PropertyMap> propMaps = new ArrayList<DataEntitySerializerReader.PropertyMap>();
        for (int i = 0; i < currentIndexes.size(); ++i) {
            DataEntitySerializerReader.PropertyMap prop;
            String name;
            Object o = currentIndexes.get(i);
            if (o instanceof String) {
                name = (String)o;
            } else {
                List cols = (List)currentIndexes.get(i);
                name = (String)cols.get(0);
            }
            IDataEntityProperty p = (IDataEntityProperty)dt.getProperties().get(name);
            if (p instanceof ILocaleProperty) {
                prop = new DataEntitySerializerReader.GLangLocalePropertyMap(this, i, (ILocaleProperty)((Object)p));
                propMaps.add(prop);
                continue;
            }
            if (p instanceof ISimpleProperty) {
                prop = new DataEntitySerializerReader.SimplePropertyMap(this, i, p);
                propMaps.add(prop);
                continue;
            }
            if (p instanceof IComplexProperty && this.includeComplexProperty) {
                IComplexProperty cmp = (IComplexProperty)p;
                int index = i;
                if (!StringUtils.isBlank(cmp.getRefIdPropName())) {
                    RefObject<Object> ref_property = new RefObject<Object>(null);
                    if (dt.getProperties().tryGetValue(cmp.getRefIdPropName(), ref_property)) {
                        index = ((IDataEntityProperty)ref_property.argvalue).getOrdinal();
                    }
                }
                DataEntitySerializerReader.ComplexPropertyMap prop2 = new DataEntitySerializerReader.ComplexPropertyMap(this, index, cmp);
                propMaps.add(prop2);
                continue;
            }
            if (!(p instanceof ICollectionProperty)) continue;
            this.mapIndexes.put(((ICollectionProperty)p).getItemType(), (List)currentIndexes.get(i));
            prop = new DataEntitySerializerReader.CollectionPropertyMap(this, i, (ICollectionProperty)p);
            propMaps.add(prop);
        }
        return propMaps;
    }
}

