/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.DataEntitySerializerWriter;
import kd.bos.dataentity.utils.OrmUtils;

class DataEntitySerializerWriterWithIndex
extends DataEntitySerializerWriter {
    DataEntitySerializerWriterWithIndex(DataEntitySerializerOption option) {
        super(option);
    }

    @Override
    public Map<String, Object> serializerToMap(Object dataEntity) {
        Map<String, Object> objMap = super.serializerToMap(dataEntity);
        IDataEntityType dt = dataEntity instanceof DynamicObject ? ((DynamicObject)dataEntity).getDataEntityType() : OrmUtils.getDataEntityType(dataEntity.getClass());
        objMap.put("index", this.writeIndex(dt));
        return objMap;
    }

    public Object[] writeIndex(IDataEntityType dt) {
        Object[] indexes = new Object[dt.getProperties().size()];
        int i = 0;
        for (IDataEntityProperty p : dt.getProperties()) {
            Object[] value;
            if (p instanceof ISimpleProperty) {
                value = p.getName();
            } else if (p instanceof IComplexProperty) {
                value = p.getName();
            } else {
                IDataEntityType itemType = ((ICollectionProperty)p).getItemType();
                Object[] cols = this.writeIndex(itemType);
                Object[] newCols = new Object[cols.length + 1];
                newCols[0] = p.getName();
                System.arraycopy(cols, 0, newCols, 1, cols.length);
                value = newCols;
            }
            indexes[i++] = value;
        }
        return indexes;
    }

    @Override
    protected void writeSimpleValue(Object[] values, IDataEntityProperty p, Object value) {
        super.writeSimpleValue(values, p, value);
    }
}

