/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.exception.SerializationException;
import kd.bos.dataentity.metadata.DataEntityTypeFlag;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcSerializationErrorCode;
import kd.bos.dataentity.serialization.DcSerializerReader;
import kd.bos.dataentity.serialization.ISetJsonValueAction;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import org.apache.commons.beanutils.ConvertUtils;

final class DcJsonSerializerReaderImplement
extends DcSerializerReader {
    private static final String STRING = "??????";
    private HashMap<Class<?>, ISetJsonValueAction> _setValueActionsCache;
    private RefObject<Object> tempRef_findItem = new RefObject<Object>(null);

    private ISetJsonValueAction createSetValueAction(final Class<?> propertyType) {
        ISetJsonValueAction setValueFunc = null;
        setValueFunc = String.class.isAssignableFrom(propertyType) ? new ISetJsonValueAction(){

            @Override
            public void apply(ISimpleProperty sp, Object jValue, Object obj) {
                String strXmlValue = jValue == null ? null : jValue.toString();
                sp.setValue(obj, strXmlValue);
            }
        } : (LocaleString.class.isAssignableFrom(propertyType) && !this._isLocaleValueFull ? new ISetJsonValueAction(){

            @Override
            public void apply(ISimpleProperty sp, Object jValue, Object obj) {
                String strXmlValue = jValue == null ? "" : jValue.toString();
                LocaleString lv = (LocaleString)sp.getValue(obj);
                if (lv == null) {
                    lv = new LocaleString();
                    sp.setValue(obj, lv);
                }
                lv.setItem(DcJsonSerializerReaderImplement.this._binder.getLCId(), strXmlValue);
            }
        } : (Map.class.isAssignableFrom(propertyType) || List.class.isAssignableFrom(propertyType) ? new ISetJsonValueAction(){

            @Override
            public void apply(ISimpleProperty property, Object jValue, Object entity) {
                property.setValue(entity, jValue);
            }
        } : (Enum.class.isAssignableFrom(propertyType) ? new ISetJsonValueAction(){

            @Override
            public void apply(ISimpleProperty property, Object jValue, Object obj) {
                Object v = Enum.valueOf(propertyType, jValue.toString());
                property.setValue(obj, v);
            }
        } : new ISetJsonValueAction(){

            @Override
            public void apply(ISimpleProperty sp, Object jValue, Object obj) {
                if (jValue != null) {
                    if (jValue.getClass() == propertyType) {
                        sp.setValue(obj, jValue);
                    } else if (propertyType == Boolean.TYPE && jValue.getClass() == Boolean.class) {
                        sp.setValue(obj, jValue);
                    } else if (propertyType == Object.class) {
                        sp.setValue(obj, jValue);
                    } else if (propertyType == Date.class) {
                        sp.setValue(obj, new ObjectConverter.DateConverter().convert(jValue));
                    } else if (propertyType == BigDecimal.class && StringUtils.isBlank(jValue)) {
                        sp.setValue(obj, null);
                    } else if (propertyType == Integer.TYPE && jValue.getClass() == Integer.class) {
                        sp.setValue(obj, jValue);
                    } else {
                        sp.setValue(obj, ConvertUtils.convert((Object)jValue, (Class)propertyType));
                    }
                }
            }
        })));
        setValueFunc = this._isLocaleValueFull && propertyType == LocaleString.class ? new ISetJsonValueAction(){

            @Override
            public void apply(ISimpleProperty sp, Object jValue, Object obj) {
                Map values = (Map)(jValue instanceof Map ? jValue : null);
                if (values != null) {
                    LocaleString val = (LocaleString)sp.getValue(obj);
                    if (val == null) {
                        val = new LocaleString();
                        sp.setValue(obj, val);
                    }
                    for (Map.Entry o : values.entrySet()) {
                        val.setItem((String)o.getKey(), o.getValue());
                    }
                }
            }
        } : this._binder.bindJSONReadAction(propertyType, setValueFunc);
        if (setValueFunc == null) {
            throw new IllegalArgumentException("BindReadDataAction");
        }
        return setValueFunc;
    }

    public DcJsonSerializerReaderImplement(DcBinder binder, boolean isLocaleValueFull) {
        super(binder, isLocaleValueFull);
        this._setValueActionsCache = new HashMap();
    }

    public Object readElement(Map<String, Object> token, IDataEntityType dt, Object entity) {
        String currentElementName = DcJsonSerializerReaderImplement.getElementName(token);
        if (entity == null) {
            if (currentElementName != null) {
                dt = this.bindToType(token, currentElementName, dt);
            }
            if (dt.getFlag() != DataEntityTypeFlag.Primitive) {
                entity = this._binder.createInstance(dt);
            }
        } else {
            dt = this.getDataEntityType(entity);
        }
        this.push(entity);
        if (dt.getFlag() != DataEntityTypeFlag.Primitive) {
            IDataEntityProperty property = null;
            for (Map.Entry<String, Object> read : token.entrySet()) {
                property = (IDataEntityProperty)dt.getProperties().get(read.getKey());
                if (property != null) {
                    if (this.readSimpleProperty(read.getValue(), (ISimpleProperty)(property instanceof ISimpleProperty ? property : null), entity) || this.readComplexProperty(read.getValue(), (IComplexProperty)(property instanceof IComplexProperty ? property : null), entity) || this.readCollectionProperty(read.getValue(), (ICollectionProperty)(property instanceof ICollectionProperty ? property : null), entity)) continue;
                    SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
                    this.throwXmlException(DcSerializationErrorCode.ILLEGALPROPERTY.getCode(), String.format(ResManager.loadKDString("JSON\u8282\u70b9\u4e2d\u51fa\u73b0\u7684\u5c5e\u6027%s\uff0c\u5fc5\u987b\u662f\u7b80\u5355\u5c5e\u6027\u3001\u590d\u6742\u6216\u96c6\u5408\u5c5e\u6027\u7684\u4e00\u79cd\u3002", "DcJsonSerializerReaderImplement_0", SubSystemType.BOS, new Object[0]), property.getName()), tempVar2, null);
                    continue;
                }
                if ("_Type_".equals(read.getKey()) || "Type".equals(read.getKey())) continue;
                this._binder.readCustomJsonProperty(read, entity);
            }
        }
        return entity;
    }

    private void push(Object entity) {
        ISupportInitialize obj = (ISupportInitialize)(entity instanceof ISupportInitialize ? entity : null);
        if (obj != null) {
            obj.beginInit();
            this._supportInitializeObjects.push(obj);
        }
    }

    private boolean readSimpleProperty(Object token, ISimpleProperty property, Object entity) {
        String action;
        if (property == null) {
            return false;
        }
        if (token instanceof Map) {
            action = (String)((Map)token).get("action");
            if (action == null) {
                action = "setvalue";
            }
        } else {
            action = "setvalue";
        }
        this.doSimplePropertyAction(token, action, property, entity);
        return true;
    }

    private void doSimplePropertyAction(Object token, String action, ISimpleProperty property, Object entity) {
        if ("setvalue".equals(action)) {
            try {
                ISetJsonValueAction setValueAction = this.getSetValueAction(property.getPropertyType());
                setValueAction.apply(property, token, entity);
            }
            catch (RuntimeException ex) {
                SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
                this.throwXmlException(DcSerializationErrorCode.ACT_SETVALUE.getCode(), String.format(ResManager.loadKDString("\u5728\u8d4b\u503c%1$s:%2$s\u7684\u503c'%3$s'\u65f6\u5931\u8d25\uff0c%4$s", "DcJsonSerializerReaderImplement_1", SubSystemType.BOS, new Object[0]), property.getName(), property.getPropertyType().getName(), token.toString(), ex.getMessage()), tempVar, ex);
            }
        } else if ("reset".equals(action)) {
            property.resetValue(entity);
        } else if ("setnull".equals(action)) {
            try {
                property.setValue(entity, null);
            }
            catch (RuntimeException ex) {
                SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
                this.throwXmlException(DcSerializationErrorCode.ACT_SETNULL.getCode(), String.format(ResManager.loadKDString("\u5728\u8d4b\u503c%1$s:%2$s\u7684\u503c Null \u65f6\u5931\u8d25\uff0c%3$s", "DcJsonSerializerReaderImplement_2", SubSystemType.BOS, new Object[0]), property.getName(), property.getPropertyType().getName(), ex.getMessage()), tempVar2, ex);
            }
        } else {
            SerializationException.SerializationExceptionData tempVar3 = new SerializationException.SerializationExceptionData();
            this.throwXmlException(DcSerializationErrorCode.ILLEGALACTION.getCode(), String.format(ResManager.loadKDString("\u4e0d\u80fd\u8bc6\u522b\u7684\u5c5e\u6027\u64cd\u4f5c\u7b26%s", "DcJsonSerializerReaderImplement_3", SubSystemType.BOS, new Object[0]), action), tempVar3, null);
        }
    }

    private boolean readComplexProperty(Object token, IComplexProperty property, Object entity) {
        if (property == null) {
            return false;
        }
        if (!(token instanceof Map)) {
            return false;
        }
        if (!(token instanceof Map) && StringUtils.isEmpty(token.toString())) {
            return true;
        }
        String action = "edit";
        Map jObj = (Map)token;
        action = DcJsonSerializerReaderImplement.getAttributeValue(jObj, "action", action);
        this.doComplexPropertyAction(jObj, action, property, entity);
        return true;
    }

    private void doComplexPropertyAction(Map<String, Object> token, String action, IComplexProperty property, Object entity) {
        if ("edit".equals(action)) {
            Object currentValue = property.getValue(entity);
            Object newValue = this.readElement(token, property.getComplexType(), currentValue);
            if (!property.getReadOnly() && !ObjectUtils.nullSafeEquals(currentValue, newValue)) {
                property.setValue(entity, newValue);
            }
        } else if ("setnull".equals(action)) {
            property.setValue(entity, null);
        } else {
            SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
            this.throwXmlException(DcSerializationErrorCode.ILLEGALACTION.getCode(), String.format(ResManager.loadKDString("\u4e0d\u80fd\u8bc6\u522b\u7684\u5c5e\u6027\u64cd\u4f5c\u7b26{0}", "DcJsonSerializerReaderImplement_3", SubSystemType.BOS, new Object[0]), action), tempVar, null);
        }
    }

    private boolean readCollectionProperty(Object token, ICollectionProperty property, Object entity) {
        if (property == null) {
            return false;
        }
        if (token instanceof List) {
            for (Map item : (List)token) {
                String action = DcJsonSerializerReaderImplement.getAttributeValue(item, "action", "add");
                this.doCollectionPropertyAction(item, action, property, entity);
            }
        }
        return true;
    }

    private void doCollectionPropertyAction(Map<String, Object> item, String action, ICollectionProperty property, Object entity) {
        if ("add".equals(action)) {
            Object newItem = this.readElement(item, property.getItemType(), null);
            List<?> list = this.safeGetList(property, "", entity);
            if (list != null) {
                list.add(newItem);
            }
        } else if ("edit".equals(action)) {
            Object findItem = null;
            int index = this.findItemByOid(item, property, entity, this.tempRef_findItem);
            findItem = this.tempRef_findItem.argvalue;
            if (index >= 0) {
                this.readElement(item, property.getItemType(), findItem);
            } else if (index == -1) {
                SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
                this.throwXmlException(DcSerializationErrorCode.ITEMNOEXIST.getCode(), ResManager.loadKDString("\u8bd5\u56fe\u7f16\u8f91\u7684\u8282\u70b9\u5728\u73b0\u6709\u96c6\u5408\u4e2d\u6ca1\u6709\u627e\u5230\u3002", "DcJsonSerializerReaderImplement_4", SubSystemType.BOS, new Object[0]), tempVar, null);
            }
        } else if ("remove".equals(action)) {
            int index = this.findItemByOid(item, property, entity, this.tempRef_findItem);
            if (index >= 0) {
                List<?> list = this.safeGetList(property, "", entity);
                list.remove(index);
            } else if (index == -1) {
                SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
                this.throwXmlException(DcSerializationErrorCode.ITEMNOEXIST.getCode(), ResManager.loadKDString("\u8bd5\u56fe\u5220\u9664\u7684\u8282\u70b9\u5728\u73b0\u6709\u96c6\u5408\u4e2d\u6ca1\u6709\u627e\u5230\u3002", "DcJsonSerializerReaderImplement_5", SubSystemType.BOS, new Object[0]), tempVar2, null);
            }
        } else {
            SerializationException.SerializationExceptionData tempVar3 = new SerializationException.SerializationExceptionData();
            this.throwXmlException(DcSerializationErrorCode.ILLEGALACTION.getCode(), String.format(ResManager.loadKDString("\u4e0d\u80fd\u8bc6\u522b\u7684\u96c6\u5408\u64cd\u4f5c\u7b26%s", "DcJsonSerializerReaderImplement_6", SubSystemType.BOS, new Object[0]), action), tempVar3, null);
        }
    }

    public void endInitialize() {
        while (this._supportInitializeObjects.size() > 0) {
            ISupportInitialize initObj = (ISupportInitialize)this._supportInitializeObjects.pop();
            initObj.endInit();
        }
    }

    private int findItemByOid(Map<String, Object> srcItem, ICollectionProperty property, Object entity, RefObject<Object> item) {
        String oid = DcJsonSerializerReaderImplement.getAttributeValue(srcItem, "oid", null);
        if (StringUtils.isEmpty(oid)) {
            SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
            this.throwXmlException(DcSerializationErrorCode.EMPTYPKVALUE.getCode(), ResManager.loadKDString("\u8bd5\u56fe\u5904\u7406\u8282\u70b9\u5374\u6ca1\u6709\u6307\u5b9aoid", "DcJsonSerializerReaderImplement_7", SubSystemType.BOS, new Object[0]), tempVar, null);
            item.argvalue = null;
            return -2;
        }
        ISimpleProperty pk = property.getItemType().getPrimaryKey();
        if (pk == null) {
            SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
            this.throwXmlException(DcSerializationErrorCode.UNDEFINEDPRIMARYPROP.getCode(), String.format(ResManager.loadKDString("\u9700\u8981\u5904\u7406\u7684\u96c6\u5408{0}\u5176\u5143\u7d20\u7c7b\u578b{1}\u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e\u3002", "DcJsonSerializerReaderImplement_8", SubSystemType.BOS, new Object[0]), property.getName(), property.getItemType().getName()), tempVar2, null);
            item.argvalue = null;
            return -2;
        }
        Object oid2 = this.convertFromString(pk, entity, oid);
        List<?> list = this.safeGetList(property, "", entity);
        if (list == null) {
            item.argvalue = null;
            return -2;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object tempOid;
            item.argvalue = list.get(i);
            if (item.argvalue == null || !(tempOid = (pk = this._binder.getDataEntityType(item.argvalue).getPrimaryKey()).getValue(item.argvalue)).equals(oid2)) continue;
            return i;
        }
        item.argvalue = null;
        return -1;
    }

    private IDataEntityType bindToType(Map<String, Object> token, String name, IDataEntityType canUseType) {
        IDataEntityType dt;
        Map attrs;
        HashMap<String, String> attributes = new HashMap<String, String>();
        Object propValue = token.get("_Type_");
        if (propValue instanceof Map && (attrs = (Map)propValue) != null) {
            for (Map.Entry attr : attrs.entrySet()) {
                attributes.put((String)attr.getKey(), attr.getValue().toString());
            }
        }
        if ((dt = this._binder.bindToType(name, attributes)) == null && canUseType != null) {
            String canUseTypeName = this._binder.bindToName(canUseType);
            boolean isEquals = false;
            isEquals = this._binder.isIgnoreCase() ? name.equalsIgnoreCase(canUseTypeName) : name.equals(canUseTypeName);
            if (isEquals || canUseType instanceof DynamicObjectType) {
                dt = canUseType;
            }
        }
        if (dt == null) {
            SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
            tempVar.setCanIgnore(false);
            this.throwXmlException(DcSerializationErrorCode.UNDEFINEDENTITYTYPE.getCode(), String.format(ResManager.loadKDString("\u672a\u80fd\u627e\u5230%s\u5bf9\u5e94\u7684\u6570\u636e\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u662f\u5426Json\u5b57\u7b26\u4e32\u548c\u7c7b\u578b\u6ce8\u518c", "DcJsonSerializerReaderImplement_9", "bos-dataentity", new Object[0]), name), tempVar, null);
        }
        return dt;
    }

    private IDataEntityType getDataEntityType(Object entity) {
        return this._binder.getDataEntityType(entity);
    }

    private void throwXmlException(String code, String message, SerializationException.SerializationExceptionData data, RuntimeException innerException) {
        this._binder.ThrowException(new SerializationException(code, message, data, innerException));
    }

    private static String getElementName(Map<String, Object> obj) {
        Object prop = obj.get("_Type_");
        if (prop instanceof String) {
            return (String)prop;
        }
        return DcJsonSerializerReaderImplement.getAttributeValue(obj, "Name", null);
    }

    private static String getAttributeValue(Map<String, Object> obj, String attName, String defaultValue) {
        Map attrs;
        assert (obj != null);
        assert (StringUtils.isNotEmpty(attName));
        String value = defaultValue;
        Object prop = obj.get("_Type_");
        if (prop instanceof Map && (attrs = (Map)prop) != null) {
            value = (String)attrs.get(attName);
        }
        return value;
    }

    private ISetJsonValueAction getSetValueAction(Class<?> propertyType) {
        ISetJsonValueAction result = null;
        result = this._setValueActionsCache.get(propertyType);
        if (result == null) {
            result = this.createSetValueAction(propertyType);
            this._setValueActionsCache.put(propertyType, result);
        }
        return result;
    }
}

