/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcSerializer;
import kd.bos.dataentity.serialization.DcxmlDescRead;
import kd.bos.dataentity.serialization.DcxmlSerializerReadImplement;
import kd.bos.dataentity.serialization.DcxmlSerializerWriteImplement;
import kd.bos.dataentity.serialization.IDcDescReadPlugin;
import kd.bos.dataentity.serialization.XMLTemplate;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

@SdkPublic
public class DcxmlSerializer
extends DcSerializer {
    private static final Log logger = LogFactory.getLog(DcxmlSerializer.class);
    private static final String EXCEPTION = "Deserialize.DocumentException";
    private static final String SPAN_TYPE_DCXMLSERIALIZER = "DcxmlSerializer";
    private boolean privateOnlyLocaleVale;
    private boolean _colloctionIgnorePKValue;
    private boolean _needDBIgnore;
    private boolean privateResetLoacaleValueBy2052;
    private boolean newlines;
    private boolean ignoreTrimText;
    private boolean indent;
    private List<XMLTemplate> _styles = new ArrayList<XMLTemplate>();
    private SAXReader saxReader;

    public DcxmlSerializer(DcBinder binder) {
        super(binder);
    }

    public DcxmlSerializer(Iterable<IDataEntityType> dts) {
        super(dts);
    }

    public final boolean getOnlyLocaleVale() {
        return this.privateOnlyLocaleVale;
    }

    public final void setOnlyLocaleVale(boolean value) {
        this.privateOnlyLocaleVale = value;
    }

    public final boolean getColloctionIgnorePKValue() {
        return this._colloctionIgnorePKValue;
    }

    public final void setColloctionIgnorePKValue(boolean value) {
        this._colloctionIgnorePKValue = value;
    }

    public final boolean getNeedDBIgnore() {
        return this._needDBIgnore;
    }

    public final void setNeedDBIgnore(boolean value) {
        this._needDBIgnore = value;
    }

    public final boolean getResetLoacaleValueBy2052() {
        return this.privateResetLoacaleValueBy2052;
    }

    public final void setResetLoacaleValueBy2052(boolean value) {
        this.privateResetLoacaleValueBy2052 = value;
    }

    public boolean isNewlines() {
        return this.newlines;
    }

    public void setNewlines(boolean newlines) {
        this.newlines = newlines;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public boolean isIgnoreTrimText() {
        return this.ignoreTrimText;
    }

    public void setIgnoreTrimText(boolean ignoreTrimText) {
        this.ignoreTrimText = ignoreTrimText;
    }

    public final Object deserialize(URL url, Object entity) {
        SAXReader reader = this.getSaxReader();
        try {
            Document doc = reader.read(url);
            return this.readElement(doc.getRootElement(), null, entity);
        }
        catch (DocumentException e) {
            throw new OrmException(EXCEPTION, e.getMessage(), e);
        }
    }

    public final Object deserialize(File file, Object entity) {
        SAXReader reader = this.getSaxReader();
        try {
            Document doc = reader.read(file);
            return this.readElement(doc.getRootElement(), null, entity);
        }
        catch (DocumentException e) {
            throw new OrmException(EXCEPTION, e.getMessage(), e);
        }
    }

    public final Object deserialize(Document doc, Object entity) {
        return this.readElement(doc.getRootElement(), null, entity);
    }

    public void addTemplateFromString(String loacleId, String xmlTemplate) {
        SAXReader reader = this.getSaxReader();
        StringReader strReader = new StringReader(xmlTemplate);
        try {
            HashMap<String, Element> stylesMap = new HashMap<String, Element>();
            Document doc = reader.read((Reader)strReader);
            Iterator it = doc.getRootElement().elementIterator();
            while (it.hasNext()) {
                Element style = (Element)it.next();
                String id = style.attributeValue("Id");
                if (!StringUtils.isNotEmpty(id)) continue;
                stylesMap.put(id, style);
            }
            this._styles.add(new XMLTemplate(loacleId, stylesMap));
        }
        catch (DocumentException e) {
            throw new OrmException(EXCEPTION, e.getMessage(), e);
        }
    }

    private SAXReader getSaxReader() {
        if (this.saxReader == null) {
            this.saxReader = new SAXReader();
            try {
                this.saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                this.saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                this.saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (SAXException e) {
                logger.error(e.getMessage());
            }
        }
        return this.saxReader;
    }

    public void addTemplate(String loacleId, URL xmlTemplate) {
        SAXReader reader = this.getSaxReader();
        try {
            Document doc = reader.read(xmlTemplate);
            this.addTemplate(loacleId, doc);
        }
        catch (DocumentException e) {
            throw new OrmException(EXCEPTION, e.getMessage(), e);
        }
    }

    public void addTemplate(String loacleId, File xmlTemplate) {
        SAXReader reader = this.getSaxReader();
        try {
            Document doc = reader.read(xmlTemplate);
            this.addTemplate(loacleId, doc);
        }
        catch (DocumentException e) {
            throw new OrmException(EXCEPTION, e.getMessage(), e);
        }
    }

    private void addTemplate(String loacleId, Document doc) {
        HashMap<String, Element> stylesMap = new HashMap<String, Element>();
        Iterator it = doc.getRootElement().elementIterator();
        while (it.hasNext()) {
            Element style = (Element)it.next();
            String id = style.attributeValue("Id");
            if (!StringUtils.isNotEmpty(id)) continue;
            stylesMap.put(id, style);
        }
        this._styles.add(new XMLTemplate(loacleId, stylesMap));
    }

    public final Object deserializeFromString(String xml, Object entity) {
        SAXReader reader = this.getSaxReader();
        StringReader strReader = new StringReader(xml);
        try (EntityTraceSpan span = null;){
            span = EntityTracer.create(SPAN_TYPE_DCXMLSERIALIZER, "deserializeFromString", EntityTraceHint.getHintDisLinkAPM());
            Document doc = reader.read((Reader)strReader);
            Object object = this.readElement(doc.getRootElement(), null, entity);
            return object;
        }
    }

    public final String getDiffDesc(String diffxml, Object baseentity, IDcDescReadPlugin plugin) {
        SAXReader reader = this.getSaxReader();
        StringReader strReader = new StringReader(diffxml);
        try {
            Document doc = reader.read((Reader)strReader);
            DcxmlDescRead worker = new DcxmlDescRead(this.getBinder(), plugin);
            worker.ReadElement(doc.getRootElement(), null, baseentity);
            return worker.getDesc();
        }
        catch (DocumentException e) {
            throw new OrmException(EXCEPTION, e.getMessage(), e);
        }
    }

    private Object readElement(Element element, IDataEntityType dt, Object entity) {
        DcxmlSerializerReadImplement worker = new DcxmlSerializerReadImplement(this.getBinder(), this._colloctionIgnorePKValue, this.isLocaleValueFull());
        worker.setTemplate(this._styles);
        worker.setOnlyLocaleValue(this.getOnlyLocaleVale());
        worker.setResetLoacaleValueBy2052(this.getResetLoacaleValueBy2052());
        Object result = worker.ReadElement(element, dt, entity);
        worker.EndInitialize();
        return result;
    }

    public final String serializeToString(Object currentEntity, Object baseEntity) {
        DcxmlSerializerWriteImplement xmlWrite = new DcxmlSerializerWriteImplement(this.getBinder(), this.getSerializeComplexProperty(), this.isLocaleValueFull());
        xmlWrite.setIndent(this.indent);
        xmlWrite.setNewlines(this.newlines);
        if (this.ignoreTrimText) {
            xmlWrite.isXmlTrimText = false;
        }
        return xmlWrite.Serialize(null, currentEntity, baseEntity);
    }
}

