/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.SerializationException;
import kd.bos.dataentity.metadata.DataEntityTypeFlag;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.SimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcAction;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcSerializationErrorCode;
import kd.bos.dataentity.serialization.DcSerializerReader;
import kd.bos.dataentity.serialization.ISetValueAction;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.serialization.XMLTemplate;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.beanutils.ConvertUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;

final class DcxmlSerializerReadImplement
extends DcSerializerReader {
    private static final Log logger = LogFactory.getLog(DcxmlSerializerReadImplement.class);
    private static final String BOS_DATAENTITY = "bos-dataentity";
    private static final String STRING = "??????";
    private static final String ZH_CN = "zh-CN";
    protected HashMap<Class<?>, ISetValueAction> _setValueActionsCache;
    private List<XMLTemplate> _styles;
    private boolean _colloctionIgnorePKValue;
    private RefObject<Object> tempRef_findItem = new RefObject();

    public DcxmlSerializerReadImplement(DcBinder binder, boolean isLocaleValueFull) {
        super(binder, isLocaleValueFull);
    }

    public DcxmlSerializerReadImplement(DcBinder binder, boolean colloctionIgnorePKValue, boolean isLocaleValueFull) {
        this(binder, isLocaleValueFull);
        this._setValueActionsCache = new HashMap();
        this._colloctionIgnorePKValue = colloctionIgnorePKValue;
    }

    public void setTemplate(List<XMLTemplate> styles) {
        this._styles = styles;
    }

    public Object ReadElement(Element element, IDataEntityType dt, Object entity) {
        String dtName = "?";
        String dtProperties = "not null";
        if (dt != null) {
            dtName = dt.getName();
            if (dt.getProperties() == null) {
                dtProperties = "null";
            }
        }
        if (entity == null) {
            if ((dt = this.BindToType(element, dt)) != null && dt.getFlag() != DataEntityTypeFlag.Primitive && !this.getOnlyLocaleValue()) {
                entity = this._binder.createInstance(dt);
            }
        } else {
            dt = this.GetDataEntityType(entity);
        }
        if (dt == null) {
            throw new KDException(BosErrorCode.nullError, new Object[]{"dt is null"});
        }
        if (dt.getFlag() != DataEntityTypeFlag.Primitive && this.getOnlyLocaleValue() && entity == null) {
            return entity;
        }
        if (dt != null && StringUtils.isNotBlank(dtName) && dt.getProperties() == null && !dtName.equalsIgnoreCase(dt.getName())) {
            throw new KDException("element:" + element.asXML() + "dt.name\uff1a" + dt.getName() + " dtName:" + dtName + " dtProperties:" + dtProperties + " xml:" + element.getDocument().asXML());
        }
        this.Push(entity);
        if (element.hasContent() || element.attributeCount() > 0) {
            if (dt.getFlag() == DataEntityTypeFlag.Primitive) {
                String valueStr = element.getStringValue();
                Class<?> type = DcBinder.getPrimitiveType(dt.getName().toLowerCase());
                entity = type != String.class ? ConvertUtils.convert((String)valueStr, type) : valueStr;
            } else {
                this.readPropertys(element, dt, entity);
            }
        }
        return entity;
    }

    private void readPropertys(Element element, IDataEntityType dt, Object entity) {
        String styleId;
        if (this._styles != null && (styleId = element.attributeValue("style")) != null) {
            String[] styleNames;
            String lcid = this._binder.getLCId();
            for (String styleName : styleNames = styleId.split(",")) {
                for (XMLTemplate template : this._styles) {
                    this._binder.setLCId(template.getLocaleId());
                    Element style = template.getStyles().get(styleName);
                    if (style == null) continue;
                    this.readPropertys(style, dt, entity);
                }
            }
            this._binder.setLCId(lcid);
        }
        IDataEntityProperty property = null;
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element propElement = (Element)it.next();
            if (propElement == null) {
                throw new KDException("propElement=null");
            }
            if (dt == null || dt.getProperties() == null) {
                String msg = "";
                if (dt == null) {
                    msg = "dt==null";
                } else if (dt.getProperties() == null) {
                    String dtname = "";
                    if (StringUtils.isNotBlank(dt.getName())) {
                        dtname = dt.getName();
                    }
                    msg = " error info:  dt.name=" + dtname + ",dt.getProperties()==null";
                }
                throw new KDException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString("%1$,\u8282\u70b9xml:%2$,\u5f53\u524d\u8282\u70b9text\uff1a%3$", "DcxmlSerializerReadImplement_0", BOS_DATAENTITY, new Object[0]), msg, propElement.asXML(), propElement.getText())});
            }
            property = (IDataEntityProperty)dt.getProperties().get(propElement.getName());
            if (property != null) {
                if (this.ReadSimpleProperty((ISimpleProperty)(property instanceof ISimpleProperty ? property : null), propElement, entity) || this.ReadComplexProperty((IComplexProperty)(property instanceof IComplexProperty ? property : null), propElement, entity) || this.ReadCollectionProperty((ICollectionProperty)(property instanceof ICollectionProperty ? property : null), propElement, entity)) continue;
                SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
                tempVar2.setCanIgnore(true);
                this.throwXmlException(DcSerializationErrorCode.ILLEGALPROPERTY.getCode(), String.format(ResManager.loadKDString("XML\u8282\u70b9\u4e2d\u51fa\u73b0\u7684\u5c5e\u6027%s\uff0c\u5fc5\u987b\u662f\u7b80\u5355\u5c5e\u6027\u3001\u590d\u6742\u6216\u96c6\u5408\u5c5e\u6027\u7684\u4e00\u79cd\u3002", "DcxmlSerializerReadImplement_2", BOS_DATAENTITY, new Object[0]), property.getName()), element.getName(), tempVar2, null);
                continue;
            }
            this._binder.readCustomXmlProperty(propElement, entity);
        }
    }

    private void Push(Object entity) {
        ISupportInitialize obj = (ISupportInitialize)(entity instanceof ISupportInitialize ? entity : null);
        if (obj != null) {
            obj.beginInit();
            this._supportInitializeObjects.push(obj);
        }
    }

    private boolean ReadSimpleProperty(ISimpleProperty property, Element propElement, Object entity) {
        if (property == null) {
            return false;
        }
        if (this._binder.readSimpleProperty(property, propElement, entity)) {
            return true;
        }
        String action = DcxmlSerializerReadImplement.GetAttributeValue(propElement, "action", "setvalue");
        this.DoSimplePropertyAction(action, property, propElement, entity);
        return true;
    }

    private void DoSimplePropertyAction(String action, ISimpleProperty property, Element propElement, Object entity) {
        if (this.getOnlyLocaleValue() && !ILocaleString.class.isAssignableFrom(property.getPropertyType()) && !property.isPrimaryKey()) {
            return;
        }
        if ("setvalue".equals(action)) {
            try {
                ISetValueAction setValueAction = this.GetSetValueAction(property.getPropertyType());
                setValueAction.apply(property, propElement, entity);
            }
            catch (RuntimeException ex) {
                SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
                tempVar.setCanIgnore(true);
                this.throwXmlException(DcSerializationErrorCode.ACT_SETVALUE.getCode(), String.format(ResManager.loadKDString("\u5728\u8d4b\u503c%1$s:%2$s\u7684\u503c'%3$s'\u65f6\u5931\u8d25\uff0c%4$s", "DcxmlSerializerReadImplement_3", BOS_DATAENTITY, new Object[0]), property.getName(), property.getPropertyType().getName(), propElement.getStringValue(), ex.getMessage()), propElement.asXML(), tempVar, ex);
            }
        } else if ("reset".equals(action)) {
            if (ILocaleString.class.isAssignableFrom(property.getPropertyType())) {
                ILocaleString lv = (ILocaleString)property.getValue(entity);
                if (lv == null) {
                    property.resetValue(entity);
                } else if (property instanceof SimpleProperty) {
                    String lcid = this._binder.getLCId();
                    if (!ZH_CN.equals(lcid)) {
                        lv.setItem(lcid, lv.getItem(ZH_CN));
                    } else {
                        property.resetValue(entity);
                    }
                }
            } else {
                property.resetValue(entity);
            }
        } else if ("setnull".equals(action)) {
            try {
                property.setValue(entity, null);
            }
            catch (RuntimeException ex) {
                SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
                tempVar2.setCanIgnore(true);
                this.throwXmlException(DcSerializationErrorCode.ACT_SETNULL.getCode(), String.format(ResManager.loadKDString("\u5728\u8d4b\u503c%1$s:%2$s\u7684\u503c Null \u65f6\u5931\u8d25\uff0c%3$s", "DcxmlSerializerReadImplement_4", BOS_DATAENTITY, new Object[0]), property.getName(), property.getPropertyType().getName(), ex.getMessage()), propElement.getName(), tempVar2, ex);
            }
        } else {
            SerializationException.SerializationExceptionData tempVar3 = new SerializationException.SerializationExceptionData();
            tempVar3.setCanIgnore(true);
            this.throwXmlException(DcSerializationErrorCode.ILLEGALACTION.getCode(), String.format(ResManager.loadKDString("\u4e0d\u80fd\u8bc6\u522b\u7684\u5c5e\u6027\u64cd\u4f5c\u7b26%s", "DcxmlSerializerReadImplement_5", BOS_DATAENTITY, new Object[0]), action), propElement.getName(), tempVar3, null);
        }
    }

    private boolean ReadComplexProperty(IComplexProperty property, Element propElement, Object entity) {
        if (property == null) {
            return false;
        }
        String action = DcxmlSerializerReadImplement.GetAttributeValue(propElement, "action", "edit");
        this.DoComplexPropertyAction(action, property, propElement, entity);
        return true;
    }

    private void DoComplexPropertyAction(String action, IComplexProperty property, Element propElement, Object entity) {
        if ("edit".equals(action)) {
            if (propElement.hasContent() && propElement.elements().size() > 0) {
                Object currentValue = property.getValue(entity);
                Object newValue = this.ReadElement((Element)propElement.elements().get(0), property.getComplexType(), currentValue);
                if (!property.getReadOnly() && currentValue != newValue) {
                    property.setValue(entity, newValue);
                }
            } else if (!property.getReadOnly()) {
                property.setValue(entity, null);
            }
        } else if ("setnull".equals(action)) {
            if (!this.getOnlyLocaleValue()) {
                property.setValue(entity, null);
            }
        } else {
            SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
            tempVar.setCanIgnore(true);
            this.throwXmlException(DcSerializationErrorCode.ILLEGALACTION.getCode(), String.format(ResManager.loadKDString("\u4e0d\u80fd\u8bc6\u522b\u7684\u5c5e\u6027\u64cd\u4f5c\u7b26%s", "DcxmlSerializerReadImplement_5", BOS_DATAENTITY, new Object[0]), action), propElement.getName(), tempVar, null);
        }
    }

    private boolean ReadCollectionProperty(ICollectionProperty property, Element propElement, Object entity) {
        if (property == null) {
            return false;
        }
        String action = DcxmlSerializerReadImplement.GetAttributeValue(propElement, "action", "add");
        if (DcAction.PropertyAction_SetNull.getActionName().equalsIgnoreCase(action)) {
            property.setValue(entity, null);
            return true;
        }
        if (DcAction.ListAction_Clear.getActionName().equals(action)) {
            Object tempVar = property.getValue(entity);
            List lst = (List)(tempVar instanceof List ? tempVar : null);
            if (lst != null) {
                lst.clear();
            }
            return true;
        }
        Iterator it = propElement.elementIterator();
        while (it.hasNext()) {
            Element itemElement = (Element)it.next();
            action = DcxmlSerializerReadImplement.GetAttributeValue(itemElement, "action", "add");
            this.DoCollectionPropertyAction(action, property, itemElement, entity);
        }
        return true;
    }

    private void DoCollectionPropertyAction(String action, ICollectionProperty property, Element itemElement, Object entity) {
        if ("add".equals(action)) {
            Object newItem = this.ReadElement(itemElement, property.getItemType(), null);
            if (newItem == null && this.getOnlyLocaleValue()) {
                return;
            }
            List<?> list = this.safeGetList(property, itemElement.getName(), entity);
            if (list != null) {
                if (this._colloctionIgnorePKValue) {
                    list.add(newItem);
                } else {
                    int index = this.FindItemIndex(property, itemElement, entity, newItem);
                    if (index < 0) {
                        list.add(newItem);
                    }
                }
            }
        } else if ("edit".equals(action)) {
            Object findItem = null;
            int index = this.FindItemByOid(property, itemElement, entity, this.tempRef_findItem);
            findItem = this.tempRef_findItem.argvalue;
            if (index >= 0) {
                this.ReadElement(itemElement, property.getItemType(), findItem);
            } else if (index == -1) {
                SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
                tempVar.setCanIgnore(true);
                this.throwXmlException(DcSerializationErrorCode.ITEMNOEXIST.getCode(), ResManager.loadKDString("\u8bd5\u56fe\u7f16\u8f91\u7684\u8282\u70b9\u5728\u73b0\u6709\u96c6\u5408\u4e2d\u6ca1\u6709\u627e\u5230\u3002", "DcxmlSerializerReadImplement_6", BOS_DATAENTITY, new Object[0]), itemElement.getName() + ":" + itemElement.asXML(), tempVar, null);
            }
        } else if ("remove".equals(action)) {
            if (!this.getOnlyLocaleValue()) {
                int index = this.FindItemByOid(property, itemElement, entity, this.tempRef_findItem);
                if (index >= 0) {
                    List<?> list = this.safeGetList(property, itemElement.getName(), entity);
                    list.remove(index);
                } else if (index == -1) {
                    SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
                    tempVar2.setCanIgnore(true);
                    this.throwXmlException(DcSerializationErrorCode.ITEMNOEXIST.getCode(), ResManager.loadKDString("\u8bd5\u56fe\u5220\u9664\u7684\u8282\u70b9\u5728\u73b0\u6709\u96c6\u5408\u4e2d\u6ca1\u6709\u627e\u5230\u3002", "DcxmlSerializerReadImplement_7", BOS_DATAENTITY, new Object[0]), itemElement.asXML(), tempVar2, null);
                }
            }
        } else {
            SerializationException.SerializationExceptionData tempVar3 = new SerializationException.SerializationExceptionData();
            tempVar3.setCanIgnore(true);
            this.throwXmlException(DcSerializationErrorCode.ILLEGALACTION.getCode(), String.format(ResManager.loadKDString("\u4e0d\u80fd\u8bc6\u522b\u7684\u96c6\u5408\u64cd\u4f5c\u7b26%s", "DcxmlSerializerReadImplement_8", BOS_DATAENTITY, new Object[0]), action), itemElement.getName(), tempVar3, null);
        }
    }

    public void EndInitialize() {
        while (this._supportInitializeObjects.size() > 0) {
            ISupportInitialize initObj = (ISupportInitialize)this._supportInitializeObjects.pop();
            initObj.endInit();
        }
    }

    private int FindItemIndex(ICollectionProperty property, Element itemElement, Object entity, Object item) {
        ISimpleProperty pk = this._binder.getDataEntityType(item).getPrimaryKey();
        if (pk == null) {
            return -1;
        }
        Object tempOid = pk.getValue(item);
        String id = tempOid == null ? "" : tempOid.toString();
        int tempVar = this.FindItemByOid(property, itemElement, entity, id, this.tempRef_findItem);
        return tempVar;
    }

    private int FindItemByOid(ICollectionProperty property, Element itemElement, Object entity, RefObject<Object> item) {
        String oid = itemElement.attributeValue("oid");
        return this.FindItemByOid(property, itemElement, entity, oid, item);
    }

    private int FindItemByOid(ICollectionProperty property, Element itemElement, Object entity, String oid, RefObject<Object> item) {
        if (StringUtils.isEmpty(oid)) {
            SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
            tempVar.setCanIgnore(true);
            this.throwXmlException(DcSerializationErrorCode.EMPTYPKVALUE.getCode(), String.format(ResManager.loadKDString("\u8bd5\u56fe\u5904\u7406\u8282\u70b9%s\u6ca1\u6709\u6307\u5b9aoid", "DcxmlSerializerReadImplement_9", BOS_DATAENTITY, new Object[0]), itemElement.getName()), itemElement.asXML(), tempVar, null);
            item.argvalue = null;
            return -2;
        }
        ISimpleProperty pk = property.getItemType().getPrimaryKey();
        if (pk == null) {
            SerializationException.SerializationExceptionData tempVar2 = new SerializationException.SerializationExceptionData();
            tempVar2.setCanIgnore(false);
            this.throwXmlException(DcSerializationErrorCode.UNDEFINEDPRIMARYPROP.getCode(), String.format(ResManager.loadKDString("\u9700\u8981\u5904\u7406\u7684\u96c6\u5408%1$s\u5176\u5143\u7d20\u7c7b\u578b%2$s\u6ca1\u6709\u5b9a\u4e49\u4e3b\u952e\u3002", "DcxmlSerializerReadImplement_10", BOS_DATAENTITY, new Object[0]), property.getName(), property.getItemType().getName()), itemElement.getName(), tempVar2, null);
            item.argvalue = null;
            return -2;
        }
        Object oid2 = this.convertFromString(pk, entity, oid);
        List<?> list = this.safeGetList(property, itemElement.getName(), entity);
        if (list == null) {
            item.argvalue = null;
            return -2;
        }
        for (int i = 0; i < list.size(); ++i) {
            item.argvalue = list.get(i);
            if (item.argvalue == null) continue;
            pk = this._binder.getDataEntityType(item.argvalue).getPrimaryKey();
            Object tempOid = pk.getValue(item.argvalue);
            if (tempOid == null) {
                logger.error(item.argvalue + " not found.");
            }
            if (tempOid == null || !tempOid.equals(oid2)) continue;
            return i;
        }
        item.argvalue = null;
        return -1;
    }

    private IDataEntityType BindToType(Element element, IDataEntityType canUseType) {
        String name = element.getName();
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Object item : element.attributes()) {
            Attribute attribute = (Attribute)item;
            attributes.put(attribute.getName(), attribute.getValue());
        }
        IDataEntityType dt = this._binder.bindToType(name, attributes);
        if (dt == null && canUseType != null) {
            String canUseTypeName = this._binder.bindToName(canUseType);
            boolean isEquals = false;
            isEquals = this._binder.isIgnoreCase() ? name.equalsIgnoreCase(canUseTypeName) : name.equals(canUseTypeName);
            if (isEquals) {
                dt = canUseType;
            }
        }
        if (dt == null) {
            SerializationException.SerializationExceptionData tempVar = new SerializationException.SerializationExceptionData();
            tempVar.setCanIgnore(false);
            this.throwXmlException(DcSerializationErrorCode.UNDEFINEDENTITYTYPE.getCode(), String.format(ResManager.loadKDString("\u672a\u80fd\u627e\u5230%s\u5bf9\u5e94\u7684\u6570\u636e\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u662f\u5426Xml\u4e2d\u62fc\u5199\u9519\u8bef\u3002", "DcxmlSerializerReadImplement_11", BOS_DATAENTITY, new Object[0]), name), element.asXML(), tempVar, null);
        }
        return dt;
    }

    private IDataEntityType GetDataEntityType(Object entity) {
        return this._binder.getDataEntityType(entity);
    }

    private static String GetAttributeValue(Element propElement, String attName, String defaultValue) {
        assert (propElement != null);
        assert (StringUtils.isNotEmpty(attName));
        String value = propElement.attributeValue(attName);
        value = StringUtils.isEmpty(value) ? defaultValue : value.toLowerCase(Locale.ENGLISH);
        return value;
    }

    private ISetValueAction GetSetValueAction(Class<?> propertyType) {
        ISetValueAction result = null;
        result = this._setValueActionsCache.get(propertyType);
        if (result == null) {
            result = this.CreateSetValueAction(propertyType);
            this._setValueActionsCache.put(propertyType, result);
        }
        return result;
    }

    private ISetValueAction CreateSetValueAction(final Class<?> propertyType) {
        ISetValueAction setValueFunc = String.class.isAssignableFrom(propertyType) ? new ISetValueAction(){

            @Override
            public void apply(ISimpleProperty property, Element element, Object entity) {
                String strXmlValue = element.getStringValue();
                property.setValue(entity, strXmlValue);
            }
        } : (LocaleString.class.isAssignableFrom(propertyType) && this._isLocaleValueFull ? new ISetValueAction(){

            @Override
            public void apply(ISimpleProperty property, Element element, Object entity) {
                Map values;
                if (StringUtils.isNotBlank(element.getText()) && (values = (Map)SerializationUtils.fromJsonString(element.getText(), Map.class)) != null) {
                    LocaleString val = (LocaleString)property.getValue(entity);
                    if (val == null) {
                        val = new LocaleString();
                        property.setValue(entity, val);
                    }
                    for (Map.Entry o : values.entrySet()) {
                        val.setItem((String)o.getKey(), o.getValue());
                    }
                }
            }
        } : (LocaleString.class.isAssignableFrom(propertyType) ? new ISetValueAction(){

            @Override
            public void apply(ISimpleProperty property, Element element, Object entity) {
                LocaleString lv;
                String strXmlValue = element.getStringValue();
                String lcid = DcxmlSerializerReadImplement.this._binder.getLCId();
                if (DcxmlSerializerReadImplement.this.getResetLoacaleValueBy2052() && DcxmlSerializerReadImplement.ZH_CN.equals(lcid)) {
                    property.resetValue(entity);
                }
                if ((lv = (LocaleString)property.getValue(entity)) == null) {
                    lv = new LocaleString();
                    lv.setItem(DcxmlSerializerReadImplement.this._binder.getLCId(), strXmlValue);
                    property.setValue(entity, lv);
                }
                if (StringUtils.isEmpty(strXmlValue)) {
                    lv.setItem(lcid, "");
                } else {
                    lv.setItem(lcid, strXmlValue);
                }
            }
        } : (List.class.isAssignableFrom(propertyType) ? new ISetValueAction(){

            @Override
            public void apply(ISimpleProperty property, Element element, Object entity) {
                if (StringUtils.isNotBlank(element.getText())) {
                    property.setValue(entity, SerializationUtils.fromJsonStringToList(element.getText(), Map.class));
                }
            }
        } : (Map.class.isAssignableFrom(propertyType) ? new ISetValueAction(){

            @Override
            public void apply(ISimpleProperty property, Element element, Object entity) {
                if (StringUtils.isNotBlank(element.getText())) {
                    property.setValue(entity, SerializationUtils.fromJsonString(element.getText(), propertyType));
                }
            }
        } : (byte[].class.isAssignableFrom(propertyType) ? new ISetValueAction(){

            @Override
            public void apply(ISimpleProperty property, Element element, Object entity) {
            }
        } : (Enum.class.isAssignableFrom(propertyType) ? new ISetValueAction(){

            @Override
            public void apply(ISimpleProperty property, Element element, Object obj) {
                try {
                    Class<?> cls = Class.forName(propertyType.getName());
                    String strXmlValue = element.getStringValue();
                    Object enum1 = Enum.valueOf(cls, strXmlValue);
                    property.setValue(obj, enum1);
                }
                catch (ClassNotFoundException e) {
                    logger.error(e.getMessage());
                }
            }
        } : new ISetValueAction(){

            @Override
            public void apply(ISimpleProperty property, Element element, Object entity) {
                String strXmlValue = element.getStringValue();
                Object value = DcxmlSerializerReadImplement.this.convertFromString(property, entity, strXmlValue);
                property.setValue(entity, value);
            }
        }))))));
        if ((setValueFunc = this._binder.bindReadAction(propertyType, setValueFunc)) == null) {
            throw new IllegalArgumentException("BindReadDataAction");
        }
        return setValueFunc;
    }

    class KDPropertyException
    extends KDException {
        public KDPropertyException(String message) {
            super(message);
        }
    }
}

