/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.DefaultSyncFunction;
import kd.bos.dataentity.ListSync;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.DataEntityTypeFlag;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.dataentity.serialization.DcAction;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcSerializerWrite;
import kd.bos.dataentity.serialization.IBindEqualsFunc;
import kd.bos.dataentity.serialization.ISupplier;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

final class DcxmlSerializerWriteImplement
extends DcSerializerWrite {
    private boolean newlines;
    private boolean indent;
    private RefObject<Element> tempRef_serObj = new RefObject();
    private RefObject<Boolean> tempRef_isCData = new RefObject<Boolean>(false);

    public boolean isNewlines() {
        return this.newlines;
    }

    public void setNewlines(boolean newlines) {
        this.newlines = newlines;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public DcxmlSerializerWriteImplement(DcBinder binder, boolean serializeComplexProperty, boolean isLocaleValueFull) {
        super(binder, serializeComplexProperty, isLocaleValueFull);
        this.isXmlTrimText = true;
    }

    public final String Serialize(IDataEntityType dt, Object currentEntity, Object baseEntity) {
        StringWriter writer = new StringWriter();
        OutputFormat format = new OutputFormat();
        format.setIndent(this.indent);
        format.setNewlines(this.newlines);
        format.setTrimText(this.isXmlTrimText);
        XMLWriter xmlWrite = new XMLWriter((Writer)writer, format);
        try {
            Document xmlDoc = DocumentHelper.createDocument();
            this.WriteObject((Branch)xmlDoc, dt, currentEntity, baseEntity, null);
            xmlWrite.write(xmlDoc);
            ((Writer)writer).close();
            xmlWrite.close();
        }
        catch (IOException e) {
            throw new OrmException("Serialize.XMLWrite", e.getMessage(), e);
        }
        return ((Object)writer).toString();
    }

    private Element WriteObject(Branch parentElement, IDataEntityType currentEntityType, Object currentEntity, Object baseEntity, DcAction action) {
        if (currentEntity == null) {
            throw new IllegalArgumentException("currentEntity");
        }
        Element serObj = null;
        currentEntityType = this.WriteObjectElement(parentElement, currentEntityType, currentEntity, baseEntity, action, this.tempRef_serObj);
        serObj = (Element)this.tempRef_serObj.argvalue;
        if (this.shouldCompare(currentEntityType, baseEntity)) {
            if (currentEntityType.getFlag() != DataEntityTypeFlag.Primitive) {
                for (IDataEntityProperty p : currentEntityType.getProperties()) {
                    if (this._binder.getOnlyDbProperty() && p.isDbIgnore()) continue;
                    ISimpleProperty sp = (ISimpleProperty)(p instanceof ISimpleProperty ? p : null);
                    if (sp != null) {
                        this.WriteSimpleProperties(serObj, sp, currentEntity, baseEntity);
                        continue;
                    }
                    IComplexProperty cpx = (IComplexProperty)(p instanceof IComplexProperty ? p : null);
                    if (cpx != null && this._serializeComplexProperty) {
                        this.WriteComplexProperties(serObj, cpx, currentEntity, baseEntity);
                        continue;
                    }
                    ICollectionProperty cp = (ICollectionProperty)(p instanceof ICollectionProperty ? p : null);
                    if (cp == null) continue;
                    this.WriteCollectionProperties(serObj, cp, currentEntityType, currentEntity, baseEntity);
                }
                this._binder.writeCustomXmlProperties(serObj, currentEntity, baseEntity);
            }
        } else {
            if (currentEntityType.getFlag() == DataEntityTypeFlag.Primitive) {
                this.WritePrimitiveObject(currentEntityType, currentEntity);
            } else {
                for (IDataEntityProperty p : currentEntityType.getProperties()) {
                    if (this._binder.getOnlyDbProperty() && p.isDbIgnore()) continue;
                    ISimpleProperty sp = (ISimpleProperty)(p instanceof ISimpleProperty ? p : null);
                    if (sp != null) {
                        this.WriteSimpleProperties_S(serObj, sp, currentEntity);
                        continue;
                    }
                    IComplexProperty cpx = (IComplexProperty)(p instanceof IComplexProperty ? p : null);
                    if (cpx != null && this._serializeComplexProperty) {
                        this.WriteComplexProperties_S(serObj, cpx, currentEntity);
                        continue;
                    }
                    ICollectionProperty cp = (ICollectionProperty)(p instanceof ICollectionProperty ? p : null);
                    if (cp == null) continue;
                    this.WriteCollectionProperties_S(serObj, cp, currentEntity);
                }
            }
            this._binder.writeCustomXmlProperties(serObj, currentEntity, baseEntity);
        }
        return serObj;
    }

    private void WritePrimitiveObject(IDataEntityType dt, Object value) {
    }

    private IDataEntityType WriteObjectElement(Branch parentElement, IDataEntityType dt, Object entity, Object baseEntity, DcAction action, RefObject<Element> serObj) {
        Object pkTemp;
        IDataEntityType newDt = this._binder.getDataEntityType(entity);
        if (newDt != null && !newDt.equals(dt)) {
            dt = newDt;
        }
        Element arrObj = parentElement.addElement(this._binder.bindToName(dt));
        if (dt == null) {
            throw new ORMDesignException("??????", String.format(ResManager.loadKDString("\u5b9e\u4f53%s\u5fc5\u987b\u5b9e\u73b0IDataEntityBase\u624d\u80fd\u8fdb\u884c\u5e8f\u5217\u5316\u64cd\u4f5c\u3002", "DcxmlSerializerWriteImplement_0", SubSystemType.BOS, new Object[0]), entity.getClass().getName()));
        }
        serObj.argvalue = arrObj;
        Map<String, String> attributes = this._binder.getDataEntityAttributes(entity);
        if (attributes != null) {
            for (Map.Entry<String, String> arr : attributes.entrySet()) {
                arrObj.addAttribute(arr.getKey(), arr.getValue());
            }
        }
        ISimpleProperty pk = dt.getPrimaryKey();
        String pkValue = null;
        if (pk != null && (pkTemp = pk.getValue(entity)) != null) {
            pkValue = this.convertToString(pk, entity, pkTemp);
        }
        if (baseEntity == null && action == null) {
            action = DcAction.ListAction_Add;
        }
        if (action != null && !DcAction.ListAction_Add.equals(action)) {
            arrObj.addAttribute("action", action.getActionName());
            assert (StringUtils.isNotEmpty(pkValue));
            arrObj.addAttribute("oid", pkValue);
        }
        return dt;
    }

    private void WriteSimpleProperties(Element serObj, ISimpleProperty property, Object currentEntity, Object baseEntity) {
        Object currentValue = property.getValue(currentEntity);
        Object baseValue = property.getValue(baseEntity);
        IBindEqualsFunc equalsFunc = this.getEqualsFunc(property.getPropertyType());
        if (!equalsFunc.equals(currentValue, baseValue).booleanValue()) {
            Element propElement = serObj.addElement(property.getName());
            if (currentValue == null) {
                propElement.addAttribute("action", DcAction.PropertyAction_SetNull.getActionName());
            } else if (!this._binder.isSerializeDefaultValue() && !property.shouldSerializeValue(currentEntity)) {
                propElement.addAttribute("action", DcAction.PropertyAction_Reset.getActionName());
            } else {
                this.tempRef_isCData.argvalue = false;
                String valueToString = null;
                valueToString = currentValue instanceof ILocaleValue ? this.convertToString(property, currentEntity, currentValue, this.tempRef_isCData) : (currentValue instanceof Map || currentValue instanceof List ? SerializationUtils.toJsonString(currentValue) : this.convertToString(property, currentEntity, currentValue, this.tempRef_isCData));
                if (((Boolean)this.tempRef_isCData.argvalue).booleanValue()) {
                    propElement.addCDATA(valueToString == null ? "" : valueToString);
                } else {
                    propElement.addText(valueToString == null ? "" : valueToString);
                }
            }
        }
    }

    private void WriteSimpleProperties_S(Element serObj, ISimpleProperty property, Object entity) {
        if (this._binder.writeSimpleProperty(serObj, property, entity)) {
            return;
        }
        if (this._binder.isSerializeDefaultValue() || property.shouldSerializeValue(entity)) {
            Element propElement = serObj.addElement(property.getName());
            Object value = property.getValue(entity);
            if (null == value) {
                propElement.addAttribute("action", DcAction.PropertyAction_SetNull.getActionName());
            } else if (value instanceof ILocaleValue && this._isLocaleValueFull) {
                propElement.addText(SerializationUtils.toJsonString(value));
            } else if (value instanceof ILocaleValue) {
                String valueToString = this.convertToString(property, entity, ((ILocaleValue)value).getItem(this._binder.getLCId()), this.tempRef_isCData);
                valueToString = valueToString == null ? "" : valueToString;
                propElement.addText(valueToString);
            } else if (value instanceof Map || value instanceof List) {
                propElement.addText(SerializationUtils.toJsonString(value));
            } else {
                this.tempRef_isCData.argvalue = false;
                String valueToString = this.convertToString(property, entity, value, this.tempRef_isCData);
                String string = valueToString = valueToString == null ? "" : valueToString;
                if (((Boolean)this.tempRef_isCData.argvalue).booleanValue()) {
                    propElement.addCDATA(valueToString);
                } else {
                    propElement.addText(valueToString);
                }
            }
        }
    }

    private void WriteComplexProperties(Element serObj, IComplexProperty property, Object currentEntity, Object baseEntity) {
        Object currentValue = property.getValue(currentEntity);
        Object baseValue = property.getValue(baseEntity);
        if (currentValue == null) {
            if (baseValue != null) {
                Element propElement = serObj.addElement(property.getName());
                propElement.addAttribute("action", DcAction.PropertyAction_SetNull.getActionName());
            }
        } else {
            Element propElement = serObj.addElement(property.getName());
            Element childElement = this.WriteObject((Branch)propElement, property.getComplexType(), currentValue, baseValue, null);
            if (childElement.elements().size() == 0) {
                serObj.remove(propElement);
            }
        }
    }

    private void WriteCollectionProperties(Element serObj, final ICollectionProperty property, final IDataEntityType currentEntityType, Object currentEntity, Object baseEntity) {
        Object currentValue = property.getValue(currentEntity);
        Object baseValue = property.getValue(baseEntity);
        if (currentValue == null) {
            if (baseValue != null) {
                Element propElement = serObj.addElement(property.getName());
                propElement.addAttribute("action", DcAction.PropertyAction_SetNull.getActionName());
            }
        } else if (baseValue == null) {
            this.WriteCollectionProperty(serObj, property, currentValue);
        } else {
            final ISupplier<String> getMessage = new ISupplier<String>(){

                @Override
                public String get() {
                    return String.format(ResManager.loadKDString("\u5728\u5e8f\u5217\u5316\u5bf9\u8c61%1$s\u7684\u96c6\u5408\u5c5e\u6027%2$s\u65f6\uff0c", "DcxmlSerializerWriteImplement_1", SubSystemType.BOS, new Object[0]), currentEntityType.getName(), property.getName());
                }
            };
            final List currentList = (List)(currentValue instanceof List ? currentValue : null);
            if (currentList == null) {
                throw new OrmException("WriteCollectionProperties", String.format(ResManager.loadKDString("%1$s\u53d1\u73b0\u5176(\u5f53\u524d\u5217\u8868)\u5c5e\u6027\u7684\u8fd4\u56de\u7c7b\u578b%2$s\u4e0d\u652f\u6301IEnumerable\u63a5\u53e3\u3002", "DcxmlSerializerWriteImplement_2", SubSystemType.BOS, new Object[0]), getMessage.get(), property.getPropertyType().getName()));
            }
            final List baseList = (List)(baseValue instanceof List ? baseValue : null);
            if (baseList == null) {
                throw new OrmException("WriteCollectionProperties", String.format(ResManager.loadKDString("%1$s\u53d1\u73b0\u5176\uff08\u57fa\u5217\u8868\uff09\u5c5e\u6027\u7684\u8fd4\u56de\u7c7b\u578b%2$s\u4e0d\u652f\u6301IEnumerable\u63a5\u53e3\u3002", "DcxmlSerializerWriteImplement_3", SubSystemType.BOS, new Object[0]), getMessage.get(), property.getPropertyType().getSigners()));
            }
            final Element propElement = serObj.addElement(property.getName());
            DefaultSyncFunction<Object, Object> syncFunc = new DefaultSyncFunction<Object, Object>(){

                @Override
                public boolean equals(Object s, Object t) {
                    return DcxmlSerializerWriteImplement.this.listItemEquatable(currentList, baseList, s, t, getMessage);
                }

                @Override
                public void update(Object s, Object t) {
                    DcxmlSerializerWriteImplement.this.WriteEditObject(propElement, property.getItemType(), s, t);
                }

                @Override
                public void add(List<Object> col, Object item) {
                    DcxmlSerializerWriteImplement.this.WriteAddObject(propElement, property.getItemType(), item);
                }

                @Override
                public Object create(Object o) {
                    return o;
                }

                @Override
                public void remove(List<Object> col, Object item, int index) {
                    DcxmlSerializerWriteImplement.this.WriteRemoveObject(propElement, item);
                }
            };
            ListSync.Sync(currentList, baseList, syncFunc, true);
            if (propElement.elements().size() == 0) {
                serObj.remove(propElement);
            }
        }
    }

    private void WriteEditObject(Element parentElement, IDataEntityType currentEntityType, Object currentEntity, Object baseEntity) {
        Element val = this.WriteObject((Branch)parentElement, currentEntityType, currentEntity, baseEntity, DcAction.ListAction_Edit);
        if (!this.IsNeedWrite(val)) {
            parentElement.remove(val);
        }
    }

    private boolean IsNeedWrite(Element val) {
        return val.elements().size() > 0;
    }

    private void WriteAddObject(Element parentElement, IDataEntityType currentEntityType, Object currentEntity) {
        this.WriteObject((Branch)parentElement, currentEntityType, currentEntity, null, DcAction.ListAction_Add);
    }

    private void WriteRemoveObject(Element parentElement, Object t) {
        IDataEntityType dt = this._binder.getDataEntityType(t);
        ISimpleProperty pk = dt.getPrimaryKey();
        Element item = parentElement.addElement(this._binder.bindToName(dt));
        item.addAttribute("action", DcAction.ListAction_Remove.getActionName());
        item.addAttribute("oid", this.convertToString(pk, t, pk.getValue(t)));
    }

    private void WriteCollectionProperties_S(Element serObj, ICollectionProperty property, Object entity) {
        this.WriteCollectionProperty(serObj, property, property.getValue(entity));
    }

    private void WriteCollectionProperty(Element serObj, ICollectionProperty property, Object value) {
        List listValue = (List)(value instanceof List ? value : null);
        if (listValue != null && listValue.size() > 0) {
            Element propElement = serObj.addElement(property.getName());
            for (Object item : listValue) {
                this.WriteObject((Branch)propElement, property.getItemType(), item, null, DcAction.ListAction_Add);
            }
        }
    }

    private void WriteComplexProperties_S(Element serObj, IComplexProperty property, Object entity) {
        Element propElement;
        Element el;
        Object value = property.getValue(entity);
        if (value != null && (el = this.WriteObject((Branch)(propElement = serObj.addElement(property.getName())), property.getComplexType(), value, null, null)).elements().size() == 0) {
            serObj.remove(propElement);
        }
    }
}

