/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.serialization;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class SerializationUtils {
    private static ObjectMapper omap;
    private static ObjectMapper omap2;
    private static SimpleDateFormat sdf;
    private static String defDateFmtStr;
    private static String defShotDateFmtStr;
    private static String SPAN_TYPE_SERIALIZATION;
    private static String SPAN_PARAM_CONTENT;
    private static String SPAN_PARAM_TYPE;

    public static ObjectMapper getObjectMapper2() {
        if (omap2 != null) {
            return omap2;
        }
        ObjectMapper lomap2 = SerializationUtils.createStdObjectMapper();
        lomap2.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule("Map", new Version(1, 0, 0, "", "", ""));
        module.addSerializer(Map.class, (JsonSerializer)new JsonSerializer<Map>(){
            private ObjectMapper std;

            public void serialize(Map value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                ObjectMapper mapper = this.getStdObjectMapper();
                mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
                JsonSerializer ser = mapper.getSerializerProviderInstance().findTypedValueSerializer(Map.class, true, null);
                ser.serialize((Object)value, jgen, provider);
            }

            private ObjectMapper getStdObjectMapper() {
                if (this.std != null) {
                    return this.std;
                }
                this.std = SerializationUtils.createStdObjectMapper();
                return this.std;
            }
        });
        lomap2.registerModule((Module)module);
        omap2 = lomap2;
        return omap2;
    }

    private static ObjectMapper getObjectMapper() {
        if (omap != null) {
            return omap;
        }
        omap = SerializationUtils.createStdObjectMapper();
        return omap;
    }

    private static ObjectMapper createStdObjectMapper() {
        ObjectMapper lomap = new ObjectMapper();
        lomap.setDateFormat((DateFormat)sdf);
        lomap.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        lomap.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        return lomap;
    }

    public static <T> T fromJsonString(String content, Class<?> valueType) {
        try (EntityTraceSpan span = null;){
            span = EntityTracer.create(SPAN_TYPE_SERIALIZATION, "fromJsonString", EntityTraceHint.getHintDisLinkAPM());
            if (span.isRealtime()) {
                span.addLocaleTag(SPAN_PARAM_CONTENT, content);
                span.addLocaleTag(SPAN_PARAM_TYPE, valueType == null ? "" : valueType.getName());
            }
            Object object = SerializationUtils.getObjectMapper().readValue(content, valueType);
            return (T)object;
        }
    }

    public static List<?> fromJsonStringToList(String content, Class<?> itemType) {
        ObjectMapper lomap = SerializationUtils.getObjectMapper();
        JavaType valueType = lomap.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{itemType});
        try (EntityTraceSpan span = null;){
            span = EntityTracer.create(SPAN_TYPE_SERIALIZATION, "fromJsonStringToList", EntityTraceHint.getHintDisLinkAPM());
            List list = (List)lomap.readValue(content, valueType);
            return list;
        }
    }

    private static boolean showDetailMsg() {
        return Boolean.getBoolean("bos.serializeutil.showdetailerrmsg");
    }

    public static String toJsonString(Object o) {
        return SerializationUtils.toJsonString(o, true);
    }

    private static ObjectMapper createAloneObjectMapper(boolean inclusionNON_NULL, boolean ignoreGL) {
        SimpleModule module;
        ObjectMapper lomap2 = SerializationUtils.createStdObjectMapper();
        if (inclusionNON_NULL) {
            lomap2.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            module = new SimpleModule("Map", new Version(1, 0, 0, "", "", ""));
            module.addSerializer(Map.class, (JsonSerializer)new JsonSerializer<Map>(){
                private ObjectMapper std;

                public void serialize(Map paramT, JsonGenerator jgen, SerializerProvider paramSerializerProvider) throws IOException {
                    ObjectMapper mapper = this.getStdObjectMapper();
                    mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
                    JsonSerializer ser = mapper.getSerializerProviderInstance().findTypedValueSerializer(Map.class, true, null);
                    ser.serialize((Object)paramT, jgen, paramSerializerProvider);
                }

                private ObjectMapper getStdObjectMapper() {
                    if (this.std != null) {
                        return this.std;
                    }
                    this.std = SerializationUtils.createStdObjectMapper();
                    return this.std;
                }
            });
            lomap2.registerModule((Module)module);
        }
        if (ignoreGL) {
            module = new SimpleModule("ILocaleString", new Version(1, 0, 0, "", "", ""));
            module.addSerializer(ILocaleString.class, (JsonSerializer)new JsonSerializer<ILocaleString>(){

                public void serialize(ILocaleString obj, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                    jgen.writeStartObject();
                    if (obj == null) {
                        jgen.writeEndObject();
                        return;
                    }
                    for (Map.Entry it : obj.entrySet()) {
                        if ("GLang".equals(it.getKey()) || it.getKey() == null) continue;
                        jgen.writeFieldName((String)it.getKey());
                        jgen.writeObject(it.getValue());
                    }
                    jgen.writeEndObject();
                }
            });
            lomap2.registerModule((Module)module);
        }
        return lomap2;
    }

    public static String toJsonString(Object o, boolean inclusionNON_NULL, OperateOption option) {
        ObjectMapper om;
        String result = null;
        RefObject<String> opValue = new RefObject<String>();
        boolean createAloneClient = false;
        boolean ignoreGL = false;
        if (option.tryGetVariableValue("ignoreGL", opValue)) {
            createAloneClient = ignoreGL = Boolean.parseBoolean(opValue.getValue());
        }
        String dateFmtStr = defDateFmtStr;
        if (option.tryGetVariableValue("datesdf", opValue)) {
            dateFmtStr = opValue.getValue();
            createAloneClient = createAloneClient || StringUtils.isNotBlank(dateFmtStr);
        }
        String shortDateFmtStr = defShotDateFmtStr;
        if (option.tryGetVariableValue("dateshortsdf", opValue)) {
            shortDateFmtStr = opValue.getValue();
            createAloneClient = createAloneClient || StringUtils.isNotBlank(shortDateFmtStr);
        }
        String zoneId = "";
        if (option.tryGetVariableValue("timeZoneId", opValue)) {
            zoneId = opValue.getValue();
            boolean bl = createAloneClient = createAloneClient || StringUtils.isNotBlank(zoneId);
        }
        if (createAloneClient) {
            om = SerializationUtils.createAloneObjectMapper(inclusionNON_NULL, ignoreGL);
            final SimpleDateFormat aloneShortSDF = new SimpleDateFormat(shortDateFmtStr);
            SimpleDateFormat aloneSdf = new SimpleDateFormat(dateFmtStr){
                private static final long serialVersionUID = 1L;

                @Override
                public Date parse(String source) throws ParseException {
                    if (source == null) {
                        return null;
                    }
                    if (source.length() <= 10) {
                        return aloneShortSDF.parse(source);
                    }
                    return super.parse(source);
                }
            };
            if (StringUtils.isNotBlank(zoneId)) {
                TimeZone tz = TimeZone.getTimeZone(zoneId);
                aloneSdf.setTimeZone(tz);
                aloneShortSDF.setTimeZone(tz);
            }
            om.setDateFormat((DateFormat)aloneSdf);
        } else {
            om = inclusionNON_NULL ? SerializationUtils.getObjectMapper2() : SerializationUtils.getObjectMapper();
        }
        try {
            result = om.writeValueAsString(o);
            return result;
        }
        catch (Exception e) {
            if (SerializationUtils.showDetailMsg()) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException("Serialize.toJsonString err");
        }
    }

    public static String toJsonString(Object o, boolean inclusionNON_NULL) {
        return SerializationUtils.toJsonString(o, inclusionNON_NULL, OperateOption.create());
    }

    public static String intArrayToString(byte[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(array.length * 3);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static byte[] stringToIntArray(String arrayString) {
        if (StringUtils.isEmpty(arrayString)) {
            return null;
        }
        ArrayList<Byte> list = new ArrayList<Byte>(Math.max(arrayString.length() / 3, 1));
        for (String item : arrayString.split("[,]", -1)) {
            list.add(Byte.parseByte(item));
        }
        byte[] rets = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            rets[i] = (Byte)list.get(i);
        }
        return rets;
    }

    public static byte[] toByte(Object o) {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            byte[] bytes = baos.toByteArray();
            return bytes;
        }
        catch (Exception e) {
            if (SerializationUtils.showDetailMsg()) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException("Serialize.toByte err");
        }
    }

    public static Object fromByte(byte[] bytes) {
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (Exception e) {
            if (SerializationUtils.showDetailMsg()) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException("Serialize.fromByte err");
        }
    }

    public static String serializeToBase64(Object o) {
        return Base64.getEncoder().encodeToString(SerializationUtils.toByte(o));
    }

    public static <T> T deSerializeFromBase64(String base64String) {
        return (T)SerializationUtils.fromByte(Base64.getDecoder().decode(base64String));
    }

    public static String toJSONStringForTS(Object obj) {
        return JSON.toJSONString((Object)obj);
    }

    public static String serializeToBase64ForTS(Object obj) {
        String json = SerializationUtils.toJSONStringForTS(obj);
        return SerializationUtils.serializeToBase64(json);
    }

    static /* synthetic */ String access$000() {
        return defShotDateFmtStr;
    }

    static {
        defDateFmtStr = "yyyy-MM-dd HH:mm:ss";
        defShotDateFmtStr = "yyyy-MM-dd";
        SPAN_TYPE_SERIALIZATION = "SerializationUtils";
        SPAN_PARAM_CONTENT = "content";
        SPAN_PARAM_TYPE = "type";
        sdf = new SimpleDateFormat(defDateFmtStr){
            private static final long serialVersionUID = 1L;
            private SimpleDateFormat shortSDF = new SimpleDateFormat(SerializationUtils.access$000());

            @Override
            public Date parse(String source) throws ParseException {
                if (source == null) {
                    return null;
                }
                if (source.length() <= 10) {
                    return this.shortSDF.parse(source);
                }
                return super.parse(source);
            }
        };
    }
}

