/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.trace.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.trace.EntityTraceConfig;
import kd.bos.dataentity.trace.EntityTraceListener;
import kd.bos.dataentity.trace.EntityTraceSpanInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class EntityTraceListenerProxy {
    private static final Log LOG = LogFactory.getLog(EntityTraceListenerProxy.class);
    private static ThreadLocal<Set<String>> expCL = new ThreadLocal();
    private List<EntityTraceListener> listeners = new ArrayList<EntityTraceListener>(8);
    private EntityTraceConfig config;
    private long userId = 0L;

    EntityTraceListenerProxy() {
    }

    public void init() {
        this.listeners.clear();
    }

    public void addListener(List<EntityTraceListener> listeners) {
        if (listeners != null) {
            this.listeners.addAll(listeners);
        }
    }

    public void addListener(EntityTraceListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public EntityTraceConfig getConfig() {
        return this.config;
    }

    public void setConfig(EntityTraceConfig config) {
        this.config = config;
        for (EntityTraceListener listener : this.listeners) {
            listener.setConfig(config);
        }
        this.userId = RequestContext.get().getCurrUserId();
    }

    public boolean isCurrentUserId() {
        return Long.compare(this.userId, RequestContext.get().getCurrUserId()) == 0;
    }

    public void fireCreate(EntityTraceSpanInfo span) {
        for (EntityTraceListener listener : this.listeners) {
            try {
                listener.create(span);
            }
            catch (Exception exp) {
                Set<String> expClasses = expCL.get();
                if (expClasses == null) {
                    expClasses = new HashSet<String>(this.listeners.size());
                }
                if (!expClasses.add(listener.getClass().getName())) continue;
                LOG.error((Throwable)exp);
            }
        }
    }

    public void fireEvent(EntityTraceSpanInfo span, String event) {
        for (EntityTraceListener listener : this.listeners) {
            try {
                listener.event(span, event);
            }
            catch (Exception exp) {
                Set<String> expClasses = expCL.get();
                if (expClasses == null) {
                    expClasses = new HashSet<String>(this.listeners.size());
                }
                if (!expClasses.add(listener.getClass().getName())) continue;
                LOG.error((Throwable)exp);
            }
        }
    }

    public void throwException(EntityTraceSpanInfo span, String msg, Throwable e) {
        for (EntityTraceListener listener : this.listeners) {
            try {
                listener.throwException(span, msg, e);
            }
            catch (Exception exp) {
                Set<String> expClasses = expCL.get();
                if (expClasses == null) {
                    expClasses = new HashSet<String>(this.listeners.size());
                }
                if (!expClasses.add(listener.getClass().getName())) continue;
                LOG.error((Throwable)exp);
            }
        }
    }

    public void ignoreException(EntityTraceSpanInfo span) {
        for (EntityTraceListener listener : this.listeners) {
            try {
                listener.ignoreException(span);
            }
            catch (Exception exp) {
                Set<String> expClasses = expCL.get();
                if (expClasses == null) {
                    expClasses = new HashSet<String>(this.listeners.size());
                }
                if (!expClasses.add(listener.getClass().getName())) continue;
                LOG.error((Throwable)exp);
            }
        }
    }

    public void fireError(EntityTraceSpanInfo span, String msg, Throwable e) {
        for (EntityTraceListener listener : this.listeners) {
            try {
                listener.error(span, msg, e);
            }
            catch (Exception exp) {
                Set<String> expClasses = expCL.get();
                if (expClasses == null) {
                    expClasses = new HashSet<String>(this.listeners.size());
                }
                if (!expClasses.add(listener.getClass().getName())) continue;
                LOG.error((Throwable)exp);
            }
        }
    }

    public void fireClose(EntityTraceSpanInfo span) {
        for (EntityTraceListener listener : this.listeners) {
            try {
                listener.close(span);
            }
            catch (Exception exp) {
                Set<String> expClasses = expCL.get();
                if (expClasses == null) {
                    expClasses = new HashSet<String>(this.listeners.size());
                }
                if (!expClasses.add(listener.getClass().getName())) continue;
                LOG.error((Throwable)exp);
            }
        }
    }
}

