/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dataentity.trace.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTraceSpanInfo;
import kd.bos.dataentity.trace.internal.EntityTraceListenerProxy;
import kd.bos.dataentity.trace.internal.EntityTracerImpl;
import kd.bos.db.DB;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

class EntityTraceSpanImpl
implements EntityTraceSpan,
EntityTraceSpanInfo {
    private static ThreadLocal<EntityTraceSpanImpl> tl = new ThreadLocal();
    private EntityTraceSpanImpl parent = null;
    private String callFrom;
    private Long id;
    private boolean writeTag;
    private EntityTraceListenerProxy listenerProxy;
    private Map<String, String> tags = new LinkedHashMap<String, String>(4);
    private Map<String, Object> localeTags = new LinkedHashMap<String, Object>(4);
    private TraceSpan innerSpan;
    private String type;
    private String name;
    private long startTime = System.currentTimeMillis();

    public EntityTraceSpanImpl(String type, String name, EntityTraceHint hint) {
        this.parent = tl.get();
        tl.set(this);
        this.listenerProxy = this.parent == null ? EntityTracerImpl.getEntityTraceListenerProxy() : this.parent.listenerProxy;
        this.type = type;
        this.name = name;
        if (hint == null || hint.isLinkToApm()) {
            this.innerSpan = Tracer.create((String)type, (String)name, (boolean)false);
        }
        if (this.listenerProxy != null) {
            this.listenerProxy.fireCreate(this);
        }
    }

    public static EntityTraceSpanImpl getCurrent() {
        return tl.get();
    }

    @Override
    public void close() {
        if (this.listenerProxy != null) {
            this.listenerProxy.fireClose(this);
        }
        if (this.innerSpan != null) {
            this.innerSpan.close();
        }
        tl.set(this.parent);
    }

    @Override
    public EntityTraceSpan addTag(String key, String value) {
        return this.addTag(key, value, false);
    }

    @Override
    public EntityTraceSpan addTag(String key, String value, boolean force) {
        if (this.innerSpan != null) {
            this.innerSpan.addTag(key, value, force);
        }
        this.tags.put(key, value);
        return this;
    }

    @Override
    public EntityTraceSpan logEvent(String event) {
        if (this.innerSpan != null) {
            this.innerSpan.logEvent(event);
        }
        this.fireEvent(event);
        return this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getCost() {
        return this.innerSpan == null ? (int)(System.currentTimeMillis() - this.startTime) : this.innerSpan.getCost();
    }

    @Override
    public long getStartTime() {
        return this.innerSpan == null ? this.startTime : this.innerSpan.getStartTime();
    }

    @Override
    public void methodInstrumentForThreaddump() {
        if (this.innerSpan != null) {
            this.innerSpan.methodInstrumentForThreaddump();
        }
    }

    @Override
    public boolean isRealtime() {
        if (this.listenerProxy == null || this.listenerProxy.getConfig() == null) {
            return false;
        }
        return this.listenerProxy.getConfig().isRealtime();
    }

    @Override
    public EntityTraceSpan addLocaleTag(String key, Object value) {
        this.localeTags.put(key, value);
        return this;
    }

    @Override
    public void fireEvent(String event) {
        if (this.listenerProxy != null) {
            this.listenerProxy.fireEvent(this, event);
        }
    }

    @Override
    public void throwException(String msg) {
        if (this.listenerProxy != null) {
            this.listenerProxy.throwException(this, msg, null);
        }
    }

    @Override
    public void throwException(Throwable e) {
        if (this.listenerProxy != null) {
            this.listenerProxy.throwException(this, null, e);
        }
    }

    @Override
    public void throwException(String msg, Throwable e) {
        if (this.listenerProxy != null) {
            this.listenerProxy.throwException(this, msg, e);
        }
    }

    @Override
    public void ignoreException() {
        if (this.listenerProxy != null) {
            this.listenerProxy.ignoreException(this);
        }
    }

    @Override
    public void error(String msg) {
        if (this.listenerProxy != null) {
            this.listenerProxy.fireError(this, msg, null);
        }
    }

    @Override
    public void error(Throwable e) {
        if (this.listenerProxy != null) {
            this.listenerProxy.fireError(this, null, e);
        }
    }

    @Override
    public void error(String msg, Throwable e) {
        if (this.listenerProxy != null) {
            this.listenerProxy.fireError(this, msg, e);
        }
    }

    @Override
    public long getId() {
        if (this.id == null) {
            this.id = DB.genGlobalLongId();
        }
        return this.id;
    }

    @Override
    public long getPId() {
        if (this.parent != null) {
            return this.parent.getId();
        }
        return 0L;
    }

    @Override
    public EntityTraceSpanInfo getParent() {
        return this.parent;
    }

    @Override
    public boolean isRootSpan() {
        return this.parent == null;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public Map<String, Object> getLocaleTags() {
        return this.localeTags;
    }

    @Override
    public List<Map<String, Object>> getCallStack() {
        List<Map<String, Object>> callStack = this.parent != null ? this.parent.getCallStack() : new ArrayList<Map<String, Object>>(8);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("type", this.getType());
        map.put("name", this.getName());
        map.put("tags", new HashMap<String, String>(this.tags));
        map.put("localetags", new HashMap<String, Object>(this.localeTags));
        callStack.add(map);
        return callStack;
    }

    @Override
    public String getCallFrom() {
        if (this.callFrom == null) {
            this.callFrom = String.format("at %s.%s() %s%s", this.getType(), this.getName(), System.lineSeparator(), this.parent == null ? "" : this.parent.getCallFrom());
        }
        return this.callFrom;
    }

    @Override
    public String buildSpanInfo() {
        if (this.tags.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> tag : this.tags.entrySet()) {
            sb.append(tag.getKey()).append(" = '").append(tag.getValue()).append("', ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    @Override
    public boolean isWriteTag() {
        return this.writeTag;
    }

    @Override
    public void setWriteTag(boolean writeTag) {
        this.writeTag = writeTag;
    }
}

