/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.bundle.Resources;
import kd.bos.dts.OutputIUD;
import kd.bos.dts.RowInfo;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.exception.ApplyException;
import kd.bos.dts.init.QueryAndImport;
import kd.bos.dts.log.DtsStatusReporterFactory;
import kd.bos.dts.oplog.Oplog;
import kd.bos.dts.retry.Retry;
import kd.bos.dts.syncconfig.SyncConfigInfo;
import kd.bos.orm.datasync.ColumnInfo;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DeleteDataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.UpsertDataSyncValue;
import kd.bos.orm.query.QFilter;

public abstract class AbstractOutput
implements OutputIUD {
    protected DestinationTransRule destinationRule;
    protected String region;

    public AbstractOutput(DestinationTransRule destinationRule) {
        this.destinationRule = destinationRule;
        this.region = destinationRule.getRegion();
    }

    @Override
    public void trans(String type, DataSyncValue value) {
        long accpettime = System.currentTimeMillis() - value.getTimestap();
        ArrayList<RowInfo> esconsumers = new ArrayList<RowInfo>();
        Consumer<ApplyException> logOp = e -> {
            Thread.interrupted();
            List ids = e.getErrorIds();
            String entityNumber = value.getEntityNumber();
            String msg = e.getMsg() + ",failureIds:" + ids;
            Oplog.get().error(this.destinationRule.getType().getName() + "-" + this.destinationRule.getRegion(), "type", entityNumber, ids.size(), msg);
            DestinationRuleConfig entityRuleConfig = DestinationRuleConfig.get((String)entityNumber, (DestinationTransRule)this.destinationRule);
            DtsStatusReporterFactory.get().confInitCountReportError((Exception)((Object)e), entityRuleConfig, ids.size(), "type");
            Retry.get().send(this.destinationRule, entityNumber, ids);
        };
        ArrayList<Object> sourceIds = new ArrayList<Object>();
        try {
            if (OperationType.DELETE.getName().equals(type)) {
                DeleteDataSyncValue deleteValue = (DeleteDataSyncValue)value;
                for (Object obj : deleteValue.getOids()) {
                    RowInfo r = new RowInfo();
                    r.setType(type);
                    r.setKey(obj);
                    r.setTable(deleteValue.getTableName().toLowerCase());
                    r.setEntityNumber(value.getEntityNumber());
                    esconsumers.add(r);
                    sourceIds.add(obj);
                }
                this.deleteTrans(esconsumers);
            } else if (OperationType.INSERT.getName().equals(type) || OperationType.UPDATE.getName().equals(type)) {
                UpsertDataSyncValue upsertValue = (UpsertDataSyncValue)value;
                List datas = upsertValue.getRows();
                for (int i = 0; i < datas.size(); ++i) {
                    RowInfo r = new RowInfo();
                    r.setType(type);
                    r.setTable(upsertValue.getTableName().toLowerCase());
                    r.setEntityNumber(value.getEntityNumber());
                    Object[] columnValues = (Object[])datas.get(i);
                    for (ColumnInfo columnInfo : upsertValue.getColumnsLs()) {
                        Object columnValue = columnValues[columnInfo.getColumnIndex()];
                        r.getData().put(columnInfo.getFiledName().toLowerCase(), columnValue);
                    }
                    r.setKey(upsertValue.getEntityOids().get(i));
                    esconsumers.add(r);
                }
                sourceIds.addAll(upsertValue.getEntityOids());
                if (OperationType.INSERT.getName().equals(type)) {
                    this.insertTrans(esconsumers);
                } else {
                    this.updateTrans(esconsumers);
                }
            }
            long delay = System.currentTimeMillis() - value.getTimestap();
            Oplog.get().record(this.destinationRule.getType().getName() + "-" + this.destinationRule.getRegion(), type, value.getEntityNumber(), esconsumers.size(), Resources.get((String)"bos-dts", (String)"AbstractOutput_0", (String)"accpet:{0}ms, \u5ef6\u65f6:{1} ms,", (Object[])new Object[]{accpettime, delay}));
        }
        catch (Exception e2) {
            if (e2 instanceof ApplyException) {
                logOp.accept((ApplyException)((Object)e2));
            }
            ApplyException ae = new ApplyException(e2.getMessage(), sourceIds, e2);
            logOp.accept(ae);
        }
    }

    @Override
    public void reTrans(String type, DataSyncValue value, String configOperateType, String entityfields) {
        UpsertDataSyncValue upsertValue;
        ArrayList<RowInfo> esconsumers = new ArrayList<RowInfo>();
        ArrayList oidParams = new ArrayList();
        if (OperationType.DELETE.getName().equals(type)) {
            DeleteDataSyncValue deleteValue = (DeleteDataSyncValue)value;
            for (Object obj : deleteValue.getOids()) {
                RowInfo r = new RowInfo();
                r.setType(type);
                r.setKey(obj);
                r.setTable(deleteValue.getTableName().toLowerCase());
                r.setEntityNumber(value.getEntityNumber());
                esconsumers.add(r);
            }
        } else if (OperationType.INSERT.getName().equals(type) || OperationType.UPDATE.getName().equals(type)) {
            upsertValue = (UpsertDataSyncValue)value;
            if (upsertValue.isLocal()) {
                return;
            }
            List datas = upsertValue.getRows();
            for (int i = 0; i < datas.size(); ++i) {
                RowInfo r = new RowInfo();
                r.setType(OperationType.DELETE.getName());
                r.setTable(upsertValue.getTableName().toLowerCase());
                r.setEntityNumber(value.getEntityNumber());
                Object oids = upsertValue.getEntityOids().get(i);
                r.setKey(oids);
                oidParams.add(oids);
                esconsumers.add(r);
            }
        }
        this.deleteTrans(esconsumers);
        if (OperationType.DELETE.getName().equals(configOperateType)) {
            return;
        }
        upsertValue = (UpsertDataSyncValue)value;
        String entityNumber = value.getEntityNumber();
        String mainPkName = upsertValue.getMainPKName();
        QFilter filter = new QFilter(mainPkName, "in", oidParams);
        QFilter[] filters = new QFilter[]{filter};
        SyncConfigInfo scinfo = new SyncConfigInfo();
        scinfo.setEntitynumber(entityNumber);
        scinfo.setConfiggedEntityfields(entityfields);
        Consumer<List<RowInfo>> consumer = data -> this.insertTrans((List<RowInfo>)data);
        QueryAndImport.get().importData(this.destinationRule, scinfo, 1000, consumer, filters);
    }
}

