/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dts.Output;
import kd.bos.dts.OutputIUD;
import kd.bos.dts.factorycreator.OutputCreator;
import kd.bos.extension.ExtensionFactory;
import kd.bos.orm.datasync.DestinationTransRule;

public class OutputFactory {
    private static ConcurrentHashMap<String, Output> outputMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Output> sqloutputMap = new ConcurrentHashMap();
    private static ExtensionFactory<OutputCreator> lookupFactory = ExtensionFactory.getExtensionFacotry(OutputCreator.class);

    public static Output getOutputter(DestinationTransRule ruleType) {
        String destType = ruleType.getType().getName();
        String region = ruleType.getRegion();
        String mappingRule = ruleType.getMappingrule();
        String key = destType + region + mappingRule;
        return outputMap.computeIfAbsent(key, x -> {
            OutputCreator creator = (OutputCreator)lookupFactory.getExtension(destType, false);
            creator.setRuleType(ruleType);
            return creator.createOutput();
        });
    }

    public static Output getSqlOutputter(DestinationTransRule ruleType) {
        String destType = ruleType.getType().getName();
        String region = ruleType.getRegion();
        String mappingRule = ruleType.getMappingrule();
        String key = destType + region + mappingRule;
        return sqloutputMap.computeIfAbsent(key, x -> {
            OutputCreator creator = (OutputCreator)lookupFactory.getExtension(destType, false);
            creator.setRuleType(ruleType);
            return creator.createSqlOutput();
        });
    }

    public static OutputIUD getOutputterIUD(DestinationTransRule ruleType) {
        return (OutputIUD)OutputFactory.getOutputter(ruleType);
    }
}

