/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.check.consistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bundle.BosRes;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.check.consistence.ConsistenceChecker;
import kd.bos.dts.check.consistence.ConsistenceCheckerFactory;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.retry.Retry;
import kd.bos.orm.ORM;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class Checker {
    private static final String STATUS = "status";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> check(DestinationRuleConfig ruleConfig) {
        HashMap<String, String> retMap = new HashMap<String, String>(2);
        String entityNumber = ruleConfig.getEntityNumber();
        DestinationTransRule transRule = ruleConfig.getRule();
        try {
            Set<Object> compare;
            ORM orm = ORM.create();
            ExceptionLogger.log(Checker.class, (String)"checker begion..");
            long sourceCount = orm.count(entityNumber, entityNumber, null);
            ExceptionLogger.log(Checker.class, (String)"checker get sourceCount:%s", (Object[])new Object[]{sourceCount});
            ConsistenceChecker cc = ConsistenceCheckerFactory.getChecker(transRule);
            long diffCount = cc.getDiffCount(sourceCount, entityNumber);
            ExceptionLogger.log(Checker.class, (String)"checker get diffCount:%s", (Object[])new Object[]{diffCount});
            if (diffCount != 0L) {
                retMap.put(STATUS, "0");
                retMap.put("msg", BosRes.get((String)"bos-dts", (String)"Checker_0", (String)"\u6570\u636e\u4e0d\u4e00\u81f4,\u6e90\u6570\u636e\u6570\u91cf:{0},\u76ee\u6807\u6570\u636e\u6570\u91cf:{1},\u662f\u5426\u4fee\u590d?", (Object[])new Object[]{sourceCount, sourceCount - diffCount}));
                return retMap;
            }
            String pkName = DtsUtils.getEntityPKName(entityNumber);
            HashSet<Object> ids = new HashSet<Object>();
            Class<?> idType = null;
            try (DataSet ds = orm.queryDataSet(entityNumber, entityNumber, pkName, null, null);){
                while (ds.hasNext()) {
                    Row r = ds.next();
                    if (idType == null) {
                        Object o = r.get(pkName);
                        idType = o.getClass();
                        ids.add(o);
                    } else {
                        ids.add(r.get(pkName));
                    }
                    if (ids.size() != 1000) continue;
                    Set<Object> compare2 = cc.checkPksExists(entityNumber, ids, idType);
                    if (!compare2.isEmpty()) {
                        retMap.put(STATUS, "0");
                        retMap.put("msg", BosRes.get((String)"bos-dts", (String)"Checker_1", (String)"\u6570\u636e\u4e0d\u4e00\u81f4,\u8fd9\u4e9b\u8bb0\u5f55\u5728\u76ee\u6807\u5730\u5740\u4e0d\u5b58\u5728\uff0c\u662f\u5426\u4fee\u590d:", (Object[])new Object[0]) + compare2);
                        HashMap<String, String> hashMap = retMap;
                        return hashMap;
                    }
                    ids.clear();
                }
            }
            if (ids.size() > 0 && !(compare = cc.checkPksExists(entityNumber, ids, idType)).isEmpty()) {
                retMap.put(STATUS, "0");
                retMap.put("msg", BosRes.get((String)"bos-dts", (String)"Checker_1", (String)"\u6570\u636e\u4e0d\u4e00\u81f4,\u8fd9\u4e9b\u8bb0\u5f55\u5728\u76ee\u6807\u5730\u5740\u4e0d\u5b58\u5728\uff0c\u662f\u5426\u4fee\u590d:", (Object[])new Object[0]) + compare);
                return retMap;
            }
            retMap.put(STATUS, "1");
            retMap.put("msg", BosRes.get((String)"bos-dts", (String)"Checker_2", (String)"\u6e90\u6570\u636e\u4e0e\u76ee\u6807\u6570\u636e\u4e00\u81f4,\u6570\u91cf: ", (Object[])new Object[0]) + sourceCount);
            return retMap;
        }
        catch (Exception e) {
            retMap.put(STATUS, "-1");
            retMap.put("msg", e.getMessage());
            return retMap;
        }
    }

    public static String parseIdStringInES(String string) {
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> checkAndRepair(DestinationRuleConfig ruleConfig) {
        String entityNumber = ruleConfig.getEntityNumber();
        DestinationTransRule transRule = ruleConfig.getRule();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ORM orm = ORM.create();
        String pkName = DtsUtils.getEntityPKName(entityNumber);
        ConsistenceChecker cc = ConsistenceCheckerFactory.getChecker(transRule);
        HashSet<Object> ids = new HashSet<Object>();
        ArrayList<Object> retryIds = new ArrayList<Object>();
        ArrayList<Object> repairedIds = new ArrayList<Object>();
        HashSet<Object> allSourceIds = new HashSet<Object>();
        Roaring64NavigableMap roarAllSourceIds = new Roaring64NavigableMap();
        boolean isLong = true;
        int batchSize = 1000;
        Class<Long> idType = null;
        try (TXHandle h = TX.required();
             DataSet ds = orm.queryDataSet(entityNumber, entityNumber, pkName, new QFilter[0], "id");){
            while (ds.hasNext()) {
                TraceSpan span;
                block46: {
                    Row r = ds.next();
                    Object o = r.get(pkName);
                    if (idType == null) {
                        idType = o.getClass();
                        ids.add(o);
                        isLong = idType.isAssignableFrom(Long.class);
                    } else {
                        ids.add(o);
                    }
                    if (isLong) {
                        roarAllSourceIds.add(new long[]{(Long)o});
                    } else {
                        allSourceIds.add(o);
                    }
                    if (ids.size() < batchSize) continue;
                    span = Tracer.create((String)"checkPksExists.queryBatch", (String)"queryPage");
                    Throwable throwable = null;
                    try {
                        retryIds.addAll(cc.checkPksExists(entityNumber, ids, idType));
                        ids.clear();
                        if (retryIds.size() > batchSize) {
                            Retry.get().retry(ruleConfig.getRule(), entityNumber, retryIds);
                            repairedIds.addAll(retryIds);
                            retryIds.clear();
                        }
                        if (span == null) continue;
                        if (throwable == null) break block46;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (span == null) throw throwable3;
                            if (throwable == null) {
                                span.close();
                                throw throwable3;
                            }
                            try {
                                span.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        span.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                span.close();
            }
            if (ids.size() > 0) {
                retryIds.addAll(cc.checkPksExists(entityNumber, ids, idType));
            }
            if (retryIds.size() > 0) {
                Retry.get().retry(ruleConfig.getRule(), entityNumber, retryIds);
                repairedIds.addAll(retryIds);
                retryIds.clear();
            }
        }
        catch (Exception e) {
            returnMap.put(STATUS, "-1");
            returnMap.put("msg", e.getMessage());
            return returnMap;
        }
        if (idType != null) {
            if (isLong) {
                retryIds.addAll(cc.checkPksNotInWithBitmap(entityNumber, roarAllSourceIds));
            } else {
                retryIds.addAll(cc.checkPksNotIn(entityNumber, allSourceIds, idType));
            }
        }
        Retry.get().retry(ruleConfig.getRule(), entityNumber, retryIds);
        returnMap.put(STATUS, "1");
        int rsize = repairedIds.size();
        returnMap.put("msg", rsize > 0 ? " have repaired " + rsize : "not need to repair");
        returnMap.put("repairIds", rsize > 50 ? " count is" + rsize : repairedIds);
        return returnMap;
    }
}

