/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.check.consistence.checker;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.check.consistence.Checker;
import kd.bos.dts.check.consistence.ConsistenceChecker;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.impl.fulltext.access.ESAccess;
import kd.bos.fulltext.common.util.CommonUtil;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class ConsistenceESChecker
implements ConsistenceChecker {
    private String region;

    @Override
    public void setRegion(String region) {
        this.region = region;
    }

    @Override
    public long getDiffCount(long sourceCount, String entityNumber) {
        return sourceCount - ESAccess.get(this.region).queryCount(this.getIndexName(), this.getIndexType(), "entityname='" + entityNumber + "'");
    }

    private String getIndexName() {
        return CommonUtil.getIndexNamePrefix((String)this.region) + "_data";
    }

    private String getIndexType() {
        return "t_data";
    }

    @Override
    public Set<Object> checkPksExists(String entityNumber, Set<Object> pks, Class<?> idType) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"entityname", (String)entityNumber));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"pkid.keyword", pks));
        List<Map<String, String>> esPksMap = ESAccess.get(this.region).query(this.getIndexName(), this.getIndexType(), new String[]{"pkid"}, (QueryBuilder)boolQueryBuilder, 0, pks.size());
        HashSet esids = new HashSet();
        boolean isLong = idType.isAssignableFrom(Long.class);
        esPksMap.forEach(v -> {
            String value = (String)v.get("pkid");
            if (isLong) {
                esids.add(Long.parseLong(value));
            } else {
                esids.add(Checker.parseIdStringInES(value));
            }
        });
        HashSet<Object> compare = new HashSet<Object>();
        pks.forEach(v -> {
            if (!esids.contains(v)) {
                compare.add(v);
            }
        });
        return compare;
    }

    @Override
    public Set<Object> checkPksNotInWithBitmap(String entityNumber, Roaring64NavigableMap roarAllSourceIds) {
        return this._checkPksNotIn(entityNumber, null, roarAllSourceIds, Long.class);
    }

    @Override
    public Set<Object> checkPksNotIn(String entityNumber, Set<Object> allSourcepks, Class<?> idType) {
        return this._checkPksNotIn(entityNumber, allSourcepks, null, idType);
    }

    private Set<Object> _checkPksNotIn(String entityNumber, Set<Object> allSourcepks, Roaring64NavigableMap roarAllSourceIds, Class<?> idType) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"entityname", (String)entityNumber));
        int batchSize = 1000;
        HashSet<Object> notExistInSource = new HashSet<Object>();
        boolean isLong = idType.isAssignableFrom(Long.class);
        boolean isSearchAfter = DtsUtils.isSearchAfter();
        String lastSearchAfter = null;
        Consumer consumer = (Consumer<List> & Serializable)configures_step -> {
            if (configures_step.isEmpty()) {
                return;
            }
            configures_step.forEach(v -> {
                Object pkid = null;
                pkid = isLong ? Long.valueOf(Long.parseLong((String)v.get("pkid"))) : Checker.parseIdStringInES((String)v.get("pkid"));
                if (allSourcepks != null && !allSourcepks.contains(pkid) || roarAllSourceIds != null && !roarAllSourceIds.contains(((Long)pkid).longValue())) {
                    notExistInSource.add(pkid);
                    if (notExistInSource.size() > batchSize * batchSize / 10) {
                        notExistInSource.clear();
                    }
                }
            });
        };
        if (isSearchAfter) {
            int i = 0;
            while (i * batchSize < 100000) {
                try {
                    List<Map<String, String>> configures_step2 = null;
                    configures_step2 = ESAccess.get(this.region).querySearchAfter(this.getIndexName(), this.getIndexType(), new String[]{"pkid"}, (QueryBuilder)boolQueryBuilder, lastSearchAfter, batchSize);
                    if (configures_step2.isEmpty()) break;
                    lastSearchAfter = configures_step2.get(configures_step2.size() - 1).get("_id");
                    consumer.accept(configures_step2);
                }
                catch (Exception e) {
                    ExceptionLogger.error(ConsistenceESChecker.class, (String)String.format("dts checkPksNotIn %s error ,batch %s, indexName=%s,suppressed:%s", entityNumber, i, this.getIndexName(), e.getSuppressed()), (Throwable)e);
                    break;
                }
                ++i;
            }
        } else {
            ESAccess.get(this.region).querySearchScroll(this.getIndexName(), this.getIndexType(), new String[]{"pkid"}, (QueryBuilder)boolQueryBuilder, batchSize, consumer);
        }
        return notExistInSource;
    }
}

