/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.config.change;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.sharding.ZKWatchValueNotifier;
import kd.bos.dts.config.change.DtsConfigChangeInfo;
import kd.bos.dts.config.change.DtsConfigChangeListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.xdb.exception.ExceptionUtil;

public class DtsConfigChangeNotifier
extends ZKWatchValueNotifier {
    private static final Log logger = LogFactory.getLog(DtsConfigChangeNotifier.class);
    private static final String DTS_CONFIG_CHANGE_WATCHER = "dts.config.change.watcher";
    private static final String FIRE_DTS_CHANGE_NOTIFY_LOCK_KEY = "/dts/fire_change_notify";
    private static final Map<String, DtsConfigChangeListener> listeners = new ConcurrentHashMap<String, DtsConfigChangeListener>(1);

    public static void registerListener(DtsConfigChangeListener listener) {
        String key = listener.getClass().getName();
        listeners.putIfAbsent(key, listener);
    }

    public static void removeListener(String key) {
        listeners.remove(key);
    }

    private static void notifyConfigChange(DtsConfigChangeInfo changeInfo) {
        logger.debug("notifyConfigChange changeInfo:" + changeInfo.toString());
        listeners.forEach((k, listener) -> listener.onConfigChange(changeInfo));
    }

    public static void fireDtsConfigChangeNotify(String businessType, String entityName, String appid) {
        String value = DtsConfigChangeListener.currentKey(businessType, entityName, appid);
        log.debug("fireDtsConfigChangeNotify " + value);
        DtsConfigChangeNotifier.fireLimit((String)FIRE_DTS_CHANGE_NOTIFY_LOCK_KEY, (String)DTS_CONFIG_CHANGE_WATCHER, (String)value);
    }

    static {
        ConfigurationChangeListener listener = new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                try {
                    DtsConfigChangeInfo ai = DtsConfigChangeListener.fromKey((String)newValue);
                    DtsConfigChangeNotifier.notifyConfigChange(ai);
                }
                catch (Throwable e) {
                    throw ExceptionUtil.wrap((Throwable)e);
                }
            }
        };
        DtsConfigChangeNotifier.observeChange((String)DTS_CONFIG_CHANGE_WATCHER, (ConfigurationChangeListener)listener);
    }
}

